/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.serveremulator;

import java.util.Arrays;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.xipki.scep.serveremulator.ScepServer;
import org.xipki.scep.util.ScepUtil;

public class ScepServerContainer {
    private Server server;

    public ScepServerContainer(int port, ScepServer scepServer) throws Exception {
        this(port, Arrays.asList((ScepServer)ScepUtil.requireNonNull((String)"scepServer", (Object)scepServer)));
    }

    public ScepServerContainer(int port, List<ScepServer> scepServers) throws Exception {
        ScepUtil.requireNonEmpty((String)"scepServers", scepServers);
        this.server = new Server(port);
        ServletHandler handler = new ServletHandler();
        this.server.setHandler((Handler)handler);
        for (ScepServer m : scepServers) {
            ServletHolder servletHolder = new ServletHolder(m.name(), (Servlet)m.getServlet());
            handler.addServletWithMapping(servletHolder, "/" + m.name() + "/pkiclient.exe");
        }
        this.server.join();
    }

    public void start() throws Exception {
        try {
            this.server.start();
        }
        catch (Exception ex) {
            this.server.stop();
            throw ex;
        }
    }

    public void stop() throws Exception {
        this.server.stop();
    }
}

