/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.serveremulator;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.xipki.scep.crypto.ScepHashAlgoType;
import org.xipki.scep.message.CaCaps;
import org.xipki.scep.serveremulator.CaEmulator;
import org.xipki.scep.serveremulator.NextCaAndRa;
import org.xipki.scep.serveremulator.RaEmulator;
import org.xipki.scep.serveremulator.ScepControl;
import org.xipki.scep.serveremulator.ScepResponder;
import org.xipki.scep.serveremulator.ScepServlet;
import org.xipki.scep.util.ScepUtil;

public class ScepServer {
    private final String name;
    private final CaCaps caCaps;
    private final boolean withRa;
    private final boolean withNextCa;
    private final boolean generateCrl;
    private final ScepControl control;
    private Long maxSigningTimeBiasInMs;
    private ScepServlet servlet;
    private Certificate caCert;
    private Certificate raCert;
    private Certificate nextCaCert;
    private Certificate nextRaCert;

    public ScepServer(String name, CaCaps caCaps, boolean withRa, boolean withNextCa, boolean generateCrl, ScepControl control) {
        this.name = ScepUtil.requireNonBlank((String)"name", (String)name);
        this.caCaps = (CaCaps)ScepUtil.requireNonNull((String)"caCaps", (Object)caCaps);
        this.control = (ScepControl)ScepUtil.requireNonNull((String)"control", (Object)control);
        this.withRa = withRa;
        this.withNextCa = withNextCa;
        this.generateCrl = generateCrl;
    }

    public String name() {
        return this.name;
    }

    public void setMaxSigningTimeBias(long ms) {
        this.maxSigningTimeBiasInMs = ms;
    }

    public ScepServlet getServlet() throws Exception {
        if (this.servlet != null) {
            return this.servlet;
        }
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA");
        kpGen.initialize(2048);
        KeyPair keypair = kpGen.generateKeyPair();
        PrivateKey rcaKey = keypair.getPrivate();
        X500Name rcaSubject = new X500Name("CN=RCA1, OU=emulator, O=xipki.org, C=DE");
        kpGen.initialize(2048);
        keypair = kpGen.generateKeyPair();
        SubjectPublicKeyInfo pkInfo = ScepUtil.createSubjectPublicKeyInfo((PublicKey)keypair.getPublic());
        X500Name subject = new X500Name("CN=CA1, OU=emulator, O=xipki.org, C=DE");
        this.caCert = ScepServer.issueSubCaCert(rcaKey, rcaSubject, pkInfo, subject, BigInteger.valueOf(2L), new Date(System.currentTimeMillis() - 600000L));
        CaEmulator ca = new CaEmulator(keypair.getPrivate(), this.caCert, this.generateCrl);
        RaEmulator ra = null;
        if (this.withRa) {
            kpGen.initialize(2048);
            keypair = kpGen.generateKeyPair();
            pkInfo = ScepUtil.createSubjectPublicKeyInfo((PublicKey)keypair.getPublic());
            subject = new X500Name("CN=RA1, OU=emulator, O=xipki.org, C=DE");
            this.raCert = ca.generateCert(pkInfo, subject);
            ra = new RaEmulator(keypair.getPrivate(), this.raCert);
        }
        NextCaAndRa nextCaAndRa = null;
        if (this.withNextCa) {
            kpGen.initialize(2048);
            keypair = kpGen.generateKeyPair();
            pkInfo = ScepUtil.createSubjectPublicKeyInfo((PublicKey)keypair.getPublic());
            subject = new X500Name("CN=CA2, OU=emulator, O=xipki.org, C=DE");
            Date startTime = new Date(System.currentTimeMillis() + 31536000000L);
            this.nextCaCert = ScepServer.issueSubCaCert(rcaKey, rcaSubject, pkInfo, subject, BigInteger.valueOf(2L), startTime);
            CaEmulator tmpCa = new CaEmulator(keypair.getPrivate(), this.nextCaCert, this.generateCrl);
            if (this.withRa) {
                kpGen.initialize(2048);
                keypair = kpGen.generateKeyPair();
                pkInfo = ScepUtil.createSubjectPublicKeyInfo((PublicKey)keypair.getPublic());
                subject = new X500Name("CN=RA2, OU=emulator, O=xipki.org, C=DE");
                Date raStartTime = new Date(startTime.getTime() + 864000000L);
                this.nextRaCert = tmpCa.generateCert(pkInfo, subject, raStartTime);
            }
            nextCaAndRa = new NextCaAndRa(this.nextCaCert, this.nextRaCert);
        }
        ScepResponder scepResponder = new ScepResponder(this.caCaps, ca, ra, nextCaAndRa, this.control);
        if (this.maxSigningTimeBiasInMs != null) {
            scepResponder.setMaxSigningTimeBias(this.maxSigningTimeBiasInMs);
        }
        this.servlet = new ScepServlet(scepResponder);
        return this.servlet;
    }

    public Certificate caCert() {
        return this.caCert;
    }

    public Certificate raCert() {
        return this.raCert;
    }

    public Certificate nextCaCert() {
        return this.nextCaCert;
    }

    public Certificate nextRaCert() {
        return this.nextRaCert;
    }

    public boolean isWithRa() {
        return this.withRa;
    }

    public boolean isWithNextCa() {
        return this.withNextCa;
    }

    public boolean isGenerateCrl() {
        return this.generateCrl;
    }

    private static Certificate issueSubCaCert(PrivateKey rcaKey, X500Name issuer, SubjectPublicKeyInfo pubKeyInfo, X500Name subject, BigInteger serialNumber, Date startTime) throws CertIOException, OperatorCreationException {
        Date notAfter = new Date(startTime.getTime() + 315360000000L);
        X509v3CertificateBuilder certGenerator = new X509v3CertificateBuilder(issuer, serialNumber, startTime, notAfter, subject, pubKeyInfo);
        X509KeyUsage ku = new X509KeyUsage(6);
        certGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)ku);
        BasicConstraints bc = new BasicConstraints(0);
        certGenerator.addExtension(Extension.basicConstraints, true, (ASN1Encodable)bc);
        String signatureAlgorithm = ScepUtil.getSignatureAlgorithm((PrivateKey)rcaKey, (ScepHashAlgoType)ScepHashAlgoType.SHA256);
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).build(rcaKey);
        return certGenerator.build(contentSigner).toASN1Structure();
    }
}

