/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.serveremulator;

import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.scep.crypto.ScepHashAlgoType;
import org.xipki.scep.exception.MessageDecodingException;
import org.xipki.scep.message.CaCaps;
import org.xipki.scep.message.DecodedPkiMessage;
import org.xipki.scep.message.EnvelopedDataDecryptor;
import org.xipki.scep.message.EnvelopedDataDecryptorInstance;
import org.xipki.scep.message.IssuerAndSubject;
import org.xipki.scep.message.NextCaMessage;
import org.xipki.scep.message.PkiMessage;
import org.xipki.scep.serveremulator.AuditEvent;
import org.xipki.scep.serveremulator.CaEmulator;
import org.xipki.scep.serveremulator.CaException;
import org.xipki.scep.serveremulator.NextCaAndRa;
import org.xipki.scep.serveremulator.RaEmulator;
import org.xipki.scep.serveremulator.ScepControl;
import org.xipki.scep.transaction.CaCapability;
import org.xipki.scep.transaction.FailInfo;
import org.xipki.scep.transaction.MessageType;
import org.xipki.scep.transaction.Nonce;
import org.xipki.scep.transaction.PkiStatus;
import org.xipki.scep.transaction.TransactionId;
import org.xipki.scep.util.ScepUtil;

public class ScepResponder {
    private static final Logger LOG = LoggerFactory.getLogger(ScepResponder.class);
    private static final long DFLT_MAX_SIGNINGTIME_BIAS = 300000L;
    private static final Set<ASN1ObjectIdentifier> AES_ENC_ALGS = new HashSet<ASN1ObjectIdentifier>();
    private final CaCaps caCaps;
    private final CaEmulator caEmulator;
    private final RaEmulator raEmulator;
    private final NextCaAndRa nextCaAndRa;
    private final ScepControl control;
    private long maxSigningTimeBiasInMs = 300000L;

    public ScepResponder(CaCaps caCaps, CaEmulator caEmulator, RaEmulator raEmulator, NextCaAndRa nextCaAndRa, ScepControl control) throws Exception {
        this.caCaps = (CaCaps)ScepUtil.requireNonNull((String)"caCaps", (Object)caCaps);
        this.caEmulator = (CaEmulator)ScepUtil.requireNonNull((String)"caEmulator", (Object)caEmulator);
        this.control = (ScepControl)ScepUtil.requireNonNull((String)"control", (Object)control);
        this.raEmulator = raEmulator;
        this.nextCaAndRa = nextCaAndRa;
        CaCaps caps = caCaps;
        if (nextCaAndRa == null) {
            caps.removeCapability(CaCapability.GetNextCACert);
        } else {
            caps.addCapability(CaCapability.GetNextCACert);
        }
    }

    public void setMaxSigningTimeBias(long ms) {
        this.maxSigningTimeBiasInMs = ms;
    }

    public ContentInfo servicePkiOperation(CMSSignedData requestContent, AuditEvent event) throws MessageDecodingException, CaException {
        X509Certificate recipientX509Obj;
        ScepUtil.requireNonNull((String)"requestContent", (Object)requestContent);
        PrivateKey recipientKey = this.raEmulator != null ? this.raEmulator.raKey() : this.caEmulator.caKey();
        Certificate recipientCert = this.raEmulator != null ? this.raEmulator.raCert() : this.caEmulator.caCert();
        try {
            recipientX509Obj = ScepUtil.toX509Cert((Certificate)recipientCert);
        }
        catch (CertificateException ex) {
            throw new MessageDecodingException("could not parse recipientCert " + recipientCert.getTBSCertificate().getSubject());
        }
        EnvelopedDataDecryptorInstance decInstance = new EnvelopedDataDecryptorInstance(recipientX509Obj, recipientKey);
        EnvelopedDataDecryptor recipient = new EnvelopedDataDecryptor(decInstance);
        DecodedPkiMessage req = DecodedPkiMessage.decode((CMSSignedData)requestContent, (EnvelopedDataDecryptor)recipient, null);
        PkiMessage rep = this.servicePkiOperation0(req, event);
        event.putEventData("pkiStatus", rep.pkiStatus());
        if (rep.pkiStatus() == PkiStatus.FAILURE) {
            event.setLevel(AuditEvent.AuditLevel.ERROR);
        }
        if (rep.failInfo() != null) {
            event.putEventData("failInfo", rep.failInfo());
        }
        String signatureAlgorithm = ScepUtil.getSignatureAlgorithm((PrivateKey)this.signingKey(), (ScepHashAlgoType)ScepHashAlgoType.forNameOrOid((String)req.digestAlgorithm().getId()));
        try {
            X509Certificate[] x509CertificateArray;
            X509Certificate jceSignerCert = ScepUtil.toX509Cert((Certificate)this.signingCert());
            if (this.control.isSendSignerCert()) {
                X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
                x509CertificateArray = x509CertificateArray2;
                x509CertificateArray2[0] = jceSignerCert;
            } else {
                x509CertificateArray = null;
            }
            X509Certificate[] certs = x509CertificateArray;
            return rep.encode(this.signingKey(), signatureAlgorithm, jceSignerCert, certs, req.signatureCert(), req.contentEncryptionAlgorithm());
        }
        catch (Exception ex) {
            throw new CaException(ex);
        }
    }

    public ContentInfo encode(NextCaMessage nextCaMsg) throws CaException {
        ScepUtil.requireNonNull((String)"nextCAMsg", (Object)nextCaMsg);
        try {
            X509Certificate[] x509CertificateArray;
            X509Certificate jceSignerCert = ScepUtil.toX509Cert((Certificate)this.signingCert());
            if (this.control.isSendSignerCert()) {
                X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
                x509CertificateArray = x509CertificateArray2;
                x509CertificateArray2[0] = jceSignerCert;
            } else {
                x509CertificateArray = null;
            }
            X509Certificate[] certs = x509CertificateArray;
            return nextCaMsg.encode(this.signingKey(), jceSignerCert, certs);
        }
        catch (Exception ex) {
            throw new CaException(ex);
        }
    }

    private PkiMessage servicePkiOperation0(DecodedPkiMessage req, AuditEvent event) throws MessageDecodingException, CaException {
        String oid;
        ScepHashAlgoType hashAlgoType;
        TransactionId tid = req.transactionId();
        PkiMessage rep = new PkiMessage(tid, MessageType.CertRep, Nonce.randomNonce());
        rep.setPkiStatus(PkiStatus.SUCCESS);
        rep.setRecipientNonce(req.senderNonce());
        if (req.failureMessage() != null) {
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(FailInfo.badRequest);
            return rep;
        }
        Boolean bo = req.isSignatureValid();
        if (bo != null && !bo.booleanValue()) {
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(FailInfo.badMessageCheck);
            return rep;
        }
        bo = req.isDecryptionSuccessful();
        if (bo != null && !bo.booleanValue()) {
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(FailInfo.badRequest);
            return rep;
        }
        Date signingTime = req.signingTime();
        if (this.maxSigningTimeBiasInMs > 0L) {
            boolean isTimeBad = false;
            if (signingTime == null) {
                isTimeBad = true;
            } else {
                long now = System.currentTimeMillis();
                long diff = now - signingTime.getTime();
                if (diff < 0L) {
                    diff = -1L * diff;
                }
                boolean bl = isTimeBad = diff > this.maxSigningTimeBiasInMs;
            }
            if (isTimeBad) {
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badTime);
                return rep;
            }
        }
        if ((hashAlgoType = ScepHashAlgoType.forNameOrOid((String)(oid = req.digestAlgorithm().getId()))) == null) {
            LOG.warn("tid={}: unknown digest algorithm {}", (Object)tid, (Object)oid);
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(FailInfo.badAlg);
            return rep;
        }
        boolean supported = false;
        if (hashAlgoType == ScepHashAlgoType.SHA1) {
            if (this.caCaps.containsCapability(CaCapability.SHA1)) {
                supported = true;
            }
        } else if (hashAlgoType == ScepHashAlgoType.SHA256) {
            if (this.caCaps.containsCapability(CaCapability.SHA256)) {
                supported = true;
            }
        } else if (hashAlgoType == ScepHashAlgoType.SHA512) {
            if (this.caCaps.containsCapability(CaCapability.SHA512)) {
                supported = true;
            }
        } else if (hashAlgoType == ScepHashAlgoType.MD5 && this.control.isUseInsecureAlg()) {
            supported = true;
        }
        if (!supported) {
            LOG.warn("tid={}: unsupported digest algorithm {}", (Object)tid, (Object)oid);
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(FailInfo.badAlg);
            return rep;
        }
        ASN1ObjectIdentifier encOid = req.contentEncryptionAlgorithm();
        if (CMSAlgorithm.DES_EDE3_CBC.equals((Object)encOid)) {
            if (!this.caCaps.containsCapability(CaCapability.DES3)) {
                LOG.warn("tid={}: encryption with DES3 algorithm is not permitted", (Object)tid, (Object)encOid);
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badAlg);
                return rep;
            }
        } else if (AES_ENC_ALGS.contains(encOid)) {
            if (!this.caCaps.containsCapability(CaCapability.AES)) {
                LOG.warn("tid={}: encryption with AES algorithm {} is not permitted", (Object)tid, (Object)encOid);
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badAlg);
                return rep;
            }
        } else if (CMSAlgorithm.DES_CBC.equals((Object)encOid)) {
            if (!this.control.isUseInsecureAlg()) {
                LOG.warn("tid={}: encryption with DES algorithm {} is not permitted", (Object)tid, (Object)encOid);
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badAlg);
                return rep;
            }
        } else {
            LOG.warn("tid={}: encryption with algorithm {} is not permitted", (Object)tid, (Object)encOid);
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(FailInfo.badAlg);
            return rep;
        }
        if (rep.pkiStatus() == PkiStatus.FAILURE) {
            return rep;
        }
        MessageType messageType = req.messageType();
        switch (messageType) {
            case PKCSReq: {
                Certificate cert;
                X500Name name;
                boolean selfSigned = req.signatureCert().getIssuerX500Principal().equals(req.signatureCert().getIssuerX500Principal());
                CertificationRequest csr = CertificationRequest.getInstance((Object)req.messageData());
                if (selfSigned && !(name = X500Name.getInstance((Object)req.signatureCert().getSubjectX500Principal().getEncoded())).equals((Object)csr.getCertificationRequestInfo().getSubject())) {
                    LOG.warn("tid={}: self-signed cert.subject != CSR.subject", (Object)tid);
                    rep.setPkiStatus(PkiStatus.FAILURE);
                    rep.setFailInfo(FailInfo.badRequest);
                    return rep;
                }
                String challengePwd = ScepResponder.getChallengePassword(csr.getCertificationRequestInfo());
                if (challengePwd == null || !this.control.secret().equals(challengePwd)) {
                    LOG.warn("challengePassword is not trusted");
                    rep.setPkiStatus(PkiStatus.FAILURE);
                    rep.setFailInfo(FailInfo.badRequest);
                }
                try {
                    cert = this.caEmulator.generateCert(csr);
                }
                catch (Exception ex) {
                    throw new CaException("system failure: " + ex.getMessage(), ex);
                }
                if (cert != null && this.control.isPendingCert()) {
                    rep.setPkiStatus(PkiStatus.PENDING);
                    break;
                }
                if (cert != null) {
                    ContentInfo messageData = this.createSignedData(cert);
                    rep.setMessageData((ASN1Encodable)messageData);
                    break;
                }
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badCertId);
                break;
            }
            case CertPoll: {
                IssuerAndSubject is = IssuerAndSubject.getInstance((Object)req.messageData());
                Certificate cert = this.caEmulator.pollCert(is.issuer(), is.subject());
                if (cert != null) {
                    rep.setMessageData((ASN1Encodable)this.createSignedData(cert));
                    break;
                }
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badCertId);
                break;
            }
            case GetCert: {
                IssuerAndSerialNumber isn = IssuerAndSerialNumber.getInstance((Object)req.messageData());
                Certificate cert = this.caEmulator.getCert(isn.getName(), isn.getSerialNumber().getValue());
                if (cert != null) {
                    rep.setMessageData((ASN1Encodable)this.createSignedData(cert));
                    break;
                }
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badCertId);
                break;
            }
            case RenewalReq: {
                Certificate cert;
                if (!this.caCaps.containsCapability(CaCapability.Renewal)) {
                    rep.setPkiStatus(PkiStatus.FAILURE);
                    rep.setFailInfo(FailInfo.badRequest);
                    break;
                }
                CertificationRequest csr = CertificationRequest.getInstance((Object)req.messageData());
                try {
                    cert = this.caEmulator.generateCert(csr);
                }
                catch (Exception ex) {
                    throw new CaException("system failure: " + ex.getMessage(), ex);
                }
                if (cert != null) {
                    rep.setMessageData((ASN1Encodable)this.createSignedData(cert));
                    break;
                }
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badCertId);
                break;
            }
            case UpdateReq: {
                Certificate cert;
                if (!this.caCaps.containsCapability(CaCapability.Update)) {
                    rep.setPkiStatus(PkiStatus.FAILURE);
                    rep.setFailInfo(FailInfo.badRequest);
                    break;
                }
                CertificationRequest csr = CertificationRequest.getInstance((Object)req.messageData());
                try {
                    cert = this.caEmulator.generateCert(csr);
                }
                catch (Exception ex) {
                    throw new CaException("system failure: " + ex.getMessage(), ex);
                }
                if (cert != null) {
                    rep.setMessageData((ASN1Encodable)this.createSignedData(cert));
                    break;
                }
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badCertId);
                break;
            }
            case GetCRL: {
                CertificateList crl;
                IssuerAndSerialNumber isn = IssuerAndSerialNumber.getInstance((Object)req.messageData());
                try {
                    crl = this.caEmulator.getCrl(isn.getName(), isn.getSerialNumber().getValue());
                }
                catch (Exception ex) {
                    throw new CaException("system failure: " + ex.getMessage(), ex);
                }
                if (crl != null) {
                    rep.setMessageData((ASN1Encodable)this.createSignedData(crl));
                    break;
                }
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badCertId);
                break;
            }
            default: {
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badRequest);
            }
        }
        return rep;
    }

    private ContentInfo createSignedData(CertificateList crl) throws CaException {
        CMSSignedData cmsSigneddata;
        CMSSignedDataGenerator cmsSignedDataGen = new CMSSignedDataGenerator();
        cmsSignedDataGen.addCRL(new X509CRLHolder(crl));
        try {
            cmsSigneddata = cmsSignedDataGen.generate((CMSTypedData)new CMSAbsentContent());
        }
        catch (CMSException ex) {
            throw new CaException(ex.getMessage(), ex);
        }
        return cmsSigneddata.toASN1Structure();
    }

    private ContentInfo createSignedData(Certificate cert) throws CaException {
        CMSSignedData cmsSigneddata;
        CMSSignedDataGenerator cmsSignedDataGen = new CMSSignedDataGenerator();
        try {
            cmsSignedDataGen.addCertificate(new X509CertificateHolder(cert));
            if (this.control.sendCaCert()) {
                cmsSignedDataGen.addCertificate(new X509CertificateHolder(this.caEmulator.caCert()));
            }
            cmsSigneddata = cmsSignedDataGen.generate((CMSTypedData)new CMSAbsentContent());
        }
        catch (CMSException ex) {
            throw new CaException(ex);
        }
        return cmsSigneddata.toASN1Structure();
    }

    public PrivateKey signingKey() {
        return this.raEmulator != null ? this.raEmulator.raKey() : this.caEmulator.caKey();
    }

    public Certificate signingCert() {
        return this.raEmulator != null ? this.raEmulator.raCert() : this.caEmulator.caCert();
    }

    public CaCaps caCaps() {
        return this.caCaps;
    }

    public CaEmulator caEmulator() {
        return this.caEmulator;
    }

    public RaEmulator raEmulator() {
        return this.raEmulator;
    }

    public NextCaAndRa nextCaAndRa() {
        return this.nextCaAndRa;
    }

    private static String getChallengePassword(CertificationRequestInfo csr) {
        ASN1Set attrs = csr.getAttributes();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(i));
            if (!PKCSObjectIdentifiers.pkcs_9_at_challengePassword.equals((Object)attr.getAttrType())) continue;
            ASN1String str = (ASN1String)attr.getAttributeValues()[0];
            return str.getString();
        }
        return null;
    }

    static {
        AES_ENC_ALGS.add(CMSAlgorithm.AES128_CBC);
        AES_ENC_ALGS.add(CMSAlgorithm.AES128_CCM);
        AES_ENC_ALGS.add(CMSAlgorithm.AES128_GCM);
        AES_ENC_ALGS.add(CMSAlgorithm.AES192_CBC);
        AES_ENC_ALGS.add(CMSAlgorithm.AES192_CCM);
        AES_ENC_ALGS.add(CMSAlgorithm.AES192_GCM);
        AES_ENC_ALGS.add(CMSAlgorithm.AES256_CBC);
        AES_ENC_ALGS.add(CMSAlgorithm.AES256_CCM);
        AES_ENC_ALGS.add(CMSAlgorithm.AES256_GCM);
    }
}

