/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.serveremulator;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import org.bouncycastle.operator.bc.BcDSAContentVerifierProviderBuilder;
import org.bouncycastle.operator.bc.BcECContentVerifierProviderBuilder;
import org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.scep.crypto.ScepHashAlgoType;
import org.xipki.scep.util.ScepUtil;

public class CaEmulator {
    public static final long MIN_IN_MS = 60000L;
    public static final long DAY_IN_MS = 86400000L;
    private static final Logger LOG = LoggerFactory.getLogger(CaEmulator.class);
    private static final DefaultDigestAlgorithmIdentifierFinder DFLT_DIGESTALG_IDENTIFIER_FINDER = new DefaultDigestAlgorithmIdentifierFinder();
    private static final Map<String, BcContentVerifierProviderBuilder> VERIFIER_PROVIDER_BUILDER = new HashMap<String, BcContentVerifierProviderBuilder>();
    private final PrivateKey caKey;
    private final Certificate caCert;
    private final X500Name caSubject;
    private final byte[] caCertBytes;
    private final boolean generateCrl;
    private final Map<BigInteger, Certificate> serialCertMap = new HashMap<BigInteger, Certificate>();
    private final Map<X500Name, Certificate> reqSubjectCertMap = new HashMap<X500Name, Certificate>();
    private final AtomicLong serialNumber = new AtomicLong(2L);
    private final AtomicLong crlNumber = new AtomicLong(2L);
    private CertificateList crl;

    public CaEmulator(PrivateKey caKey, Certificate caCert, boolean generateCrl) throws CertificateEncodingException {
        this.caKey = (PrivateKey)ScepUtil.requireNonNull((String)"caKey", (Object)caKey);
        this.caCert = (Certificate)ScepUtil.requireNonNull((String)"caCert", (Object)caCert);
        this.caSubject = caCert.getSubject();
        this.generateCrl = generateCrl;
        try {
            this.caCertBytes = caCert.getEncoded();
        }
        catch (IOException ex) {
            throw new CertificateEncodingException(ex.getMessage(), ex);
        }
    }

    public PrivateKey caKey() {
        return this.caKey;
    }

    public Certificate caCert() {
        return this.caCert;
    }

    public byte[] caCertBytes() {
        return Arrays.copyOf(this.caCertBytes, this.caCertBytes.length);
    }

    public boolean isGenerateCrl() {
        return this.generateCrl;
    }

    public Certificate generateCert(CertificationRequest csr) throws Exception {
        if (!this.verifyPopo(csr)) {
            throw new Exception("CSR invalid");
        }
        CertificationRequestInfo reqInfo = csr.getCertificationRequestInfo();
        return this.generateCert(reqInfo.getSubjectPublicKeyInfo(), reqInfo.getSubject());
    }

    public Certificate generateCert(SubjectPublicKeyInfo pubKeyInfo, X500Name subjectDn) throws Exception {
        return this.generateCert(pubKeyInfo, subjectDn, new Date(System.currentTimeMillis() - 600000L));
    }

    public Certificate generateCert(SubjectPublicKeyInfo pubKeyInfo, X500Name subjectDn, Date notBefore) throws Exception {
        ScepUtil.requireNonNull((String)"pubKeyInfo", (Object)pubKeyInfo);
        ScepUtil.requireNonNull((String)"subjectDn", (Object)subjectDn);
        ScepUtil.requireNonNull((String)"notBefore", (Object)notBefore);
        Date notAfter = new Date(notBefore.getTime() + 63072000000L);
        BigInteger tmpSerialNumber = BigInteger.valueOf(this.serialNumber.getAndAdd(1L));
        X509v3CertificateBuilder certGenerator = new X509v3CertificateBuilder(this.caSubject, tmpSerialNumber, notBefore, notAfter, subjectDn, pubKeyInfo);
        X509KeyUsage ku = new X509KeyUsage(184);
        certGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)ku);
        BasicConstraints bc = new BasicConstraints(false);
        certGenerator.addExtension(Extension.basicConstraints, true, (ASN1Encodable)bc);
        String signatureAlgorithm = ScepUtil.getSignatureAlgorithm((PrivateKey)this.caKey, (ScepHashAlgoType)ScepHashAlgoType.SHA256);
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).build(this.caKey);
        Certificate asn1Cert = certGenerator.build(contentSigner).toASN1Structure();
        this.serialCertMap.put(tmpSerialNumber, asn1Cert);
        this.reqSubjectCertMap.put(subjectDn, asn1Cert);
        return asn1Cert;
    }

    public Certificate getCert(X500Name issuer, BigInteger serialNumber) {
        if (!this.caSubject.equals((Object)issuer)) {
            return null;
        }
        return this.serialCertMap.get(serialNumber);
    }

    public Certificate pollCert(X500Name issuer, X500Name subject) {
        ScepUtil.requireNonNull((String)"issuer", (Object)issuer);
        ScepUtil.requireNonNull((String)"subject", (Object)subject);
        if (!this.caSubject.equals((Object)issuer)) {
            return null;
        }
        return this.reqSubjectCertMap.get(subject);
    }

    public synchronized CertificateList getCrl(X500Name issuer, BigInteger serialNumber) throws Exception {
        if (this.crl != null) {
            return this.crl;
        }
        Date thisUpdate = new Date();
        X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(this.caSubject, thisUpdate);
        Date nextUpdate = new Date(thisUpdate.getTime() + 2592000000L);
        crlBuilder.setNextUpdate(nextUpdate);
        Date caStartTime = this.caCert.getTBSCertificate().getStartDate().getDate();
        Date revocationTime = new Date(caStartTime.getTime() + 1L);
        if (revocationTime.after(thisUpdate)) {
            revocationTime = caStartTime;
        }
        crlBuilder.addCRLEntry(BigInteger.valueOf(2L), revocationTime, 1);
        crlBuilder.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new ASN1Integer(this.crlNumber.getAndAdd(1L)));
        String signatureAlgorithm = ScepUtil.getSignatureAlgorithm((PrivateKey)this.caKey, (ScepHashAlgoType)ScepHashAlgoType.SHA256);
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).build(this.caKey);
        X509CRLHolder crl = crlBuilder.build(contentSigner);
        return crl.toASN1Structure();
    }

    private boolean verifyPopo(CertificationRequest csr) {
        ScepUtil.requireNonNull((String)"csr", (Object)csr);
        try {
            PKCS10CertificationRequest p10Req = new PKCS10CertificationRequest(csr);
            SubjectPublicKeyInfo pkInfo = p10Req.getSubjectPublicKeyInfo();
            PublicKey pk = CaEmulator.generatePublicKey(pkInfo);
            ContentVerifierProvider cvp = this.getContentVerifierProvider(pk);
            return p10Req.isSignatureValid(cvp);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | PKCSException ex) {
            LOG.error("could not validate POPO of CSR", ex);
            return false;
        }
    }

    public ContentVerifierProvider getContentVerifierProvider(PublicKey publicKey) throws InvalidKeyException {
        BcContentVerifierProviderBuilder builder;
        ScepUtil.requireNonNull((String)"publicKey", (Object)publicKey);
        String keyAlg = publicKey.getAlgorithm().toUpperCase();
        if ("EC".equals(keyAlg)) {
            keyAlg = "ECDSA";
        }
        if ((builder = VERIFIER_PROVIDER_BUILDER.get(keyAlg)) == null) {
            if ("RSA".equals(keyAlg)) {
                builder = new BcRSAContentVerifierProviderBuilder((DigestAlgorithmIdentifierFinder)DFLT_DIGESTALG_IDENTIFIER_FINDER);
            } else if ("DSA".equals(keyAlg)) {
                builder = new BcDSAContentVerifierProviderBuilder((DigestAlgorithmIdentifierFinder)DFLT_DIGESTALG_IDENTIFIER_FINDER);
            } else if ("ECDSA".equals(keyAlg)) {
                builder = new BcECContentVerifierProviderBuilder((DigestAlgorithmIdentifierFinder)DFLT_DIGESTALG_IDENTIFIER_FINDER);
            } else {
                throw new InvalidKeyException("unknown key algorithm of the public key " + keyAlg);
            }
            VERIFIER_PROVIDER_BUILDER.put(keyAlg, builder);
        }
        AsymmetricKeyParameter keyParam = CaEmulator.generatePublicKeyParameter(publicKey);
        try {
            return builder.build(keyParam);
        }
        catch (OperatorCreationException ex) {
            throw new InvalidKeyException("could not build ContentVerifierProvider: " + ex.getMessage(), ex);
        }
    }

    private static PublicKey generatePublicKey(SubjectPublicKeyInfo pkInfo) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory kf;
        String algorithm;
        X509EncodedKeySpec keyspec;
        ScepUtil.requireNonNull((String)"pkInfo", (Object)pkInfo);
        try {
            keyspec = new X509EncodedKeySpec(pkInfo.getEncoded());
        }
        catch (IOException ex) {
            throw new InvalidKeySpecException(ex.getMessage(), ex);
        }
        ASN1ObjectIdentifier aid = pkInfo.getAlgorithm().getAlgorithm();
        if (PKCSObjectIdentifiers.rsaEncryption.equals((Object)aid)) {
            algorithm = "RSA";
        } else if (X9ObjectIdentifiers.id_dsa.equals((Object)aid)) {
            algorithm = "DSA";
        } else if (X9ObjectIdentifiers.id_ecPublicKey.equals((Object)aid)) {
            algorithm = "EC";
        } else {
            throw new InvalidKeySpecException("unsupported key algorithm: " + aid);
        }
        try {
            kf = KeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidKeySpecException("could not find KeyFactory for " + algorithm + ": " + ex.getMessage());
        }
        return kf.generatePublic(keyspec);
    }

    private static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        ScepUtil.requireNonNull((String)"key", (Object)key);
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            return new RSAKeyParameters(false, rsaKey.getModulus(), rsaKey.getPublicExponent());
        }
        if (key instanceof ECPublicKey) {
            return ECUtil.generatePublicKeyParameter((PublicKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return DSAUtil.generatePublicKeyParameter((PublicKey)key);
        }
        throw new InvalidKeyException("unknown key " + key.getClass().getName());
    }
}

