/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.serveremulator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class AuditEvent {
    private String name;
    private AuditLevel level;
    private final Map<String, String> eventDatas = new HashMap<String, String>();

    public AuditEvent() {
        this.level = AuditLevel.INFO;
    }

    public AuditLevel level() {
        return this.level;
    }

    public void setLevel(AuditLevel level) {
        this.level = level;
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> eventDatas() {
        return Collections.unmodifiableMap(this.eventDatas);
    }

    public void putEventData(String name, Object value) {
        this.eventDatas.put(name, value.toString());
    }

    public void log(Logger log) {
        StringBuilder sb = new StringBuilder();
        for (String name : this.eventDatas.keySet()) {
            sb.append(name).append(": ").append(this.eventDatas.get(name)).append(" | ");
        }
        int len = sb.length();
        if (len > 2) {
            sb.delete(len - 2, len);
        }
        if (this.level == AuditLevel.ERROR) {
            log.error("{} | {}", (Object)this.name, (Object)sb);
        } else {
            log.info("{} | {}", (Object)this.name, (Object)sb);
        }
    }

    public static enum AuditLevel {
        ERROR,
        INFO;

    }
}

