/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.io.IOException;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.KeyTransRecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.operator.AsymmetricKeyWrapper;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JceAsymmetricKeyWrapper;
import org.xipki.scep.message.MessageEncodingException;
import org.xipki.scep.transaction.FailInfo;
import org.xipki.scep.transaction.MessageType;
import org.xipki.scep.transaction.Nonce;
import org.xipki.scep.transaction.PkiStatus;
import org.xipki.scep.transaction.TransactionId;
import org.xipki.scep.util.ScepConstants;
import org.xipki.scep.util.ScepUtil;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class PkiMessage {
    private static final Set<ASN1ObjectIdentifier> SCEP_ATTR_TYPES = CollectionUtil.asSet((Object[])new ASN1ObjectIdentifier[]{ScepConstants.ID_FAILINFO, ScepConstants.ID_MESSAGE_TYPE, ScepConstants.ID_PKI_STATUS, ScepConstants.ID_RECIPIENT_NONCE, ScepConstants.ID_SENDER_NONCE, ScepConstants.ID_TRANSACTION_ID, ScepConstants.ID_SCEP_FAILINFOTEXT, CMSAttributes.signingTime});
    private final Map<ASN1ObjectIdentifier, ASN1Encodable> signedAttributes = new HashMap<ASN1ObjectIdentifier, ASN1Encodable>();
    private final Map<ASN1ObjectIdentifier, ASN1Encodable> unsignedAttributes = new HashMap<ASN1ObjectIdentifier, ASN1Encodable>();
    private final MessageType messageType;
    private final Nonce senderNonce;
    private final TransactionId transactionId;
    private Nonce recipientNonce;
    private PkiStatus pkiStatus;
    private FailInfo failInfo;
    private String failInfoText;
    private ASN1Encodable messageData;

    public PkiMessage(TransactionId transactionId, MessageType messageType) {
        this(transactionId, messageType, Nonce.randomNonce());
    }

    public PkiMessage(TransactionId transactionId, MessageType messageType, Nonce senderNonce) {
        this.transactionId = (TransactionId)Args.notNull((Object)transactionId, (String)"transactionId");
        this.messageType = (MessageType)((Object)Args.notNull((Object)((Object)messageType), (String)"messageType"));
        this.senderNonce = (Nonce)Args.notNull((Object)senderNonce, (String)"senderNonce");
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public Nonce getSenderNonce() {
        return this.senderNonce;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public Nonce getRecipientNonce() {
        return this.recipientNonce;
    }

    public void setRecipientNonce(Nonce recipientNonce) {
        this.recipientNonce = recipientNonce;
    }

    public PkiStatus getPkiStatus() {
        return this.pkiStatus;
    }

    public void setPkiStatus(PkiStatus pkiStatus) {
        this.pkiStatus = pkiStatus;
    }

    public FailInfo getFailInfo() {
        return this.failInfo;
    }

    public void setFailInfo(FailInfo failInfo) {
        this.failInfo = failInfo;
    }

    public String getFailInfoText() {
        return this.failInfoText;
    }

    public void setFailInfoText(String failInfoText) {
        this.failInfoText = failInfoText;
    }

    public ASN1Encodable getMessageData() {
        return this.messageData;
    }

    public void setMessageData(ASN1Encodable messageData) {
        this.messageData = messageData;
    }

    public ASN1Encodable addSignendAttribute(ASN1ObjectIdentifier type, ASN1Encodable value) {
        if (SCEP_ATTR_TYPES.contains(type)) {
            throw new IllegalArgumentException("Adding SCEP attribute via addSignedAttribute() method is not permitted");
        }
        return this.signedAttributes.put(type, value);
    }

    public ASN1Encodable addUnsignendAttribute(ASN1ObjectIdentifier type, ASN1Encodable value) {
        return this.unsignedAttributes.put(type, value);
    }

    public ASN1Encodable removeSignedAttribute(ASN1ObjectIdentifier type) {
        return this.signedAttributes.remove(type);
    }

    public ASN1Encodable removeUnsignedAttribute(ASN1ObjectIdentifier type) {
        return this.unsignedAttributes.remove(type);
    }

    public ASN1Encodable getSignedAtrributeValue(ASN1ObjectIdentifier type) {
        return this.signedAttributes.get(type);
    }

    public ASN1Encodable getUnsignedAtrributeValue(ASN1ObjectIdentifier type) {
        return this.unsignedAttributes.get(type);
    }

    private AttributeTable getSignedAttributes() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        PkiMessage.addAttribute(vec, ScepConstants.ID_MESSAGE_TYPE, (ASN1Encodable)new DERPrintableString(Integer.toString(this.messageType.getCode())));
        PkiMessage.addAttribute(vec, ScepConstants.ID_SENDER_NONCE, (ASN1Encodable)new DEROctetString(this.senderNonce.getBytes()));
        PkiMessage.addAttribute(vec, ScepConstants.ID_TRANSACTION_ID, (ASN1Encodable)new DERPrintableString(this.transactionId.getId()));
        if (this.failInfo != null) {
            PkiMessage.addAttribute(vec, ScepConstants.ID_FAILINFO, (ASN1Encodable)new DERPrintableString(Integer.toString(this.failInfo.getCode())));
        }
        if (this.failInfoText != null && !this.failInfoText.isEmpty()) {
            PkiMessage.addAttribute(vec, ScepConstants.ID_SCEP_FAILINFOTEXT, (ASN1Encodable)new DERUTF8String(this.failInfoText));
        }
        if (this.pkiStatus != null) {
            PkiMessage.addAttribute(vec, ScepConstants.ID_PKI_STATUS, (ASN1Encodable)new DERPrintableString(Integer.toString(this.pkiStatus.getCode())));
        }
        if (this.recipientNonce != null) {
            PkiMessage.addAttribute(vec, ScepConstants.ID_RECIPIENT_NONCE, (ASN1Encodable)new DEROctetString(this.recipientNonce.getBytes()));
        }
        for (Map.Entry<ASN1ObjectIdentifier, ASN1Encodable> entry : this.signedAttributes.entrySet()) {
            PkiMessage.addAttribute(vec, entry.getKey(), entry.getValue());
        }
        return new AttributeTable(vec);
    }

    private AttributeTable getUnsignedAttributes() {
        if (this.unsignedAttributes.isEmpty()) {
            return null;
        }
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (Map.Entry<ASN1ObjectIdentifier, ASN1Encodable> entry : this.unsignedAttributes.entrySet()) {
            PkiMessage.addAttribute(vec, entry.getKey(), entry.getValue());
        }
        return new AttributeTable(vec);
    }

    public ContentInfo encode(PrivateKey signerKey, SignAlgo signatureAlgorithm, X509Cert signerCert, X509Cert[] signerCertSet, X509Cert recipientCert, ASN1ObjectIdentifier encAlgId) throws MessageEncodingException {
        ContentSigner signer;
        Args.notNull((Object)signerKey, (String)"signerKey");
        try {
            signer = new JcaContentSignerBuilder(signatureAlgorithm.getJceName()).build(signerKey);
        }
        catch (OperatorCreationException ex) {
            throw new MessageEncodingException(ex);
        }
        return this.encode(signer, signerCert, signerCertSet, recipientCert, encAlgId);
    }

    public ContentInfo encode(ContentSigner signer, X509Cert signerCert, X509Cert[] cmsCertSet, X509Cert recipientCert, ASN1ObjectIdentifier encAlgId) throws MessageEncodingException {
        CMSAbsentContent content;
        Args.notNull((Object)signer, (String)"signer");
        Args.notNull((Object)signerCert, (String)"signerCert");
        if (this.messageData != null) {
            Args.notNull((Object)recipientCert, (String)"recipientCert");
            Args.notNull((Object)encAlgId, (String)"encAlgId");
        }
        if (this.messageData == null) {
            content = new CMSAbsentContent();
        } else {
            byte[] encoded;
            CMSEnvelopedData envelopedData = this.encrypt(recipientCert, encAlgId);
            try {
                encoded = envelopedData.getEncoded();
            }
            catch (IOException ex) {
                throw new MessageEncodingException(ex);
            }
            content = new CMSProcessableByteArray(CMSObjectIdentifiers.envelopedData, encoded);
        }
        try {
            SignerInfoGenerator signerInfo;
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            JcaSignerInfoGeneratorBuilder signerInfoBuilder = new JcaSignerInfoGeneratorBuilder((DigestCalculatorProvider)new BcDigestCalculatorProvider());
            signerInfoBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(this.getSignedAttributes()));
            AttributeTable attrTable = this.getUnsignedAttributes();
            if (attrTable != null) {
                signerInfoBuilder.setUnsignedAttributeGenerator((CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attrTable));
            }
            ScepUtil.addCmsCertSet(generator, cmsCertSet);
            try {
                signerInfo = signerInfoBuilder.build(signer, signerCert.toBcCert());
            }
            catch (Exception ex) {
                throw new MessageEncodingException(ex);
            }
            generator.addSignerInfoGenerator(signerInfo);
            return generator.generate((CMSTypedData)content, true).toASN1Structure();
        }
        catch (Exception ex) {
            throw new MessageEncodingException(ex);
        }
    }

    private CMSEnvelopedData encrypt(X509Cert recipient, ASN1ObjectIdentifier encAlgId) throws MessageEncodingException {
        byte[] messageDataBytes;
        Args.notNull((Object)recipient, (String)"recipient");
        Args.notNull((Object)encAlgId, (String)"encAlgId");
        try {
            messageDataBytes = this.messageData.toASN1Primitive().getEncoded();
        }
        catch (IOException ex) {
            throw new MessageEncodingException(ex);
        }
        CMSEnvelopedDataGenerator edGenerator = new CMSEnvelopedDataGenerator();
        CMSProcessableByteArray envelopable = new CMSProcessableByteArray(messageDataBytes);
        KeyTransRecipientInfoGenerator recipientGenerator = new KeyTransRecipientInfoGenerator(new IssuerAndSerialNumber(recipient.getIssuer(), recipient.getSerialNumber()), (AsymmetricKeyWrapper)new JceAsymmetricKeyWrapper(recipient.getPublicKey())){};
        edGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)recipientGenerator);
        try {
            return edGenerator.generate((CMSTypedData)envelopable, new JceCMSContentEncryptorBuilder(encAlgId).build());
        }
        catch (CMSException ex) {
            throw new MessageEncodingException(ex);
        }
    }

    private static void addAttribute(ASN1EncodableVector vector, ASN1ObjectIdentifier attrType, ASN1Encodable attrValue) {
        vector.add((ASN1Encodable)new Attribute(attrType, (ASN1Set)new DERSet(attrValue)));
    }
}

