/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.client;

import java.util.HashMap;
import org.xipki.scep.client.CaCertValidator;
import org.xipki.scep.client.CaIdentifier;
import org.xipki.scep.client.Client;
import org.xipki.scep.client.ScepClientException;
import org.xipki.scep.client.ScepHttpResponse;
import org.xipki.util.Curl;
import org.xipki.util.DefaultCurl;

public class ScepClient
extends Client {
    private final Curl curl;

    public ScepClient(CaIdentifier caId, CaCertValidator caCertValidator) {
        this(caId, caCertValidator, null);
    }

    public ScepClient(CaIdentifier caId, CaCertValidator caCertValidator, Curl curl) {
        super(caId, caCertValidator);
        this.curl = curl == null ? new DefaultCurl() : curl;
    }

    @Override
    protected ScepHttpResponse httpGet(String url) throws ScepClientException {
        Curl.CurlResult resp;
        try {
            resp = this.curl.curlGet(url, false, null, null);
        }
        catch (Exception ex) {
            throw new ScepClientException(ex);
        }
        return ScepClient.parseResp(resp);
    }

    @Override
    protected ScepHttpResponse httpPost(String url, String requestContentType, byte[] request) throws ScepClientException {
        Curl.CurlResult resp;
        try {
            HashMap<String, String> headers = null;
            if (requestContentType != null) {
                headers = new HashMap<String, String>();
                headers.put("content-type", requestContentType);
            }
            resp = this.curl.curlPost(url, false, headers, null, request);
        }
        catch (Exception ex) {
            throw new ScepClientException(ex);
        }
        return ScepClient.parseResp(resp);
    }

    private static ScepHttpResponse parseResp(Curl.CurlResult resp) throws ScepClientException {
        int statusCode = resp.getStatusCode();
        if (statusCode != 200) {
            String msg = "server returned status code " + statusCode;
            byte[] errorContent = resp.getErrorContent();
            if (errorContent != null && errorContent.length != 0) {
                msg = msg + ", message: " + new String(errorContent);
            }
            throw new ScepClientException(msg);
        }
        return new ScepHttpResponse(resp.getContentType(), resp.getContent());
    }
}

