/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.xipki.scep.message.MessageEncodingException;
import org.xipki.scep.util.ScepUtil;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class NextCaMessage {
    private X509Cert caCert;
    private List<X509Cert> raCerts;

    public X509Cert getCaCert() {
        return this.caCert;
    }

    public void setCaCert(X509Cert caCert) {
        this.caCert = caCert;
    }

    public List<X509Cert> getRaCerts() {
        return this.raCerts;
    }

    public void setRaCerts(List<X509Cert> raCerts) {
        this.raCerts = CollectionUtil.isEmpty(raCerts) ? null : Collections.unmodifiableList(new ArrayList<X509Cert>(raCerts));
    }

    public ContentInfo encode(PrivateKey signingKey, X509Cert signerCert, X509Cert[] cmsCertSet) throws MessageEncodingException {
        Args.notNull((Object)signingKey, (String)"signingKey");
        Args.notNull((Object)signerCert, (String)"signerCert");
        try {
            CMSSignedDataGenerator degenerateSignedData = new CMSSignedDataGenerator();
            degenerateSignedData.addCertificate(this.caCert.toBcCert());
            if (CollectionUtil.isNotEmpty(this.raCerts)) {
                for (X509Cert m : this.raCerts) {
                    degenerateSignedData.addCertificate(m.toBcCert());
                }
            }
            byte[] degenratedSignedDataBytes = degenerateSignedData.generate((CMSTypedData)new CMSAbsentContent()).getEncoded();
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            String signatureAlgo = NextCaMessage.getSignatureAlgorithm(signingKey, HashAlgo.SHA1);
            ContentSigner signer = new JcaContentSignerBuilder(signatureAlgo).build(signingKey);
            JcaSignerInfoGeneratorBuilder signerInfoBuilder = new JcaSignerInfoGeneratorBuilder((DigestCalculatorProvider)new BcDigestCalculatorProvider());
            signerInfoBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator());
            SignerInfoGenerator signerInfo = signerInfoBuilder.build(signer, signerCert.toBcCert());
            generator.addSignerInfoGenerator(signerInfo);
            CMSProcessableByteArray cmsContent = new CMSProcessableByteArray(CMSObjectIdentifiers.signedData, degenratedSignedDataBytes);
            ScepUtil.addCmsCertSet(generator, cmsCertSet);
            return generator.generate((CMSTypedData)cmsContent, true).toASN1Structure();
        }
        catch (IOException | CertificateEncodingException | CMSException | OperatorCreationException ex) {
            throw new MessageEncodingException(ex);
        }
    }

    private static String getSignatureAlgorithm(PrivateKey key, HashAlgo hashAlgo) {
        if ("RSA".equalsIgnoreCase(key.getAlgorithm())) {
            return hashAlgo.getJceName() + "withRSA";
        }
        throw new UnsupportedOperationException("getSignatureAlgorithm() for non-RSA is not supported yet.");
    }
}

