/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.util.Args;

public class IssuerAndSubject
extends ASN1Object {
    private final X500Name issuer;
    private final X500Name subject;

    private IssuerAndSubject(ASN1Sequence seq) {
        Args.notNull((Object)seq, (String)"seq");
        this.issuer = X500Name.getInstance((Object)seq.getObjectAt(0));
        this.subject = X500Name.getInstance((Object)seq.getObjectAt(1));
    }

    public IssuerAndSubject(X500Name issuer, X500Name subject) {
        this.issuer = (X500Name)Args.notNull((Object)issuer, (String)"issuer");
        this.subject = (X500Name)Args.notNull((Object)subject, (String)"subject");
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{this.issuer, this.subject});
    }

    public static IssuerAndSubject getInstance(Object obj) {
        if (obj instanceof IssuerAndSubject) {
            return (IssuerAndSubject)((Object)obj);
        }
        if (obj != null) {
            return new IssuerAndSubject(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }
}

