/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.scep.message.AuthorityCertStore;
import org.xipki.scep.message.MessageDecodingException;
import org.xipki.scep.util.ScepUtil;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;

public class DecodedNextCaMessage {
    private static final Logger LOG = LoggerFactory.getLogger(DecodedNextCaMessage.class);
    private AuthorityCertStore authorityCertStore;
    private X509Cert signatureCert;
    private HashAlgo digestAlgorithm;
    private Boolean signatureValid;
    private Date signingTime;
    private String failureMessage;

    public AuthorityCertStore getAuthorityCertStore() {
        return this.authorityCertStore;
    }

    public void setAuthorityCertStore(AuthorityCertStore authorityCertStore) {
        this.authorityCertStore = authorityCertStore;
    }

    public X509Cert getSignatureCert() {
        return this.signatureCert;
    }

    public void setSignatureCert(X509Cert signatureCert) {
        this.signatureCert = signatureCert;
    }

    public HashAlgo getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(HashAlgo digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public Boolean isSignatureValid() {
        return this.signatureValid;
    }

    public void setSignatureValid(Boolean signatureValid) {
        this.signatureValid = signatureValid;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public Date getSigningTime() {
        return this.signingTime;
    }

    public void setSigningTime(Date signingTime) {
        this.signingTime = signingTime;
    }

    public static DecodedNextCaMessage decode(CMSSignedData pkiMessage, CollectionStore<X509CertificateHolder> certStore) throws MessageDecodingException {
        List<X509Cert> certs;
        boolean signatureValid;
        SignerInformationVerifier verifier;
        Args.notNull((Object)pkiMessage, (String)"pkiMessage");
        SignerInformationStore signerStore = pkiMessage.getSignerInfos();
        Collection signerInfos = signerStore.getSigners();
        if (signerInfos.size() != 1) {
            throw new MessageDecodingException("number of signerInfos is not 1, but " + signerInfos.size());
        }
        SignerInformation signerInfo = (SignerInformation)signerInfos.iterator().next();
        SignerId sid = signerInfo.getSID();
        Collection signedDataCerts = null;
        if (certStore != null) {
            signedDataCerts = certStore.getMatches((Selector)sid);
        }
        if (CollectionUtil.isEmpty(signedDataCerts)) {
            signedDataCerts = pkiMessage.getCertificates().getMatches((Selector)signerInfo.getSID());
        }
        if (signedDataCerts == null || signedDataCerts.size() != 1) {
            throw new MessageDecodingException("could not find embedded certificate to verify the signature");
        }
        AttributeTable signedAttrs = signerInfo.getSignedAttributes();
        if (signedAttrs == null) {
            throw new MessageDecodingException("missing signed attributes");
        }
        Date signingTime = null;
        ASN1Encodable attrValue = ScepUtil.getFirstAttrValue(signedAttrs, CMSAttributes.signingTime);
        if (attrValue != null) {
            signingTime = ScepUtil.getTime(attrValue);
        }
        DecodedNextCaMessage ret = new DecodedNextCaMessage();
        if (signingTime != null) {
            ret.setSigningTime(signingTime);
        }
        try {
            SignAlgo signAlgo;
            HashAlgo digestAlgo = HashAlgo.getInstance((AlgorithmIdentifier)signerInfo.getDigestAlgorithmID());
            ret.setDigestAlgorithm(digestAlgo);
            String sigAlgOid = signerInfo.getEncryptionAlgOID();
            if (!PKCSObjectIdentifiers.rsaEncryption.getId().equals(sigAlgOid) && digestAlgo != (signAlgo = SignAlgo.getInstance((AlgorithmIdentifier)signerInfo.toASN1Structure().getDigestEncryptionAlgorithm())).getHashAlgo()) {
                ret.setFailureMessage("digestAlgorithm and encryptionAlgorithm do not use the same digestAlgorithm");
                return ret;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            ret.setFailureMessage(ex.getMessage());
            return ret;
        }
        X509CertificateHolder signerCert = (X509CertificateHolder)signedDataCerts.iterator().next();
        ret.setSignatureCert(new X509Cert(signerCert));
        try {
            verifier = new JcaSimpleSignerInfoVerifierBuilder().build(signerCert);
        }
        catch (CertificateException | OperatorCreationException ex) {
            String msg = "could not build signature verifier";
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not build signature verifier");
            ret.setFailureMessage("could not build signature verifier: " + ex.getMessage());
            return ret;
        }
        try {
            signatureValid = signerInfo.verify(verifier);
        }
        catch (CMSException ex) {
            String msg = "could not verify the signature";
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not verify the signature");
            ret.setFailureMessage("could not verify the signature: " + ex.getMessage());
            return ret;
        }
        ret.setSignatureValid(signatureValid);
        if (!signatureValid) {
            return ret;
        }
        CMSTypedData signedContent = pkiMessage.getSignedContent();
        ASN1ObjectIdentifier signedContentType = signedContent.getContentType();
        if (!CMSObjectIdentifiers.signedData.equals((ASN1Primitive)signedContentType) && !CMSObjectIdentifiers.data.equals((ASN1Primitive)signedContentType)) {
            ret.setFailureMessage("either id-signedData or id-data is excepted, but not '" + signedContentType.getId());
            return ret;
        }
        ContentInfo contentInfo = ContentInfo.getInstance((Object)signedContent.getContent());
        SignedData signedData = SignedData.getInstance((Object)contentInfo.getContent());
        try {
            certs = ScepUtil.getCertsFromSignedData(signedData);
        }
        catch (CertificateException ex) {
            String msg = "could not extract Certificates from the message";
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not extract Certificates from the message");
            ret.setFailureMessage("could not extract Certificates from the message: " + ex.getMessage());
            return ret;
        }
        X509Cert caCert = null;
        LinkedList<X509Cert> raCerts = new LinkedList<X509Cert>();
        for (X509Cert cert : certs) {
            if (cert.getBasicConstraints() > -1) {
                if (caCert != null) {
                    String msg = "multiple CA certificates is returned, but exactly 1 is expected";
                    LOG.error("multiple CA certificates is returned, but exactly 1 is expected");
                    ret.setFailureMessage("multiple CA certificates is returned, but exactly 1 is expected");
                    return ret;
                }
                caCert = cert;
                continue;
            }
            raCerts.add(cert);
        }
        if (caCert == null) {
            String msg = "no CA certificate is returned";
            LOG.error("no CA certificate is returned");
            ret.setFailureMessage("no CA certificate is returned");
            return ret;
        }
        X509Cert[] locaRaCerts = raCerts.isEmpty() ? null : raCerts.toArray(new X509Cert[0]);
        AuthorityCertStore authorityCertStore = AuthorityCertStore.getInstance(caCert, locaRaCerts);
        ret.setAuthorityCertStore(authorityCertStore);
        return ret;
    }
}

