/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.client;

import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.xipki.scep.client.CaCertValidator;
import org.xipki.scep.client.CaIdentifier;
import org.xipki.scep.client.Client;
import org.xipki.scep.client.ScepClientException;
import org.xipki.scep.client.ScepHttpResponse;
import org.xipki.util.http.HttpRespContent;
import org.xipki.util.http.XiHttpClient;

public class ScepClient
extends Client {
    private final XiHttpClient httpClient;

    public ScepClient(CaIdentifier caId, CaCertValidator caCertValidator) {
        this(caId, caCertValidator, null, null);
    }

    public ScepClient(CaIdentifier caId, CaCertValidator caCertValidator, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) {
        super(caId, caCertValidator);
        this.httpClient = new XiHttpClient(sslSocketFactory, hostnameVerifier);
    }

    @Override
    protected ScepHttpResponse httpGet(String url) throws ScepClientException {
        HttpRespContent resp;
        try {
            resp = this.httpClient.httpGet(url);
        }
        catch (IOException ex) {
            throw new ScepClientException(ex);
        }
        return ScepClient.parseResp(resp);
    }

    @Override
    protected ScepHttpResponse httpPost(String url, String requestContentType, byte[] request) throws ScepClientException {
        HttpRespContent resp;
        try {
            resp = this.httpClient.httpPost(url, requestContentType, request);
        }
        catch (IOException ex) {
            throw new ScepClientException(ex);
        }
        return ScepClient.parseResp(resp);
    }

    private static ScepHttpResponse parseResp(HttpRespContent resp) throws ScepClientException {
        byte[] content = resp.getContent();
        if (!resp.isOK()) {
            String msg = "server returned status code " + resp.getStatusCode();
            if (content != null && content.length != 0) {
                msg = msg + ", message: " + new String(content);
            }
            throw new ScepClientException(msg);
        }
        return new ScepHttpResponse(resp.getContentType(), content);
    }
}

