/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client;

import java.security.SecureRandom;
import org.bouncycastle.asn1.cmp.PBMParameter;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.util.Args;

public abstract class Requestor {
    private static final X500Name NULL_GENERALNAME = new X500Name(new RDN[0]);
    private final GeneralName name;

    private Requestor(X500Name name) {
        this.name = new GeneralName((X500Name)Args.notNull((Object)name, (String)"name"));
    }

    public GeneralName getName() {
        return this.name;
    }

    public static class SignatureCmpRequestor
    extends Requestor {
        private final ConcurrentContentSigner signer;

        public SignatureCmpRequestor(ConcurrentContentSigner signer) {
            super(SignatureCmpRequestor.getSignerSubject(signer));
            this.signer = signer;
        }

        public ConcurrentContentSigner getSigner() {
            return this.signer;
        }

        private static X500Name getSignerSubject(ConcurrentContentSigner signer) {
            Args.notNull((Object)signer, (String)"signer");
            if (signer.getCertificate() == null) {
                throw new IllegalArgumentException("requestor without certificate is not allowed");
            }
            return signer.getCertificate().getSubject();
        }
    }

    public static class PbmMacCmpRequestor
    extends Requestor {
        private final SecureRandom random = new SecureRandom();
        private final char[] password;
        private final byte[] senderKID;
        private final HashAlgo owf;
        private final int iterationCount;
        private final SignAlgo mac;

        public PbmMacCmpRequestor(char[] password, byte[] senderKID, HashAlgo owf, int iterationCount, SignAlgo mac) {
            super(NULL_GENERALNAME);
            this.password = password;
            this.senderKID = senderKID;
            this.owf = owf;
            this.iterationCount = iterationCount;
            this.mac = mac;
        }

        public char[] getPassword() {
            return this.password;
        }

        public byte[] getSenderKID() {
            return this.senderKID;
        }

        public PBMParameter getParameter() {
            return new PBMParameter(this.randomSalt(), this.owf.getAlgorithmIdentifier(), this.iterationCount, this.mac.getAlgorithmIdentifier());
        }

        private byte[] randomSalt() {
            byte[] bytes = new byte[64];
            this.random.nextBytes(bytes);
            return bytes;
        }
    }
}

