/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client.internal;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;

abstract class Responder {
    private final GeneralName name;

    private Responder(X500Name name) {
        this.name = new GeneralName((X500Name)Args.notNull((Object)name, (String)"name"));
    }

    GeneralName getName() {
        return this.name;
    }

    static class SignatureCmpResponder
    extends Responder {
        private final X509Cert cert;
        private final AlgorithmValidator sigAlgoValidator;

        SignatureCmpResponder(X509Cert cert, AlgorithmValidator sigAlgoValidator) {
            super(((X509Cert)Args.notNull((Object)cert, (String)"cert")).getSubject());
            this.cert = cert;
            this.sigAlgoValidator = (AlgorithmValidator)Args.notNull((Object)sigAlgoValidator, (String)"sigAlgoValidator");
        }

        X509Cert getCert() {
            return this.cert;
        }

        AlgorithmValidator getSigAlgoValidator() {
            return this.sigAlgoValidator;
        }
    }

    static class PbmMacCmpResponder
    extends Responder {
        private final List<HashAlgo> owfAlgos;
        private final List<SignAlgo> macAlgos;

        PbmMacCmpResponder(List<String> owfs, List<String> macs) throws NoSuchAlgorithmException {
            super(new X500Name(""));
            this.owfAlgos = new ArrayList<HashAlgo>(owfs.size());
            for (String owf : owfs) {
                this.owfAlgos.add(HashAlgo.getInstance((String)owf));
            }
            this.macAlgos = new ArrayList<SignAlgo>(macs.size());
            for (String mac : macs) {
                this.macAlgos.add(SignAlgo.getInstance((String)mac));
            }
        }

        public boolean isPbmOwfPermitted(HashAlgo pbmOwf) {
            return this.owfAlgos.contains(pbmOwf);
        }

        public boolean isPbmMacPermitted(SignAlgo pbmMac) {
            return this.macAlgos.contains(pbmMac);
        }
    }
}

