/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.GenMsgContent;
import org.bouncycastle.asn1.cmp.GenRepContent;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PBMParameter;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cmp.RevDetails;
import org.bouncycastle.asn1.cmp.RevRepContent;
import org.bouncycastle.asn1.cmp.RevReqContent;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.asn1.crmf.CertId;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.crmf.EncryptedKey;
import org.bouncycastle.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.CertificateConfirmationContent;
import org.bouncycastle.cert.cmp.CertificateConfirmationContentBuilder;
import org.bouncycastle.cert.cmp.GeneralPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.cert.crmf.PKMACBuilder;
import org.bouncycastle.cert.crmf.PKMACValuesCalculator;
import org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.PasswordRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.bc.BcPasswordEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyAgreeEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher;
import org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultSecretKeySizeProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.PBEMacCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.cmp.CmpUtf8Pairs;
import org.xipki.cmp.CmpUtil;
import org.xipki.cmp.ProtectionResult;
import org.xipki.cmp.ProtectionVerificationResult;
import org.xipki.cmp.VerifiedPkiMessage;
import org.xipki.cmp.client.CmpClientException;
import org.xipki.cmp.client.EnrollCertRequest;
import org.xipki.cmp.client.PkiErrorException;
import org.xipki.cmp.client.Requestor;
import org.xipki.cmp.client.RevokeCertRequest;
import org.xipki.cmp.client.UnrevokeCertRequest;
import org.xipki.cmp.client.internal.CsrEnrollCertRequest;
import org.xipki.cmp.client.internal.EnrollCertResponse;
import org.xipki.cmp.client.internal.Responder;
import org.xipki.cmp.client.internal.ResultEntry;
import org.xipki.cmp.client.internal.RevokeCertResponse;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.http.HttpRespContent;
import org.xipki.util.http.XiHttpClient;

class CmpAgent {
    private static final Logger LOG = LoggerFactory.getLogger(CmpAgent.class);
    private static final String CMP_REQUEST_MIMETYPE = "application/pkixcmp";
    private static final String CMP_RESPONSE_MIMETYPE = "application/pkixcmp";
    private static final DefaultSecretKeySizeProvider KEYSIZE_PROVIDER = new DefaultSecretKeySizeProvider();
    private static final DigestCalculatorProvider DIGEST_CALCULATOR_PROVIDER = new BcDigestCalculatorProvider();
    private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    protected static final int PKISTATUS_RESPONSE_ERROR = -1;
    protected static final int PKISTATUS_NO_ANSWER = -2;
    protected final SecurityFactory securityFactory;
    private final Random random = new Random();
    private final Responder pbmMacResponder;
    private final Responder signatureResponder;
    private final boolean sendRequestorCert;
    private final boolean implicitConfirm = true;
    private final XiHttpClient httpClient;
    private final String serverUrl;

    CmpAgent(Responder signatureResponder, Responder pbmMacResponder, String serverUrl, SecurityFactory securityFactory, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, boolean sendRequestorCert) {
        this.signatureResponder = signatureResponder;
        this.pbmMacResponder = pbmMacResponder;
        this.securityFactory = (SecurityFactory)Args.notNull((Object)securityFactory, (String)"securityFactory");
        Args.notBlank((String)serverUrl, (String)"serverUrl");
        try {
            this.serverUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
            new URL(this.serverUrl);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("invalid URL: " + serverUrl);
        }
        this.httpClient = new XiHttpClient(sslSocketFactory, hostnameVerifier);
        this.sendRequestorCert = sendRequestorCert;
    }

    private Responder getResponder(Requestor requestor) {
        return requestor instanceof Requestor.SignatureCmpRequestor ? this.signatureResponder : this.pbmMacResponder;
    }

    private HttpRespContent send(String caName, byte[] request) throws IOException {
        Args.notNull((Object)request, (String)"request");
        return this.httpClient.httpPost(this.serverUrl + caName, "application/pkixcmp", request, "application/pkixcmp");
    }

    private PKIMessage sign(Requestor requestor, PKIMessage request) throws CmpClientException {
        Args.notNull((Object)request, (String)"request");
        if (requestor == null) {
            throw new CmpClientException("no request signer is configured");
        }
        if (requestor instanceof Requestor.SignatureCmpRequestor) {
            ConcurrentContentSigner signer = ((Requestor.SignatureCmpRequestor)requestor).getSigner();
            try {
                return CmpUtil.addProtection(request, signer, requestor.getName(), this.sendRequestorCert);
            }
            catch (CMPException | NoIdleSignerException ex) {
                throw new CmpClientException("could not sign the request", ex);
            }
        }
        Requestor.PbmMacCmpRequestor pbmRequestor = (Requestor.PbmMacCmpRequestor)requestor;
        try {
            return CmpUtil.addProtection(request, pbmRequestor.getPassword(), pbmRequestor.getParameter(), requestor.getName(), pbmRequestor.getSenderKID());
        }
        catch (CMPException ex) {
            throw new CmpClientException("could not sign the request", ex);
        }
    }

    private VerifiedPkiMessage signAndSend(String caName, Requestor requestor, Responder responder, PKIMessage request, ReqRespDebug debug) throws CmpClientException {
        ASN1OctetString tid = ((PKIMessage)Args.notNull((Object)request, (String)"request")).getHeader().getTransactionID();
        PKIMessage tmpRequest = this.sign(requestor, request);
        GeneralPKIMessage response = this.send(caName, tmpRequest, debug);
        GeneralName rec = response.getHeader().getRecipient();
        if (!requestor.getName().equals((Object)rec)) {
            LOG.warn("tid={}: unknown CMP requestor '{}'", (Object)tid, (Object)rec);
        }
        VerifiedPkiMessage ret = new VerifiedPkiMessage(response);
        if (response.hasProtection()) {
            try {
                ret.setProtectionVerificationResult(this.verifyProtection(requestor, responder, Hex.encode((byte[])tid.getOctets()), response));
            }
            catch (InvalidKeyException | CMPException ex) {
                throw new CmpClientException(ex.getMessage(), ex);
            }
        } else {
            int bodyType = response.getBody().getType();
            if (bodyType != 23) {
                throw new CmpClientException("response is not signed");
            }
        }
        return ret;
    }

    private GeneralPKIMessage send(String caName, PKIMessage request, ReqRespDebug debug) throws CmpClientException {
        ASN1OctetString respRecipientNonce;
        GeneralPKIMessage response;
        HttpRespContent resp;
        byte[] encodedRequest;
        try {
            encodedRequest = request.getEncoded();
        }
        catch (IOException ex) {
            LOG.error("could not encode the PKI request {}", (Object)request);
            throw new CmpClientException(ex.getMessage(), ex);
        }
        ReqRespDebug.ReqRespPair reqResp = null;
        if (debug != null) {
            reqResp = new ReqRespDebug.ReqRespPair();
            debug.add(reqResp);
            if (debug.saveRequest()) {
                reqResp.setRequest(encodedRequest);
            }
        }
        try {
            resp = this.send(caName, encodedRequest);
        }
        catch (IOException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not send the PKI request to server");
            throw new CmpClientException("TRANSPORT_ERROR", ex);
        }
        byte[] encodedResp = resp.getContent();
        if (reqResp != null && debug.saveResponse() && resp.getContent() != null) {
            reqResp.setResponse(encodedResp);
        }
        if (!resp.isOK()) {
            String msg = "received HTTP status code " + resp.getStatusCode();
            LOG.warn(msg);
            throw new CmpClientException("Received HTTP status code");
        }
        try {
            response = new GeneralPKIMessage(encodedResp);
        }
        catch (IOException ex) {
            LOG.error("could not decode the received PKI message: {}", (Object)Hex.encode((byte[])encodedResp));
            throw new CmpClientException(ex.getMessage(), ex);
        }
        PKIHeader reqHeader = request.getHeader();
        PKIHeader respHeader = response.getHeader();
        ASN1OctetString tid = reqHeader.getTransactionID();
        ASN1OctetString respTid = respHeader.getTransactionID();
        if (!tid.equals((ASN1Primitive)respTid)) {
            LOG.warn("Response contains different tid ({}) than requested {}", (Object)respTid, (Object)tid);
            throw new CmpClientException("Response contains different tid than the request");
        }
        ASN1OctetString senderNonce = reqHeader.getSenderNonce();
        if (!senderNonce.equals((ASN1Primitive)(respRecipientNonce = respHeader.getRecipNonce()))) {
            LOG.warn("tid {}: response.recipientNonce ({}) != request.senderNonce ({})", new Object[]{tid, respRecipientNonce, senderNonce});
            throw new CmpClientException("Response contains differnt tid than the request");
        }
        return response;
    }

    private PKIHeader buildPkiHeader(Requestor requestor, Responder responder, ASN1OctetString tid) {
        return this.buildPkiHeader(requestor, responder, false, tid, null, null);
    }

    private PKIHeader buildPkiHeader(Requestor requestor, Responder responder, boolean addImplicitConfirm, ASN1OctetString tid, CmpUtf8Pairs utf8Pairs, InfoTypeAndValue ... additionalGeneralInfos) {
        if (additionalGeneralInfos != null) {
            for (InfoTypeAndValue itv : additionalGeneralInfos) {
                if (itv == null) continue;
                ASN1ObjectIdentifier type = itv.getInfoType();
                if (CMPObjectIdentifiers.it_implicitConfirm.equals((ASN1Primitive)type)) {
                    throw new IllegalArgumentException("additionGeneralInfos contains not-permitted ITV implicitConfirm");
                }
                if (!CMPObjectIdentifiers.regInfo_utf8Pairs.equals((ASN1Primitive)type)) continue;
                throw new IllegalArgumentException("additionGeneralInfos contains not-permitted ITV utf8Pairs");
            }
        }
        GeneralName sender = requestor != null ? requestor.getName() : new GeneralName(new X500Name(new RDN[0]));
        GeneralName recipient = responder != null ? responder.getName() : new GeneralName(new X500Name(new RDN[0]));
        PKIHeaderBuilder hdrBuilder = new PKIHeaderBuilder(2, sender, recipient);
        hdrBuilder.setMessageTime(new ASN1GeneralizedTime(new Date()));
        ASN1OctetString tmpTid = tid == null ? new DEROctetString(this.randomTransactionId()) : tid;
        hdrBuilder.setTransactionID(tmpTid);
        hdrBuilder.setSenderNonce(this.randomSenderNonce());
        ArrayList<InfoTypeAndValue> itvs = new ArrayList<InfoTypeAndValue>(2);
        if (addImplicitConfirm) {
            itvs.add(CmpUtil.getImplicitConfirmGeneralInfo());
        }
        if (utf8Pairs != null) {
            itvs.add(CmpUtil.buildInfoTypeAndValue(utf8Pairs));
        }
        if (additionalGeneralInfos != null) {
            for (InfoTypeAndValue itv : additionalGeneralInfos) {
                if (itv == null) continue;
                itvs.add(itv);
            }
        }
        if (CollectionUtil.isNotEmpty(itvs)) {
            hdrBuilder.setGeneralInfo(itvs.toArray(new InfoTypeAndValue[0]));
        }
        return hdrBuilder.build();
    }

    private byte[] randomTransactionId() {
        byte[] tid = new byte[20];
        this.random.nextBytes(tid);
        return tid;
    }

    private byte[] randomSenderNonce() {
        byte[] bytes = new byte[16];
        this.random.nextBytes(bytes);
        return bytes;
    }

    private ProtectionVerificationResult verifyProtection(Requestor requestor, Responder responder, String tid, GeneralPKIMessage pkiMessage) throws CMPException, InvalidKeyException {
        SignAlgo protectionAlgo;
        boolean authorizedResponder;
        ProtectedPKIMessage protectedMsg = new ProtectedPKIMessage(pkiMessage);
        PKIHeader header = protectedMsg.getHeader();
        if (requestor instanceof Requestor.PbmMacCmpRequestor) {
            SignAlgo mac;
            HashAlgo owf;
            if (!protectedMsg.hasPasswordBasedMacProtection()) {
                LOG.warn("NOT_MAC_BASED: {}", (Object)pkiMessage.getHeader().getProtectionAlg().getAlgorithm().getId());
                return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
            }
            PBMParameter parameter = PBMParameter.getInstance((Object)pkiMessage.getHeader().getProtectionAlg().getParameters());
            try {
                owf = HashAlgo.getInstance((AlgorithmIdentifier)parameter.getOwf());
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.owf)", (Throwable)ex);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            Responder.PbmMacCmpResponder macResponder = (Responder.PbmMacCmpResponder)responder;
            if (!macResponder.isPbmOwfPermitted(owf)) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.owf: {})", (Object)owf);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            try {
                mac = SignAlgo.getInstance((AlgorithmIdentifier)parameter.getMac());
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.mac)", (Throwable)ex);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            if (!macResponder.isPbmMacPermitted(mac)) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.mac: {})", (Object)mac);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            PKMACBuilder pkMacBuilder = new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator());
            Requestor.PbmMacCmpRequestor macRequestor = (Requestor.PbmMacCmpRequestor)requestor;
            boolean macValid = protectedMsg.verify((PBEMacCalculatorProvider)pkMacBuilder, macRequestor.getPassword());
            return new ProtectionVerificationResult(requestor, macValid ? ProtectionResult.MAC_VALID : ProtectionResult.MAC_INVALID);
        }
        if (protectedMsg.hasPasswordBasedMacProtection()) {
            LOG.warn("NOT_SIGNATURE_BASED: {}", (Object)pkiMessage.getHeader().getProtectionAlg().getAlgorithm().getId());
            return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        Responder.SignatureCmpResponder sigResponder = (Responder.SignatureCmpResponder)responder;
        if (header.getSender().getTagNo() != 4) {
            authorizedResponder = false;
        } else {
            X500Name msgSender = X500Name.getInstance((Object)header.getSender().getName());
            authorizedResponder = sigResponder.getCert().getSubject().equals((Object)msgSender);
        }
        if (!authorizedResponder) {
            LOG.warn("tid={}: not authorized responder '{}'", (Object)tid, (Object)header.getSender());
            return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        try {
            protectionAlgo = SignAlgo.getInstance((AlgorithmIdentifier)protectedMsg.getHeader().getProtectionAlg());
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.warn("tid={}: unknown response protection algorithm: {}", (Object)tid, (Object)ex.getMessage());
            return new ProtectionVerificationResult(null, ProtectionResult.SIGNATURE_INVALID);
        }
        if (!sigResponder.getSigAlgoValidator().isAlgorithmPermitted(protectionAlgo)) {
            LOG.warn("tid={}: response protected by untrusted protection algorithm '{}'", (Object)tid, (Object)protectionAlgo.getJceName());
            return new ProtectionVerificationResult(null, ProtectionResult.SIGNATURE_INVALID);
        }
        X509Cert cert = sigResponder.getCert();
        ContentVerifierProvider verifierProvider = this.securityFactory.getContentVerifierProvider(cert);
        if (verifierProvider == null) {
            LOG.warn("tid={}: not authorized responder '{}'", (Object)tid, (Object)header.getSender());
            return new ProtectionVerificationResult(cert, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        boolean signatureValid = protectedMsg.verify(verifierProvider);
        return new ProtectionVerificationResult(cert, signatureValid ? ProtectionResult.SIGNATURE_VALID : ProtectionResult.SIGNATURE_INVALID);
    }

    private PKIMessage buildMessageWithGeneralMsgContent(ASN1ObjectIdentifier type, ASN1Encodable value) {
        Args.notNull((Object)type, (String)"type");
        PKIHeader header = this.buildPkiHeader(null, null, null);
        InfoTypeAndValue itv = value != null ? new InfoTypeAndValue(type, value) : new InfoTypeAndValue(type);
        return new PKIMessage(header, new PKIBody(21, (ASN1Encodable)new GenMsgContent(itv)));
    }

    X509CRLHolder downloadCurrentCrl(String caName, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        ASN1ObjectIdentifier type = CMPObjectIdentifiers.it_currentCRL;
        PKIMessage request = this.buildMessageWithGeneralMsgContent(type, null);
        GeneralPKIMessage response = this.send(caName, request, debug);
        ASN1Encodable itvValue = CmpAgent.parseGenRep(response, type);
        return new X509CRLHolder(CertificateList.getInstance((Object)itvValue));
    }

    List<X509Cert> caCerts(String caName, int maxNumCerts, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        ASN1ObjectIdentifier type = CMPObjectIdentifiers.id_it_caCerts;
        PKIMessage request = this.buildMessageWithGeneralMsgContent(type, null);
        GeneralPKIMessage response = this.send(caName, request, debug);
        ASN1Encodable itvValue = CmpAgent.parseGenRep(response, type);
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)itvValue);
        int retSize = Math.min(maxNumCerts, seq.size());
        ArrayList<X509Cert> certs = new ArrayList<X509Cert>(retSize);
        for (int i = 0; i < retSize; ++i) {
            certs.add(new X509Cert(Certificate.getInstance((Object)seq.getObjectAt(i))));
        }
        return certs;
    }

    RevokeCertResponse revokeCertificate(String caName, Requestor requestor, RevokeCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Responder responder = this.getResponder(requestor);
        PKIMessage reqMessage = this.buildRevokeCertRequest(requestor, responder, (RevokeCertRequest)Args.notNull((Object)request, (String)"request"));
        VerifiedPkiMessage response = this.signAndSend(caName, requestor, responder, reqMessage, debug);
        return CmpAgent.parse(response, request.getRequestEntries());
    }

    RevokeCertResponse unrevokeCertificate(String caName, Requestor requestor, UnrevokeCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Responder responder = this.getResponder(requestor);
        PKIMessage reqMessage = this.buildUnrevokeCertRequest(requestor, responder, (UnrevokeCertRequest)Args.notNull((Object)request, (String)"request"), CrlReason.REMOVE_FROM_CRL.getCode());
        VerifiedPkiMessage response = this.signAndSend(caName, requestor, responder, reqMessage, debug);
        return CmpAgent.parse(response, request.getRequestEntries());
    }

    EnrollCertResponse requestCertificate(String caName, Requestor requestor, CsrEnrollCertRequest csr, Date notBefore, Date notAfter, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Responder responder = this.getResponder(requestor);
        PKIMessage request = this.buildPkiMessage(requestor, responder, (CsrEnrollCertRequest)Args.notNull((Object)csr, (String)"csr"), notBefore, notAfter);
        HashMap<BigInteger, String> reqIdIdMap = new HashMap<BigInteger, String>();
        reqIdIdMap.put(MINUS_ONE, csr.getId());
        return this.requestCertificate0(caName, requestor, responder, request, reqIdIdMap, 3, debug);
    }

    EnrollCertResponse requestCertificate(String caName, Requestor requestor, EnrollCertRequest req, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        int exptectedBodyType;
        Responder responder = this.getResponder(requestor);
        PKIMessage request = this.buildPkiMessage(requestor, responder, (EnrollCertRequest)Args.notNull((Object)req, (String)"req"));
        HashMap<BigInteger, String> reqIdIdMap = new HashMap<BigInteger, String>();
        List<EnrollCertRequest.Entry> reqEntries = req.getRequestEntries();
        for (EnrollCertRequest.Entry reqEntry : reqEntries) {
            reqIdIdMap.put(reqEntry.getCertReq().getCertReqId().getValue(), reqEntry.getId());
        }
        switch (req.getType()) {
            case INIT_REQ: {
                exptectedBodyType = 1;
                break;
            }
            case CERT_REQ: {
                exptectedBodyType = 3;
                break;
            }
            case KEY_UPDATE: {
                exptectedBodyType = 8;
                break;
            }
            case CROSS_CERT_REQ: {
                exptectedBodyType = 14;
                break;
            }
            default: {
                throw new IllegalStateException("unknown EnrollCertRequest.Type " + (Object)((Object)req.getType()));
            }
        }
        return this.requestCertificate0(caName, requestor, responder, request, reqIdIdMap, exptectedBodyType, debug);
    }

    private EnrollCertResponse requestCertificate0(String caName, Requestor requestor, Responder responder, PKIMessage reqMessage, Map<BigInteger, String> reqIdIdMap, int expectedBodyType, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        VerifiedPkiMessage response = this.signAndSend(caName, requestor, responder, reqMessage, debug);
        CmpAgent.checkProtection(response);
        PKIBody respBody = response.getPkiMessage().getBody();
        int bodyType = respBody.getType();
        if (23 == bodyType) {
            ErrorMsgContent content = ErrorMsgContent.getInstance((Object)respBody.getContent());
            throw new PkiErrorException(content.getPKIStatusInfo());
        }
        if (expectedBodyType != bodyType) {
            throw new CmpClientException(String.format("unknown PKI body type %s instead the expected [%s, %s]", bodyType, expectedBodyType, 23));
        }
        CertRepMessage certRep = CertRepMessage.getInstance((Object)respBody.getContent());
        CertResponse[] certResponses = certRep.getResponse();
        EnrollCertResponse result = new EnrollCertResponse();
        CMPCertificate[] caPubs = certRep.getCaPubs();
        if (caPubs != null && caPubs.length > 0) {
            for (CMPCertificate cMPCertificate : caPubs) {
                if (cMPCertificate == null) continue;
                result.addCaCertificate(cMPCertificate);
            }
        }
        CertificateConfirmationContentBuilder certConfirmBuilder = null;
        if (!CmpUtil.isImplicitConfirm(response.getPkiMessage().getHeader())) {
            certConfirmBuilder = new CertificateConfirmationContentBuilder();
        }
        boolean requireConfirm = false;
        for (CertResponse certResp : certResponses) {
            ResultEntry resultEntry;
            PKIStatusInfo statusInfo = certResp.getStatus();
            int status = statusInfo.getStatus().intValue();
            BigInteger certReqId = certResp.getCertReqId().getValue();
            String thisId = reqIdIdMap.get(certReqId);
            if (thisId != null) {
                reqIdIdMap.remove(certReqId);
            } else if (reqIdIdMap.size() == 1) {
                thisId = reqIdIdMap.values().iterator().next();
                reqIdIdMap.clear();
            }
            if (thisId == null) continue;
            if (status == 0 || status == 1) {
                CertifiedKeyPair cvk = certResp.getCertifiedKeyPair();
                if (cvk == null) {
                    return null;
                }
                CMPCertificate cmpCert = cvk.getCertOrEncCert().getCertificate();
                if (cmpCert == null) {
                    return null;
                }
                if (requestor == null) {
                    result.addResultEntry(new ResultEntry.Error(thisId, -1, 0x40000000, "could not decrypt PrivateKeyInfo/requestor is null"));
                    continue;
                }
                PrivateKeyInfo privKeyInfo = null;
                if (cvk.getPrivateKey() != null) {
                    byte[] decryptedValue;
                    try {
                        if (requestor instanceof Requestor.SignatureCmpRequestor) {
                            ConcurrentContentSigner requestSigner = ((Requestor.SignatureCmpRequestor)requestor).getSigner();
                            if (!(requestSigner.getSigningKey() instanceof PrivateKey)) {
                                throw new XiSecurityException("no decryption key is configured");
                            }
                            decryptedValue = CmpAgent.decrypt(cvk.getPrivateKey(), (PrivateKey)requestSigner.getSigningKey());
                        } else {
                            decryptedValue = CmpAgent.decrypt(cvk.getPrivateKey(), ((Requestor.PbmMacCmpRequestor)requestor).getPassword());
                        }
                    }
                    catch (XiSecurityException ex) {
                        result.addResultEntry(new ResultEntry.Error(thisId, -1, 0x40000000, "could not decrypt PrivateKeyInfo"));
                        continue;
                    }
                    privKeyInfo = PrivateKeyInfo.getInstance((Object)decryptedValue);
                }
                resultEntry = new ResultEntry.EnrollCert(thisId, cmpCert, privKeyInfo, status);
                if (certConfirmBuilder != null) {
                    requireConfirm = true;
                    X509CertificateHolder certHolder = new X509CertificateHolder(cmpCert.getX509v3PKCert());
                    certConfirmBuilder.addAcceptedCertificate(certHolder, certReqId);
                }
            } else {
                PKIFreeText statusString = statusInfo.getStatusString();
                String errorMessage = statusString == null ? null : statusString.getStringAtUTF8(0).getString();
                int failureInfo = statusInfo.getFailInfo().intValue();
                resultEntry = new ResultEntry.Error(thisId, status, failureInfo, errorMessage);
            }
            result.addResultEntry(resultEntry);
        }
        if (CollectionUtil.isNotEmpty(reqIdIdMap)) {
            for (Map.Entry entry : reqIdIdMap.entrySet()) {
                result.addResultEntry(new ResultEntry.Error((String)entry.getValue(), -2));
            }
        }
        if (!requireConfirm) {
            return result;
        }
        PKIMessage confirmRequest = this.buildCertConfirmRequest(requestor, responder, response.getPkiMessage().getHeader().getTransactionID(), certConfirmBuilder);
        response = this.signAndSend(caName, requestor, responder, confirmRequest, debug);
        CmpAgent.checkProtection(response);
        return result;
    }

    private PKIMessage buildCertConfirmRequest(Requestor requestor, Responder responder, ASN1OctetString tid, CertificateConfirmationContentBuilder certConfirmBuilder) throws CmpClientException {
        CertificateConfirmationContent certConfirm;
        PKIHeader header = this.buildPkiHeader(requestor, responder, true, tid, null, null);
        try {
            certConfirm = certConfirmBuilder.build(DIGEST_CALCULATOR_PROVIDER);
        }
        catch (CMPException ex) {
            throw new CmpClientException(ex.getMessage(), ex);
        }
        PKIBody body = new PKIBody(24, (ASN1Encodable)certConfirm.toASN1Structure());
        return new PKIMessage(header, body);
    }

    private PKIMessage buildRevokeCertRequest(Requestor requestor, Responder responder, RevokeCertRequest request) throws CmpClientException {
        PKIHeader header = this.buildPkiHeader(requestor, responder, null);
        List<RevokeCertRequest.Entry> requestEntries = request.getRequestEntries();
        ArrayList<RevDetails> revDetailsArray = new ArrayList<RevDetails>(requestEntries.size());
        for (RevokeCertRequest.Entry requestEntry : requestEntries) {
            Date invalidityDate;
            CertTemplateBuilder certTempBuilder = new CertTemplateBuilder();
            certTempBuilder.setIssuer(requestEntry.getIssuer());
            certTempBuilder.setSerialNumber(new ASN1Integer(requestEntry.getSerialNumber()));
            byte[] aki = requestEntry.getAuthorityKeyIdentifier();
            if (aki != null) {
                Extensions certTempExts = CmpAgent.getCertTempExtensions(aki);
                certTempBuilder.setExtensions(certTempExts);
            }
            int idx = (invalidityDate = requestEntry.getInvalidityDate()) == null ? 1 : 2;
            Extension[] extensions = new Extension[idx];
            try {
                ASN1Enumerated reason = new ASN1Enumerated(requestEntry.getReason());
                extensions[0] = new Extension(Extension.reasonCode, true, (ASN1OctetString)new DEROctetString(reason.getEncoded()));
                if (invalidityDate != null) {
                    ASN1GeneralizedTime time = new ASN1GeneralizedTime(invalidityDate);
                    extensions[1] = new Extension(Extension.invalidityDate, true, (ASN1OctetString)new DEROctetString(time.getEncoded()));
                }
            }
            catch (IOException ex) {
                throw new CmpClientException(ex.getMessage(), ex);
            }
            RevDetails revDetails = new RevDetails(certTempBuilder.build(), new Extensions(extensions));
            revDetailsArray.add(revDetails);
        }
        RevReqContent content = new RevReqContent(revDetailsArray.toArray(new RevDetails[0]));
        PKIBody body = new PKIBody(11, (ASN1Encodable)content);
        return new PKIMessage(header, body);
    }

    private PKIMessage buildUnrevokeCertRequest(Requestor requestor, Responder responder, UnrevokeCertRequest request, int reasonCode) throws CmpClientException {
        PKIHeader header = this.buildPkiHeader(requestor, responder, null);
        List<UnrevokeCertRequest.Entry> requestEntries = request.getRequestEntries();
        ArrayList<RevDetails> revDetailsArray = new ArrayList<RevDetails>(requestEntries.size());
        for (UnrevokeCertRequest.Entry requestEntry : requestEntries) {
            CertTemplateBuilder certTempBuilder = new CertTemplateBuilder();
            certTempBuilder.setIssuer(requestEntry.getIssuer());
            certTempBuilder.setSerialNumber(new ASN1Integer(requestEntry.getSerialNumber()));
            byte[] aki = requestEntry.getAuthorityKeyIdentifier();
            if (aki != null) {
                Extensions certTempExts = CmpAgent.getCertTempExtensions(aki);
                certTempBuilder.setExtensions(certTempExts);
            }
            Extension[] extensions = new Extension[1];
            try {
                ASN1Enumerated reason = new ASN1Enumerated(reasonCode);
                extensions[0] = new Extension(Extension.reasonCode, true, (ASN1OctetString)new DEROctetString(reason.getEncoded()));
            }
            catch (IOException ex) {
                throw new CmpClientException(ex.getMessage(), ex);
            }
            Extensions exts = new Extensions(extensions);
            RevDetails revDetails = new RevDetails(certTempBuilder.build(), exts);
            revDetailsArray.add(revDetails);
        }
        RevReqContent content = new RevReqContent(revDetailsArray.toArray(new RevDetails[0]));
        return new PKIMessage(header, new PKIBody(11, (ASN1Encodable)content));
    }

    private PKIMessage buildPkiMessage(Requestor requestor, Responder responder, CsrEnrollCertRequest csr, Date notBefore, Date notAfter) {
        CmpUtf8Pairs utf8Pairs = null;
        if (notBefore != null) {
            utf8Pairs = new CmpUtf8Pairs();
            utf8Pairs.putUtf8Pair("notbefore", DateUtil.toUtcTimeyyyyMMddhhmmss((Date)notBefore));
        }
        if (notAfter != null) {
            if (utf8Pairs == null) {
                utf8Pairs = new CmpUtf8Pairs();
            }
            utf8Pairs.putUtf8Pair("notafter", DateUtil.toUtcTimeyyyyMMddhhmmss((Date)notAfter));
        }
        InfoTypeAndValue certProfileItv = null;
        if (csr.getCertprofile() != null) {
            certProfileItv = new InfoTypeAndValue(ObjectIdentifiers.CMP.id_it_certProfile, (ASN1Encodable)new DERSequence((ASN1Encodable)new DERUTF8String(csr.getCertprofile())));
        }
        PKIHeader header = this.buildPkiHeader(requestor, responder, true, null, utf8Pairs, certProfileItv);
        return new PKIMessage(header, new PKIBody(4, (ASN1Encodable)csr.getCsr()));
    }

    private PKIMessage buildPkiMessage(Requestor requestor, Responder responder, EnrollCertRequest req) {
        int bodyType;
        List<EnrollCertRequest.Entry> reqEntries = req.getRequestEntries();
        CertReqMsg[] certReqMsgs = new CertReqMsg[reqEntries.size()];
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (int i = 0; i < reqEntries.size(); ++i) {
            EnrollCertRequest.Entry reqEntry = reqEntries.get(i);
            if (reqEntry.getCertprofile() != null) {
                vec.add((ASN1Encodable)new DERUTF8String(reqEntry.getCertprofile()));
            }
            certReqMsgs[i] = new CertReqMsg(reqEntry.getCertReq(), reqEntry.getPop(), null);
        }
        if (vec.size() != 0 && vec.size() != reqEntries.size()) {
            throw new IllegalStateException("either not all reqEntries have CertProfile or all not");
        }
        InfoTypeAndValue certProfile = new InfoTypeAndValue(ObjectIdentifiers.CMP.id_it_certProfile, (ASN1Encodable)new DERSequence(vec));
        PKIHeader header = this.buildPkiHeader(requestor, responder, true, null, null, certProfile);
        switch (req.getType()) {
            case INIT_REQ: {
                bodyType = 0;
                break;
            }
            case CERT_REQ: {
                bodyType = 2;
                break;
            }
            case KEY_UPDATE: {
                bodyType = 7;
                break;
            }
            case CROSS_CERT_REQ: {
                bodyType = 13;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown EnrollCertRequest.Type " + (Object)((Object)req.getType()));
            }
        }
        return new PKIMessage(header, new PKIBody(bodyType, (ASN1Encodable)new CertReqMessages(certReqMsgs)));
    }

    private static void checkProtection(VerifiedPkiMessage response) throws PkiErrorException {
        boolean valid;
        Args.notNull((Object)response, (String)"response");
        if (!response.hasProtection()) {
            return;
        }
        ProtectionVerificationResult protectionVerificationResult = response.getProtectionVerificationResult();
        if (protectionVerificationResult == null) {
            valid = false;
        } else {
            ProtectionResult protectionResult = protectionVerificationResult.getProtectionResult();
            boolean bl = valid = protectionResult == ProtectionResult.MAC_VALID || protectionResult == ProtectionResult.SIGNATURE_VALID;
        }
        if (!valid) {
            throw new PkiErrorException(-1, 64, "message check of the response failed");
        }
    }

    private static byte[] decrypt(EncryptedKey ek, char[] password) throws XiSecurityException {
        ASN1Encodable ekValue = ek.getValue();
        return ekValue instanceof EnvelopedData ? CmpAgent.decrypt((EnvelopedData)ekValue, password) : CmpAgent.decrypt((EncryptedValue)ekValue, password);
    }

    private static byte[] decrypt(EnvelopedData ed0, char[] password) throws XiSecurityException {
        try {
            CMSEnvelopedData ed = new CMSEnvelopedData(new ContentInfo(CMSObjectIdentifiers.envelopedData, (ASN1Encodable)ed0));
            RecipientInformationStore recipients = ed.getRecipientInfos();
            Iterator it = recipients.getRecipients().iterator();
            PasswordRecipientInformation recipient = (PasswordRecipientInformation)it.next();
            return recipient.getContent((Recipient)new BcPasswordEnvelopedRecipient(password));
        }
        catch (CMSException ex) {
            throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static byte[] decrypt(EncryptedValue ev, char[] password) throws XiSecurityException {
        AlgorithmIdentifier symmAlg = ev.getSymmAlg();
        if (!PKCSObjectIdentifiers.id_PBES2.equals((ASN1Primitive)symmAlg.getAlgorithm())) {
            throw new XiSecurityException("unsupported symmAlg " + symmAlg.getAlgorithm().getId());
        }
        PBES2Parameters alg = PBES2Parameters.getInstance((Object)symmAlg.getParameters());
        PBKDF2Params func = PBKDF2Params.getInstance((Object)alg.getKeyDerivationFunc().getParameters());
        AlgorithmIdentifier encScheme = AlgorithmIdentifier.getInstance((Object)alg.getEncryptionScheme());
        try {
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(alg.getKeyDerivationFunc().getAlgorithm().getId());
            int iterations = func.getIterationCount().intValue();
            SecretKey key = keyFact.generateSecret((KeySpec)new PBKDF2KeySpec(password, func.getSalt(), iterations, KEYSIZE_PROVIDER.getKeySize(encScheme), func.getPrf()));
            key = new SecretKeySpec(key.getEncoded(), "AES");
            String cipherAlgOid = alg.getEncryptionScheme().getAlgorithm().getId();
            Cipher cipher = Cipher.getInstance(cipherAlgOid);
            ASN1Encodable encParams = alg.getEncryptionScheme().getParameters();
            GCMParameters gcmParameters = GCMParameters.getInstance((Object)encParams);
            GCMParameterSpec gcmParamSpec = new GCMParameterSpec(gcmParameters.getIcvLen() * 8, gcmParameters.getNonce());
            cipher.init(2, (Key)key, gcmParamSpec);
            return cipher.doFinal(ev.getEncValue().getOctets());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new XiSecurityException("Error while decrypting the EncryptedValue", (Throwable)ex);
        }
    }

    private static byte[] decrypt(EncryptedKey ek, PrivateKey decKey) throws XiSecurityException {
        ASN1Encodable ekValue = ek.getValue();
        return ekValue instanceof EnvelopedData ? CmpAgent.decrypt((EnvelopedData)ekValue, decKey) : CmpAgent.decrypt((EncryptedValue)ekValue, decKey);
    }

    private static byte[] decrypt(EnvelopedData ed0, PrivateKey decKey) throws XiSecurityException {
        try {
            ContentInfo ci = new ContentInfo(CMSObjectIdentifiers.envelopedData, (ASN1Encodable)ed0);
            CMSEnvelopedData ed = new CMSEnvelopedData(ci);
            RecipientInformationStore recipients = ed.getRecipientInfos();
            Iterator it = recipients.getRecipients().iterator();
            RecipientInformation ri = (RecipientInformation)it.next();
            ASN1ObjectIdentifier encAlg = ri.getKeyEncryptionAlgorithm().getAlgorithm();
            Object recipient = encAlg.equals((ASN1Primitive)CMSAlgorithm.ECDH_SHA1KDF) || encAlg.equals((ASN1Primitive)CMSAlgorithm.ECDH_SHA224KDF) || encAlg.equals((ASN1Primitive)CMSAlgorithm.ECDH_SHA256KDF) || encAlg.equals((ASN1Primitive)CMSAlgorithm.ECDH_SHA384KDF) || encAlg.equals((ASN1Primitive)CMSAlgorithm.ECDH_SHA384KDF) || encAlg.equals((ASN1Primitive)CMSAlgorithm.ECDH_SHA512KDF) ? new JceKeyAgreeEnvelopedRecipient(decKey).setProvider("BC") : new JceKeyTransEnvelopedRecipient(decKey).setProvider("BC");
            return ri.getContent((Recipient)recipient);
        }
        catch (CMSException ex) {
            throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static byte[] decrypt(EncryptedValue ev, PrivateKey decKey) throws XiSecurityException {
        AlgorithmIdentifier keyAlg = ev.getKeyAlg();
        ASN1ObjectIdentifier keyOid = keyAlg.getAlgorithm();
        try {
            byte[] symmKey;
            if (decKey instanceof RSAPrivateKey) {
                Cipher keyCipher;
                if (keyOid.equals((ASN1Primitive)PKCSObjectIdentifiers.id_RSAES_OAEP)) {
                    if (keyAlg.getParameters() != null) {
                        RSAESOAEPparams params = RSAESOAEPparams.getInstance((Object)keyAlg.getParameters());
                        ASN1ObjectIdentifier oid = params.getHashAlgorithm().getAlgorithm();
                        if (!oid.equals((ASN1Primitive)RSAESOAEPparams.DEFAULT_HASH_ALGORITHM.getAlgorithm())) {
                            throw new XiSecurityException("unsupported RSAESOAEPparams.HashAlgorithm " + oid.getId());
                        }
                        oid = params.getMaskGenAlgorithm().getAlgorithm();
                        if (!oid.equals((ASN1Primitive)RSAESOAEPparams.DEFAULT_MASK_GEN_FUNCTION.getAlgorithm())) {
                            throw new XiSecurityException("unsupported RSAESOAEPparams.MaskGenAlgorithm " + oid.getId());
                        }
                        oid = params.getPSourceAlgorithm().getAlgorithm();
                        if (!params.getPSourceAlgorithm().equals((Object)RSAESOAEPparams.DEFAULT_P_SOURCE_ALGORITHM)) {
                            throw new XiSecurityException("unsupported RSAESOAEPparams.PSourceAlgorithm " + oid.getId());
                        }
                    }
                    keyCipher = Cipher.getInstance("RSA/NONE/OAEPPADDING");
                } else if (keyOid.equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption)) {
                    keyCipher = Cipher.getInstance("RSA/NONE/PKCS1PADDING");
                } else {
                    throw new XiSecurityException("unsupported keyAlg " + keyOid.getId());
                }
                keyCipher.init(2, decKey);
                symmKey = keyCipher.doFinal(ev.getEncSymmKey().getOctets());
            } else if (decKey instanceof ECPrivateKey) {
                ASN1Sequence params = ASN1Sequence.getInstance((Object)keyAlg.getParameters());
                int n = params.size();
                for (int i = 0; i < n; ++i) {
                    AlgorithmIdentifier hashAlgorithm;
                    AlgorithmIdentifier algId;
                    if (!keyOid.equals((ASN1Primitive)ObjectIdentifiers.Secg.id_ecies_specifiedParameters)) {
                        throw new XiSecurityException("unsupported keyAlg " + keyOid.getId());
                    }
                    ASN1TaggedObject to = (ASN1TaggedObject)params.getObjectAt(i);
                    int tag = to.getTagNo();
                    if (tag == 0) {
                        algId = AlgorithmIdentifier.getInstance((Object)to.getBaseObject());
                        if (ObjectIdentifiers.Misc.id_iso18033_kdf2.equals((ASN1Primitive)algId.getAlgorithm())) {
                            hashAlgorithm = AlgorithmIdentifier.getInstance((Object)algId.getParameters());
                            if (hashAlgorithm.getAlgorithm().equals((ASN1Primitive)HashAlgo.SHA1.getOid())) continue;
                            throw new XiSecurityException("unsupported KeyDerivationFunction.HashAlgorithm " + hashAlgorithm.getAlgorithm().getId());
                        }
                        throw new XiSecurityException("unsupported KeyDerivationFunction " + algId.getAlgorithm().getId());
                    }
                    if (tag == 1) {
                        algId = AlgorithmIdentifier.getInstance((Object)to.getBaseObject());
                        if (ObjectIdentifiers.Secg.id_aes128_cbc_in_ecies.equals((ASN1Primitive)algId.getAlgorithm())) continue;
                        throw new XiSecurityException("unsupported SymmetricEncryption " + algId.getAlgorithm().getId());
                    }
                    if (tag != 2) continue;
                    algId = AlgorithmIdentifier.getInstance((Object)to.getBaseObject());
                    if (ObjectIdentifiers.Secg.id_hmac_full_ecies.equals((ASN1Primitive)algId.getAlgorithm())) {
                        hashAlgorithm = AlgorithmIdentifier.getInstance((Object)algId.getParameters());
                        if (hashAlgorithm.getAlgorithm().equals((ASN1Primitive)HashAlgo.SHA1.getOid())) continue;
                        throw new XiSecurityException("unsupported MessageAuthenticationCode.HashAlgorithm " + hashAlgorithm.getAlgorithm().getId());
                    }
                    throw new XiSecurityException("unsupported MessageAuthenticationCode " + algId.getAlgorithm().getId());
                }
                int aesKeySize = 128;
                byte[] iv = new byte[16];
                IESParameterSpec spec = new IESParameterSpec(null, null, aesKeySize, aesKeySize, iv);
                CBCBlockCipher cbcCipher = new CBCBlockCipher((BlockCipher)new AESEngine());
                IESEngine engine = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()), (Mac)new HMac(DigestFactory.createSHA1()), (BufferedBlockCipher)new PaddedBufferedBlockCipher((BlockCipher)cbcCipher));
                IESCipher keyCipher = new IESCipher(engine, 16);
                keyCipher.engineInit(2, (Key)decKey, (AlgorithmParameterSpec)spec, null);
                byte[] encSymmKey = ev.getEncSymmKey().getOctets();
                ASN1Sequence seq = DERSequence.getInstance((Object)encSymmKey);
                byte[] ephemeralPublicKey = DEROctetString.getInstance((Object)seq.getObjectAt(0)).getOctets();
                byte[] symmetricCiphertext = DEROctetString.getInstance((Object)seq.getObjectAt(1)).getOctets();
                byte[] macTag = DEROctetString.getInstance((Object)seq.getObjectAt(2)).getOctets();
                byte[] bcInput = new byte[ephemeralPublicKey.length + symmetricCiphertext.length + macTag.length];
                System.arraycopy(ephemeralPublicKey, 0, bcInput, 0, ephemeralPublicKey.length);
                int offset = ephemeralPublicKey.length;
                System.arraycopy(symmetricCiphertext, 0, bcInput, offset, symmetricCiphertext.length);
                System.arraycopy(macTag, 0, bcInput, offset += symmetricCiphertext.length, macTag.length);
                symmKey = keyCipher.engineDoFinal(bcInput, 0, bcInput.length);
            } else {
                throw new XiSecurityException("unsupported decryption key type " + decKey.getClass().getName());
            }
            AlgorithmIdentifier symmAlg = ev.getSymmAlg();
            ASN1ObjectIdentifier symmAlgOid = symmAlg.getAlgorithm();
            if (!symmAlgOid.equals((ASN1Primitive)NISTObjectIdentifiers.id_aes128_GCM)) {
                throw new XiSecurityException("unsupported symmAlg " + symmAlgOid.getId());
            }
            GCMParameters params = GCMParameters.getInstance((Object)symmAlg.getParameters());
            Cipher dataCipher = Cipher.getInstance(symmAlgOid.getId());
            GCMParameterSpec algParams = new GCMParameterSpec(params.getIcvLen() << 3, params.getNonce());
            dataCipher.init(2, (Key)new SecretKeySpec(symmKey, "AES"), algParams);
            byte[] encValue = ev.getEncValue().getOctets();
            return dataCipher.doFinal(encValue);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new XiSecurityException("Error while decrypting the EncryptedValue", (Throwable)ex);
        }
    }

    private static ASN1Encodable parseGenRep(GeneralPKIMessage response, ASN1ObjectIdentifier expectedType) throws CmpClientException, PkiErrorException {
        PKIBody respBody = response.getBody();
        int bodyType = respBody.getType();
        if (23 == bodyType) {
            ErrorMsgContent content = ErrorMsgContent.getInstance((Object)respBody.getContent());
            throw new PkiErrorException(content.getPKIStatusInfo());
        }
        if (22 != bodyType) {
            throw new CmpClientException(String.format("unknown PKI body type %s instead the expected [%s, %s]", bodyType, 22, 23));
        }
        GenRepContent genRep = GenRepContent.getInstance((Object)respBody.getContent());
        InfoTypeAndValue[] itvs = genRep.toInfoTypeAndValueArray();
        InfoTypeAndValue itv = null;
        if (itvs != null && itvs.length > 0) {
            for (InfoTypeAndValue m : itvs) {
                if (!expectedType.equals((ASN1Primitive)m.getInfoType())) continue;
                itv = m;
                break;
            }
        }
        if (itv == null) {
            throw new CmpClientException("the response does not contain InfoTypeAndValue " + expectedType);
        }
        return itv.getInfoValue();
    }

    private static RevokeCertResponse parse(VerifiedPkiMessage response, List<? extends UnrevokeCertRequest.Entry> reqEntries) throws CmpClientException, PkiErrorException {
        CmpAgent.checkProtection((VerifiedPkiMessage)Args.notNull((Object)response, (String)"response"));
        PKIBody respBody = response.getPkiMessage().getBody();
        int bodyType = respBody.getType();
        if (23 == bodyType) {
            ErrorMsgContent content = ErrorMsgContent.getInstance((Object)respBody.getContent());
            throw new PkiErrorException(content.getPKIStatusInfo());
        }
        if (12 != bodyType) {
            throw new CmpClientException(String.format("unknown PKI body type %s instead the expected [%s, %s]", bodyType, 12, 23));
        }
        RevRepContent content = RevRepContent.getInstance((Object)respBody.getContent());
        PKIStatusInfo[] statuses = content.getStatus();
        if (statuses == null || statuses.length != reqEntries.size()) {
            int statusesLen = 0;
            if (statuses != null) {
                statusesLen = statuses.length;
            }
            throw new CmpClientException(String.format("incorrect number of status entries in response '%s' instead the expected '%s'", statusesLen, reqEntries.size()));
        }
        CertId[] revCerts = content.getRevCerts();
        RevokeCertResponse result = new RevokeCertResponse();
        for (int i = 0; i < statuses.length; ++i) {
            PKIStatusInfo statusInfo = statuses[i];
            int status = statusInfo.getStatus().intValue();
            UnrevokeCertRequest.Entry re = reqEntries.get(i);
            if (status != 0 && status != 1) {
                PKIFreeText text = statusInfo.getStatusString();
                String statusString = text == null ? null : text.getStringAtUTF8(0).getString();
                ResultEntry.Error resultEntry = new ResultEntry.Error(re.getId(), status, statusInfo.getFailInfo().intValue(), statusString);
                result.addResultEntry(resultEntry);
                continue;
            }
            CertId certId = null;
            if (revCerts != null) {
                for (CertId entry : revCerts) {
                    if (!re.getIssuer().equals((Object)entry.getIssuer().getName()) || !re.getSerialNumber().equals(entry.getSerialNumber().getValue())) continue;
                    certId = entry;
                    break;
                }
            }
            if (certId == null) {
                LOG.warn("certId is not present in response for (issuer='{}', serialNumber={})", (Object)X509Util.x500NameText((X500Name)re.getIssuer()), (Object)LogUtil.formatCsn((BigInteger)re.getSerialNumber()));
                certId = new CertId(new GeneralName(re.getIssuer()), re.getSerialNumber());
            }
            result.addResultEntry(new ResultEntry.RevokeCert(re.getId(), certId));
        }
        return result;
    }

    private static Extensions getCertTempExtensions(byte[] authorityKeyIdentifier) throws CmpClientException {
        byte[] encodedAki;
        AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier(authorityKeyIdentifier);
        try {
            encodedAki = aki.getEncoded();
        }
        catch (IOException ex) {
            throw new CmpClientException("could not encoded AuthorityKeyIdentifier", ex);
        }
        return new Extensions(new Extension(Extension.authorityKeyIdentifier, false, encodedAki));
    }
}

