/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp;

import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.xipki.cmp.CmpFailureUtil;
import org.xipki.util.Args;

public class PkiStatusInfo {
    private final int status;
    private final int pkiFailureInfo;
    private final String statusMessage;

    public PkiStatusInfo(int status, int pkiFailureInfo, String statusMessage) {
        this.status = status;
        this.pkiFailureInfo = pkiFailureInfo;
        this.statusMessage = statusMessage;
    }

    public PkiStatusInfo(int status) {
        this.status = status;
        this.pkiFailureInfo = 0;
        this.statusMessage = null;
    }

    public PkiStatusInfo(PKIStatusInfo bcPkiStatusInfo) {
        Args.notNull((Object)bcPkiStatusInfo, (String)"bcPkiStatusInfo");
        this.status = bcPkiStatusInfo.getStatus().intValue();
        this.pkiFailureInfo = bcPkiStatusInfo.getFailInfo() == null ? 0 : bcPkiStatusInfo.getFailInfo().intValue();
        PKIFreeText text = bcPkiStatusInfo.getStatusString();
        this.statusMessage = text == null ? null : text.getStringAtUTF8(0).getString();
    }

    public int status() {
        return this.status;
    }

    public int pkiFailureInfo() {
        return this.pkiFailureInfo;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String toString() {
        return CmpFailureUtil.formatPkiStatusInfo(this.status, this.pkiFailureInfo, this.statusMessage);
    }
}

