/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme.util;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.Pack;
import org.xipki.ca.gateway.acme.AcmeProtocolException;
import org.xipki.ca.gateway.acme.util.AcmeJson;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Base64Url;

public final class AcmeUtils {
    private static final Pattern DATE_PATTERN = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})(?:\\.(\\d{1,3})\\d*)?(Z|[+-]\\d{2}:?\\d{2})$", 2);
    private static final Pattern TZ_PATTERN = Pattern.compile("([+-])(\\d{2}):?(\\d{2})$");

    private AcmeUtils() {
    }

    public static Instant parseTimestamp(String str) {
        Matcher m = DATE_PATTERN.matcher(str);
        if (!m.matches()) {
            throw new IllegalArgumentException("Illegal date: " + str);
        }
        int year = Integer.parseInt(m.group(1));
        int month = Integer.parseInt(m.group(2));
        int dom = Integer.parseInt(m.group(3));
        int hour = Integer.parseInt(m.group(4));
        int minute = Integer.parseInt(m.group(5));
        int second = Integer.parseInt(m.group(6));
        StringBuilder msStr = new StringBuilder();
        if (m.group(7) != null) {
            msStr.append(m.group(7));
        }
        while (msStr.length() < 3) {
            msStr.append('0');
        }
        int ms = Integer.parseInt(msStr.toString());
        String tz = m.group(8);
        tz = "Z".equalsIgnoreCase(tz) ? "GMT" : TZ_PATTERN.matcher(tz).replaceAll("GMT$1$2:$3");
        return ZonedDateTime.of(year, month, dom, hour, minute, second, ms * 1000000, ZoneId.of(tz)).toInstant();
    }

    public static PublicKey jwkPublicKey(Map<String, String> jwk) throws InvalidKeySpecException {
        String kty = jwk.get("kty");
        if ("RSA".equalsIgnoreCase(kty)) {
            BigInteger n = new BigInteger(1, Base64Url.decodeFast((String)jwk.get("n")));
            BigInteger e = new BigInteger(1, Base64Url.decodeFast((String)jwk.get("e")));
            return KeyUtil.generateRSAPublicKey((RSAPublicKeySpec)new RSAPublicKeySpec(n, e));
        }
        if ("EC".equalsIgnoreCase(kty)) {
            String curveName = jwk.get("crv");
            ASN1ObjectIdentifier curveOid = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)curveName);
            byte[] x = Base64Url.decodeFast((String)jwk.get("x"));
            byte[] y = Base64Url.decodeFast((String)jwk.get("y"));
            byte[] encodedPoint = AcmeUtils.buildECPublicKeyData(curveOid, x, y);
            return KeyUtil.createECPublicKey((ASN1ObjectIdentifier)curveOid, (byte[])encodedPoint);
        }
        throw new InvalidKeySpecException("unsupported kty " + kty);
    }

    public static boolean matchKey(Map<String, String> jwk, SubjectPublicKeyInfo pkInfo) throws InvalidKeySpecException {
        AlgorithmIdentifier pkInfoAlgo = pkInfo.getAlgorithm();
        ASN1ObjectIdentifier pkKeyAlgo = pkInfoAlgo.getAlgorithm();
        String kty = jwk.get("kty");
        if ("RSA".equalsIgnoreCase(kty)) {
            if (!(pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption) || pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.id_RSASSA_PSS) || pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.sha1WithRSAEncryption) || pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.sha224WithRSAEncryption) || pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.sha256WithRSAEncryption) || pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.sha384WithRSAEncryption) || pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                return false;
            }
            BigInteger n = new BigInteger(1, Base64Url.decodeFast((String)jwk.get("n")));
            BigInteger e = new BigInteger(1, Base64Url.decodeFast((String)jwk.get("e")));
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)pkInfo.getPublicKeyData().getOctets());
            BigInteger n2 = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getPositiveValue();
            BigInteger e2 = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getPositiveValue();
            return n.equals(n2) && e.equals(e2);
        }
        if ("EC".equalsIgnoreCase(kty)) {
            ASN1ObjectIdentifier curveOid2;
            if (!X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)pkKeyAlgo)) {
                return false;
            }
            try {
                curveOid2 = ASN1ObjectIdentifier.getInstance((Object)pkInfoAlgo.getParameters());
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
            String curveName = jwk.get("crv");
            ASN1ObjectIdentifier curveOid = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)curveName);
            if (!curveOid2.equals((ASN1Primitive)curveOid)) {
                return false;
            }
            byte[] x = Base64Url.decodeFast((String)jwk.get("x"));
            byte[] y = Base64Url.decodeFast((String)jwk.get("y"));
            byte[] encodedPoint = AcmeUtils.buildECPublicKeyData(curveOid, x, y);
            return Arrays.equals(pkInfo.getPublicKeyData().getBytes(), encodedPoint);
        }
        throw new RuntimeException("unsupported kty " + kty);
    }

    private static byte[] buildECPublicKeyData(ASN1ObjectIdentifier curveOid, byte[] x, byte[] y) throws InvalidKeySpecException {
        int i;
        int fieldSize = SECObjectIdentifiers.secp192r1.equals((ASN1Primitive)curveOid) || TeleTrusTObjectIdentifiers.brainpoolP192r1.equals((ASN1Primitive)curveOid) ? 24 : (SECObjectIdentifiers.secp224r1.equals((ASN1Primitive)curveOid) || TeleTrusTObjectIdentifiers.brainpoolP224r1.equals((ASN1Primitive)curveOid) ? 28 : (SECObjectIdentifiers.secp256r1.equals((ASN1Primitive)curveOid) || TeleTrusTObjectIdentifiers.brainpoolP256r1.equals((ASN1Primitive)curveOid) || GMObjectIdentifiers.sm2p256v1.equals((ASN1Primitive)curveOid) ? 32 : (SECObjectIdentifiers.secp384r1.equals((ASN1Primitive)curveOid) || TeleTrusTObjectIdentifiers.brainpoolP384r1.equals((ASN1Primitive)curveOid) ? 48 : (TeleTrusTObjectIdentifiers.brainpoolP256r1.equals((ASN1Primitive)curveOid) ? 64 : (SECObjectIdentifiers.secp521r1.equals((ASN1Primitive)curveOid) ? 66 : Math.max(x.length, y.length))))));
        byte[] res = new byte[1 + 2 * fieldSize];
        res[0] = 4;
        int off = 1;
        if (x.length > fieldSize) {
            for (i = 0; i < x.length - fieldSize; ++i) {
                if (x[i] == 0) continue;
                throw new InvalidKeySpecException("x too large");
            }
            System.arraycopy(x, x.length - fieldSize, res, off, fieldSize);
        } else {
            System.arraycopy(x, 0, res, off + fieldSize - x.length, x.length);
        }
        off = 1 + fieldSize;
        if (y.length > fieldSize) {
            for (i = 0; i < y.length - fieldSize; ++i) {
                if (y[i] == 0) continue;
                throw new InvalidKeySpecException("y too large");
            }
            System.arraycopy(y, y.length - fieldSize, res, off, fieldSize);
        } else {
            System.arraycopy(y, 0, res, off + fieldSize - y.length, x.length);
        }
        return res;
    }

    public static Map<String, String> jsonToMap(AcmeJson json) throws AcmeProtocolException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : json.keySet()) {
            map.put(name, json.get(name).asString());
        }
        return map;
    }

    public static String toBase64(long label) {
        return Base64Url.encodeToStringNoPadding((byte[])Pack.longToLittleEndian((long)label));
    }

    public static String jwkSha256(Map<String, String> jwk) {
        ArrayList<String> jwkNames = new ArrayList<String>(jwk.keySet());
        Collections.sort(jwkNames);
        StringBuilder canonJwk = new StringBuilder();
        canonJwk.append("{");
        for (String jwkName : jwkNames) {
            canonJwk.append("\"").append(jwkName).append("\":\"").append(jwk.get(jwkName)).append("\",");
        }
        canonJwk.deleteCharAt(canonJwk.length() - 1);
        canonJwk.append("}");
        return Base64Url.encodeToStringNoPadding((byte[])HashAlgo.SHA256.hash((byte[][])new byte[][]{canonJwk.toString().getBytes(StandardCharsets.UTF_8)}));
    }
}

