/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme.util;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jose4j.json.JsonUtil;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.gateway.acme.AcmeProtocolException;
import org.xipki.ca.gateway.acme.type.AcmeError;
import org.xipki.util.LogUtil;

public final class AcmeJson {
    private static final Logger LOG = LoggerFactory.getLogger(AcmeJson.class);
    private final String path;
    private final Map<String, Object> data;

    private AcmeJson(Map<String, Object> data) {
        this("", data);
    }

    private AcmeJson(String path, Map<String, Object> data) {
        this.path = path;
        this.data = data;
    }

    public static AcmeJson parse(byte[] bytes) throws AcmeProtocolException {
        return AcmeJson.parse(new String(bytes, StandardCharsets.UTF_8));
    }

    public static AcmeJson parse(String json) throws AcmeProtocolException {
        try {
            return new AcmeJson(JsonUtil.parseJson((String)json));
        }
        catch (JoseException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            throw new AcmeProtocolException(400, AcmeError.malformed, "Bad JSON: " + json);
        }
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    public Value get(String key) {
        return new Value((String)(this.path.isEmpty() ? key : this.path + "." + key), this.data.get(key));
    }

    public String toString() {
        return JsonUtil.toJson(this.data);
    }

    private static class ValueIterator
    implements Iterator<Value> {
        private final Array array;
        private int index = 0;

        public ValueIterator(Array array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.size();
        }

        @Override
        public Value next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Value {
        private final String path;
        private final Object val;

        private Value(String path, Object val) {
            this.path = path;
            this.val = val;
        }

        public boolean isPresent() {
            return this.val != null;
        }

        public Optional<Value> optional() {
            return this.val != null ? Optional.of(this) : Optional.empty();
        }

        public String asString() throws AcmeProtocolException {
            this.required();
            return this.val.toString();
        }

        public AcmeJson asObject() throws AcmeProtocolException {
            this.required();
            try {
                return new AcmeJson(this.path, (Map)this.val);
            }
            catch (ClassCastException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                throw new AcmeProtocolException(400, AcmeError.malformed, this.path + ": expected an object");
            }
        }

        private void required() throws AcmeProtocolException {
            if (!this.isPresent()) {
                throw new AcmeProtocolException(400, AcmeError.malformed, this.path + ": required, but not set");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            return Objects.equals(this.val, ((Value)obj).val);
        }

        public int hashCode() {
            return this.val != null ? this.val.hashCode() : 0;
        }
    }

    public static final class Array
    implements Iterable<Value> {
        private final String path;
        private final List<Object> data;

        private Array(String path, List<Object> data) {
            this.path = path;
            this.data = data;
        }

        public int size() {
            return this.data.size();
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public Value get(int index) {
            return new Value(this.path + "[" + index + "]", this.data.get(index));
        }

        public Stream<Value> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public Iterator<Value> iterator() {
            return new ValueIterator(this);
        }
    }
}

