/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.util.regex.Pattern;

public interface ContactVerifier {
    public static final int invalidContact = 1;
    public static final int unsupportedContact = 2;

    public int verfifyContact(String var1);

    public static class DfltContactVerifier
    implements ContactVerifier {
        private final Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$");

        @Override
        public int verfifyContact(String contact) {
            if (contact == null || !contact.startsWith("mailto:")) {
                return 2;
            }
            return this.pattern.matcher(contact.substring(7)).matches() ? 0 : 1;
        }
    }
}

