/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import org.bouncycastle.util.Pack;
import org.xipki.util.Args;
import org.xipki.util.Base64Url;

public class AuthzId {
    private final long orderId;
    private final int subId;
    private final String idText;

    public AuthzId(long orderId, int subId) {
        this.orderId = orderId;
        this.subId = Args.range((int)subId, (String)"subId", (int)0, (int)65535);
        byte[] orderIdBytes = Pack.longToBigEndian((long)orderId);
        byte[] encoded = new byte[10];
        encoded[0] = (byte)subId;
        encoded[1] = (byte)(subId >> 8);
        for (int i = 0; i < 8; ++i) {
            encoded[2 + i] = orderIdBytes[7 - i];
        }
        this.idText = Base64Url.encodeToStringNoPadding((byte[])encoded);
    }

    public AuthzId(byte[] encoded) {
        if (encoded.length != 10) {
            throw new IllegalArgumentException("invalid encoded.length");
        }
        this.subId = (encoded[0] & 0xFF) + ((encoded[1] & 0xFF) << 8);
        this.orderId = Pack.littleEndianToLong((byte[])encoded, (int)2);
        this.idText = Base64Url.encodeToStringNoPadding((byte[])encoded);
    }

    public long getOrderId() {
        return this.orderId;
    }

    public int getSubId() {
        return this.subId;
    }

    public String toString() {
        return this.idText;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AuthzId)) {
            return false;
        }
        AuthzId b = (AuthzId)other;
        return this.orderId == b.orderId && this.subId == b.subId;
    }

    public String toIdText() {
        return this.idText;
    }
}

