/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.xipki.ca.gateway.acme.AcmeAuthz;
import org.xipki.ca.gateway.acme.ChallId;
import org.xipki.ca.gateway.acme.msg.ChallengeResponse;
import org.xipki.ca.gateway.acme.type.ChallengeStatus;
import org.xipki.util.CompareUtil;

public class AcmeChallenge {
    private int subId;
    private String expectedAuthorization;
    private ChallengeStatus status;
    private String type;
    private String token;
    private Instant validated;
    private AcmeAuthz authz;

    private AcmeChallenge() {
    }

    public AcmeChallenge(int subId, String expectedAuthorization) {
        this.subId = subId;
        this.expectedAuthorization = expectedAuthorization;
    }

    private void setSubId(int subId) {
        this.subId = subId;
    }

    private void setExpectedAuthorization(String expectedAuthorization) {
        this.expectedAuthorization = expectedAuthorization;
    }

    public AcmeAuthz authz() {
        return this.authz;
    }

    public void authz(AcmeAuthz authz) {
        this.authz = authz;
    }

    public int getSubId() {
        return this.subId;
    }

    public Instant getValidated() {
        return this.validated;
    }

    private void setValidated(Instant validated) {
        this.validated = validated;
    }

    public void validated(Instant validated) {
        this.markOrder();
        this.setValidated(validated);
    }

    public String getType() {
        return this.type;
    }

    private void setType(String type) {
        this.type = type;
    }

    public void type(String type) {
        this.markOrder();
        this.setType(type);
    }

    public String getToken() {
        return this.token;
    }

    private void setToken(String token) {
        this.token = token;
    }

    public void token(String token) {
        this.markOrder();
        this.setToken(token);
    }

    public ChallengeStatus getStatus() {
        return this.status;
    }

    private void setStatus(ChallengeStatus status) {
        this.status = status;
    }

    public void status(ChallengeStatus status) {
        this.markOrder();
        this.setStatus(status);
    }

    public String getExpectedAuthorization() {
        return this.expectedAuthorization;
    }

    private void markOrder() {
        if (this.authz != null) {
            this.authz.markOrder();
        }
    }

    public ChallengeResponse toChallengeResponse(String baseUrl, long orderId, int authzId) {
        ChallengeResponse resp = new ChallengeResponse();
        if (this.validated != null) {
            resp.setValidated(this.validated.truncatedTo(ChronoUnit.SECONDS).toString());
        }
        ChallId challId = new ChallId(orderId, authzId, this.subId);
        resp.setUrl(baseUrl + "chall/" + challId.toIdText());
        resp.setStatus(this.status);
        resp.setType(this.type);
        resp.setToken(this.token);
        return resp;
    }

    public AcmeChallenge copy() {
        AcmeChallenge copy = new AcmeChallenge(this.subId, this.expectedAuthorization);
        copy.status = this.status;
        copy.type = this.type;
        copy.token = this.token;
        copy.validated = this.validated;
        return copy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AcmeChallenge)) {
            return false;
        }
        AcmeChallenge b = (AcmeChallenge)obj;
        return this.subId == b.subId && this.status == b.status && CompareUtil.equalsObject((Object)this.type, (Object)b.type) && CompareUtil.equalsObject((Object)this.token, (Object)b.token) && CompareUtil.equalsObject((Object)this.validated, (Object)b.validated) && CompareUtil.equalsObject((Object)this.expectedAuthorization, (Object)b.expectedAuthorization);
    }
}

