/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.xipki.ca.gateway.acme.AcmeChallenge;
import org.xipki.ca.gateway.acme.AcmeIdentifier;
import org.xipki.ca.gateway.acme.AcmeOrder;
import org.xipki.ca.gateway.acme.AuthzId;
import org.xipki.ca.gateway.acme.msg.AuthzResponse;
import org.xipki.ca.gateway.acme.msg.ChallengeResponse;
import org.xipki.ca.gateway.acme.type.AuthzStatus;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;

public class AcmeAuthz {
    private int subId;
    private AcmeIdentifier identifier;
    private AuthzStatus status;
    private Instant expires;
    private List<AcmeChallenge> challenges;
    private AcmeOrder order;

    private AcmeAuthz() {
    }

    public AcmeAuthz(int subId, AcmeIdentifier identifier) {
        this.subId = (Integer)Args.notNull((Object)subId, (String)"subId");
        this.identifier = (AcmeIdentifier)Args.notNull((Object)identifier, (String)"identifier");
    }

    private void setSubId(int subId) {
        this.subId = subId;
    }

    private void setIdentifier(AcmeIdentifier identifier) {
        this.identifier = identifier;
    }

    public AcmeOrder order() {
        return this.order;
    }

    public void order(AcmeOrder order) {
        this.order = order;
    }

    public int getSubId() {
        return this.subId;
    }

    public AuthzStatus getStatus() {
        return this.status;
    }

    private void setStatus(AuthzStatus status) {
        this.status = status;
    }

    public void status(AuthzStatus status) {
        this.markOrder();
        this.setStatus(status);
    }

    public Instant getExpires() {
        return this.expires;
    }

    private void setExpires(Instant expires) {
        this.expires = expires;
    }

    public void expires(Instant expires) {
        this.markOrder();
        this.setExpires(expires);
    }

    public AcmeIdentifier getIdentifier() {
        return this.identifier;
    }

    public List<AcmeChallenge> getChallenges() {
        return this.challenges;
    }

    private void setChallenges(List<AcmeChallenge> challenges) {
        this.challenges = challenges;
        if (challenges != null) {
            for (AcmeChallenge chall : challenges) {
                chall.authz(this);
            }
        }
    }

    public void challenges(List<AcmeChallenge> challenges) {
        this.markOrder();
        this.setChallenges(challenges);
    }

    void markOrder() {
        if (this.order != null) {
            this.order.markMe();
        }
    }

    public AuthzResponse toResponse(String baseUrl, long orderId) {
        AuthzResponse resp = new AuthzResponse();
        resp.setExpires(this.expires.toString());
        resp.setStatus(this.status);
        resp.setIdentifier(this.identifier.toIdentifier());
        ArrayList<ChallengeResponse> challResps = new ArrayList<ChallengeResponse>(this.challenges.size());
        resp.setChallenges(challResps);
        for (AcmeChallenge chall : this.challenges) {
            challResps.add(chall.toChallengeResponse(baseUrl, orderId, this.subId));
        }
        return resp;
    }

    public String getUrl(String baseUrl) {
        AuthzId authzId = new AuthzId(this.order.getId(), this.subId);
        return baseUrl + "authz/" + authzId.toIdText();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AcmeAuthz)) {
            return false;
        }
        AcmeAuthz b = (AcmeAuthz)other;
        return this.status == b.status && this.subId == b.subId && CompareUtil.equalsObject((Object)this.expires, (Object)b.expires) && CompareUtil.equalsObject((Object)this.identifier, (Object)b.identifier) && CompareUtil.equalsObject(this.challenges, b.challenges);
    }

    public AcmeAuthz copy() {
        AcmeAuthz copy = new AcmeAuthz(this.subId, this.identifier);
        copy.status = this.status;
        copy.expires = this.expires;
        if (this.challenges != null) {
            copy.challenges = new ArrayList<AcmeChallenge>(this.challenges.size());
            for (AcmeChallenge chall : this.challenges) {
                copy.challenges.add(chall.copy());
            }
        }
        return copy;
    }
}

