/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xipki.ca.gateway.acme.AcmeDataSource;
import org.xipki.ca.gateway.acme.AcmeSystemException;
import org.xipki.ca.gateway.acme.msg.AccountResponse;
import org.xipki.ca.gateway.acme.msg.JoseMessage;
import org.xipki.ca.gateway.acme.type.AccountStatus;
import org.xipki.ca.gateway.acme.util.AcmeUtils;
import org.xipki.util.Args;

public class AcmeAccount {
    private boolean inDb;
    private boolean marked;
    private AcmeAccount mark;
    private final long id;
    private final String idStr;
    private String jwkSha256;
    private AccountStatus status;
    private PublicKey publicKey;
    private final AcmeDataSource dataSource;
    private Data data;

    public AcmeAccount(long id, AcmeDataSource dataSource) {
        this.id = id;
        this.idStr = AcmeUtils.toBase64(id);
        this.dataSource = (AcmeDataSource)Args.notNull((Object)dataSource, (String)"dataSource");
        this.data = new Data();
    }

    public void setInDb(boolean inDb) {
        this.inDb = inDb;
    }

    public boolean hasJwk(Map<String, String> jwk) {
        return jwk != null && jwk.equals(this.data.jwk);
    }

    public long getId() {
        return this.id;
    }

    public String idText() {
        return this.idStr + " (" + this.id + ")";
    }

    public String getJwkSha256() {
        if (this.jwkSha256 == null && this.data.jwk != null) {
            this.jwkSha256 = AcmeUtils.jwkSha256(this.data.jwk);
        }
        return this.jwkSha256;
    }

    public void setJwkSha256(String jwkSha256) {
        this.markMe();
        this.jwkSha256 = jwkSha256;
    }

    public synchronized PublicKey getPublicKey() throws InvalidKeySpecException {
        if (this.publicKey == null && this.data.jwk != null) {
            this.publicKey = AcmeUtils.jwkPublicKey(this.data.jwk);
        }
        return this.publicKey;
    }

    public void setJwk(Map<String, String> jwk) {
        this.markMe();
        this.data.jwk = jwk;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.markMe();
        this.status = status;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public List<String> getContact() {
        return this.data.contact;
    }

    public void setContact(List<String> contact) {
        this.markMe();
        this.data.contact = contact;
    }

    public JoseMessage getExternalAccountBinding() {
        return this.data.externalAccountBinding;
    }

    public void setExternalAccountBinding(JoseMessage externalAccountBinding) {
        this.markMe();
        this.data.externalAccountBinding = externalAccountBinding;
    }

    public Boolean getTermsOfServiceAgreed() {
        return this.data.termsOfServiceAgreed;
    }

    public void setTermsOfServiceAgreed(Boolean termsOfServiceAgreed) {
        this.markMe();
        this.data.termsOfServiceAgreed = termsOfServiceAgreed;
    }

    public AccountResponse toResponse(String baseUrl) {
        AccountResponse resp = new AccountResponse();
        resp.setContact(this.data.contact);
        resp.setOrders(baseUrl + "orders/" + this.idStr);
        resp.setStatus(this.status);
        resp.setExternalAccountBinding(this.data.externalAccountBinding);
        resp.setTermsOfServiceAgreed(this.data.termsOfServiceAgreed);
        return resp;
    }

    public String getLocation(String baseUrl) {
        return baseUrl + "acct/" + this.idStr;
    }

    public void mark() {
        this.marked = true;
    }

    public synchronized void flush() throws AcmeSystemException {
        if (this.inDb) {
            if (this.mark != null) {
                this.dataSource.updateAccount(this.mark, this);
            }
        } else {
            this.dataSource.addNewAccount(this);
            this.inDb = true;
        }
        this.mark = null;
    }

    private synchronized void markMe() {
        if (!this.inDb || this.mark != null) {
            return;
        }
        AcmeAccount copy = new AcmeAccount(this.id, this.dataSource);
        copy.setJwkSha256(this.jwkSha256);
        copy.data = new Data();
        copy.setJwk(new HashMap<String, String>(this.data.jwk));
        copy.setStatus(this.status);
        copy.setTermsOfServiceAgreed(this.data.termsOfServiceAgreed);
        if (this.data.externalAccountBinding != null) {
            copy.setExternalAccountBinding(this.data.externalAccountBinding.copy());
        }
        if (this.data.contact != null) {
            copy.setContact(new ArrayList<String>(this.data.contact));
        }
        copy.inDb = this.inDb;
        copy.marked = this.marked;
        this.mark = copy;
    }

    public static class Data {
        private Map<String, String> jwk;
        private List<String> contact;
        private JoseMessage externalAccountBinding;
        private Boolean termsOfServiceAgreed;

        public Map<String, String> getJwk() {
            return this.jwk;
        }

        public void setJwk(Map<String, String> jwk) {
            this.jwk = jwk;
        }

        public List<String> getContact() {
            return this.contact;
        }

        public void setContact(List<String> contact) {
            this.contact = contact;
        }

        public JoseMessage getExternalAccountBinding() {
            return this.externalAccountBinding;
        }

        public void setExternalAccountBinding(JoseMessage externalAccountBinding) {
            this.externalAccountBinding = externalAccountBinding;
        }

        public Boolean getTermsOfServiceAgreed() {
            return this.termsOfServiceAgreed;
        }

        public void setTermsOfServiceAgreed(Boolean termsOfServiceAgreed) {
            this.termsOfServiceAgreed = termsOfServiceAgreed;
        }
    }
}

