/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.tomcat;

import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.xipki.password.PasswordResolver;
import org.xipki.password.Passwords;

public class TomcatPasswordResolver {
    public static TomcatPasswordResolver INSTANCE = new TomcatPasswordResolver();
    private boolean passwordResolverInitialized = false;
    private boolean passwordResolverInitFailed = false;
    private PasswordResolver passwordResolver;

    public void resolvePasswords(SSLHostConfig sslHostConfig) {
        String pwd = sslHostConfig.getTruststorePassword();
        if (pwd != null) {
            sslHostConfig.setTruststorePassword(this.resolvePassword(pwd));
        }
        if ((pwd = sslHostConfig.getCertificateKeystorePassword()) != null) {
            sslHostConfig.setCertificateKeystorePassword(this.resolvePassword(pwd));
        }
        if ((pwd = sslHostConfig.getCertificateKeyPassword()) != null) {
            sslHostConfig.setCertificateKeyPassword(this.resolvePassword(pwd));
        }
        Set certificates = sslHostConfig.getCertificates();
        for (SSLHostConfigCertificate certificate : certificates) {
            pwd = certificate.getCertificateKeyPassword();
            if (pwd != null) {
                certificate.setCertificateKeyPassword(this.resolvePassword(pwd));
            }
            if ((pwd = certificate.getCertificateKeystorePassword()) == null) continue;
            certificate.setCertificateKeystorePassword(this.resolvePassword(pwd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initPasswordResolver() {
        if (this.passwordResolverInitialized) {
            return;
        }
        try {
            Path p;
            String xipkiBase;
            Properties sysProps = System.getProperties();
            String confFile = sysProps.getProperty("XIPKI_PASSWORD_CFG");
            if (confFile == null && (xipkiBase = sysProps.getProperty("XIPKI_BASE")) != null && Files.exists(p = Paths.get(xipkiBase, "security", "password.cfg"), new LinkOption[0])) {
                confFile = p.toString();
            }
            Passwords.PasswordConf passwordConf = new Passwords.PasswordConf();
            if (confFile != null) {
                confFile = TomcatPasswordResolver.solveVariables(confFile, 0, sysProps);
                Properties passwordCfg = new Properties();
                try (FileReader reader = new FileReader(confFile);){
                    passwordCfg.load(reader);
                    String text = passwordCfg.getProperty("masterPasswordCallback");
                    if (text != null && !text.isEmpty()) {
                        passwordConf.setMasterPasswordCallback(TomcatPasswordResolver.solveVariables(text, 0, sysProps));
                    }
                    if ((text = passwordCfg.getProperty("singlePasswordResolvers")) != null && !text.trim().isEmpty()) {
                        StringTokenizer tokenizer = new StringTokenizer(text.trim(), " ,;:");
                        LinkedList<String> singleResolvers = new LinkedList<String>();
                        while (tokenizer.hasMoreTokens()) {
                            singleResolvers.add(tokenizer.nextToken());
                        }
                        passwordConf.setSinglePasswordResolvers(singleResolvers);
                    }
                }
            }
            Passwords passwords = new Passwords();
            passwords.init(passwordConf);
            this.passwordResolver = passwords.getPasswordResolver();
            this.passwordResolverInitFailed = false;
        }
        catch (Exception e) {
            this.passwordResolverInitFailed = true;
        }
        finally {
            this.passwordResolverInitialized = true;
        }
    }

    private static String solveVariables(String line, int offset, Properties properties) {
        int newOffset;
        if (offset + 4 >= line.length()) {
            return line;
        }
        int startIndex = line.indexOf("${", offset);
        if (startIndex == -1) {
            return line;
        }
        int endIndex = line.indexOf("}", startIndex + 2);
        if (endIndex == -1) {
            return line;
        }
        String variable = line.substring(startIndex, endIndex + 1);
        String variableName = variable.substring(2, variable.length() - 1);
        String value = properties.getProperty(variableName);
        if (value != null) {
            line = line.substring(0, startIndex) + value + line.substring(endIndex + 1);
            newOffset = startIndex + value.length() + 1;
        } else {
            newOffset = endIndex + 1;
        }
        return TomcatPasswordResolver.solveVariables(line, newOffset, properties);
    }

    String resolvePassword(String password) {
        if (password == null || password.isEmpty()) {
            return password;
        }
        int sepIndex = password.indexOf(58);
        if (sepIndex == -1) {
            return password;
        }
        this.initPasswordResolver();
        if (this.passwordResolverInitFailed) {
            return password;
        }
        try {
            char[] pwd = this.passwordResolver.resolvePassword(password);
            return new String(pwd);
        }
        catch (Exception e) {
            System.err.println("ERROR: could not resolve password");
            return password;
        }
    }
}

