/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit;

import org.xipki.audit.AuditService;
import org.xipki.audit.AuditServiceRuntimeException;
import org.xipki.audit.services.EmbedAuditService;
import org.xipki.audit.services.FileMacAuditService;
import org.xipki.audit.services.NoopAuditService;
import org.xipki.util.ConfPairs;
import org.xipki.util.ReflectiveUtil;

public class Audits {
    private static AuditService auditService;
    private static AuditServiceRuntimeException initializationException;

    private Audits() {
    }

    public static AuditService getAuditService() {
        if (auditService != null) {
            return auditService;
        }
        if (initializationException != null) {
            throw initializationException;
        }
        throw new IllegalStateException("Please call Audits.init() first.");
    }

    public static void init(String auditType, ConfPairs auditConf) {
        try {
            AuditService service;
            if ("embed".equalsIgnoreCase(auditType)) {
                service = new EmbedAuditService();
            } else if ("noop".equalsIgnoreCase(auditType)) {
                service = new NoopAuditService();
            } else if ("file-mac".equals(auditType)) {
                service = new FileMacAuditService();
            } else {
                String className = Audits.getClassName(auditType);
                service = (AuditService)ReflectiveUtil.newInstance((String)className);
            }
            service.init(auditConf);
            auditService = service;
        }
        catch (AuditServiceRuntimeException ex) {
            initializationException = ex;
        }
        catch (Exception ex) {
            initializationException = new AuditServiceRuntimeException(ex.getMessage(), ex);
        }
    }

    private static String getClassName(String auditType) {
        if (auditType.startsWith("java:")) {
            return auditType.substring("java:".length());
        }
        if ("database-mac".equals(auditType)) {
            return "org.xipki.audit.extra.DatabaseMacAuditService";
        }
        throw new AuditServiceRuntimeException("invalid Audit.Type '" + auditType + "'. Valid values are 'embed' or java:<name of class that implements " + AuditService.class.getName() + ">");
    }

    public static class AuditConf {
        private String type;
        private ConfPairs conf;
        public static AuditConf DEFAULT = new AuditConf();

        public String getType() {
            return this.type == null || this.type.isEmpty() ? "embed" : this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public ConfPairs getConf() {
            return this.conf;
        }

        public void setConf(ConfPairs conf) {
            this.conf = conf;
        }
    }
}

