/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit;

import java.io.CharArrayWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import org.xipki.audit.AuditLevel;
import org.xipki.util.Args;

public class PciAuditEvent {
    private static final String UNDEFINED = "undefined";
    private static final char DEFAULT_DELIMITER = ' ';
    private static final char DEFAULT_REPLACE_DELIMITER = '_';
    private static final ZoneId ZONE_UTC = ZoneId.of("UTC");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private String userId = "undefined";
    private String eventType = "undefined";
    private final String date;
    private final String time;
    private String status = "undefined";
    private String origination;
    private String affectedResource = "undefined";
    private AuditLevel level;

    public PciAuditEvent() {
        this(null);
    }

    public PciAuditEvent(Instant date) {
        if (date == null) {
            date = Instant.now();
        }
        LocalDateTime localDate = LocalDateTime.ofInstant(date, ZONE_UTC);
        this.date = DATE_FORMATTER.format(localDate);
        this.time = TIME_FORMATTER.format(localDate);
        this.level = AuditLevel.INFO;
    }

    public AuditLevel getLevel() {
        return this.level;
    }

    public void setLevel(AuditLevel level) {
        this.level = (AuditLevel)((Object)Args.notNull((Object)((Object)level), (String)"level"));
    }

    public String getUserId() {
        return PciAuditEvent.isBlank(this.userId) ? UNDEFINED : this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getEventType() {
        return PciAuditEvent.isBlank(this.eventType) ? UNDEFINED : this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getDate() {
        return this.date;
    }

    public String getTime() {
        return this.time;
    }

    public String getStatus() {
        return PciAuditEvent.isBlank(this.status) ? UNDEFINED : this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOrigination() {
        if (PciAuditEvent.isBlank(this.origination)) {
            this.origination = PciAuditEvent.getHostAddress();
        }
        return this.origination;
    }

    public void setOrigination(String origination) {
        this.origination = origination;
    }

    public String getAffectedResource() {
        return PciAuditEvent.isBlank(this.affectedResource) ? UNDEFINED : this.affectedResource;
    }

    public void setAffectedResource(String affectedResource) {
        this.affectedResource = affectedResource;
    }

    public String toTextMessage() {
        return this.toCharArrayWriter("").toString();
    }

    public CharArrayWriter toCharArrayWriter(String prefix) {
        CharArrayWriter buffer = new CharArrayWriter(100);
        int de = 32;
        if (prefix != null && !prefix.isEmpty()) {
            buffer.append(prefix);
        }
        buffer.append(PciAuditEvent.replaceDelimiter(this.getUserId())).append(' ');
        buffer.append(PciAuditEvent.replaceDelimiter(this.getEventType())).append(' ');
        buffer.append(PciAuditEvent.replaceDelimiter(this.getDate())).append(' ');
        buffer.append(PciAuditEvent.replaceDelimiter(this.getTime())).append(' ');
        buffer.append(PciAuditEvent.replaceDelimiter(this.getStatus())).append(' ');
        buffer.append(PciAuditEvent.replaceDelimiter(this.getOrigination())).append(' ');
        buffer.append(PciAuditEvent.replaceDelimiter(this.getAffectedResource()));
        return buffer;
    }

    private static boolean isBlank(CharSequence cs) {
        if (cs == null) {
            return true;
        }
        int strLen = cs.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String replaceDelimiter(String fieldValue) {
        if (fieldValue == null || fieldValue.isEmpty()) {
            return fieldValue;
        }
        return fieldValue.replace(' ', '_');
    }

    private static String getHostAddress() {
        Enumeration<NetworkInterface> interfaces;
        LinkedList<String> addresses = new LinkedList<String>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            return "UNKNOWN";
        }
        while (interfaces.hasMoreElements()) {
            Iterator ni = interfaces.nextElement();
            Enumeration<InetAddress> ee = ((NetworkInterface)((Object)ni)).getInetAddresses();
            while (ee.hasMoreElements()) {
                InetAddress ia = ee.nextElement();
                if (!(ia instanceof Inet4Address)) continue;
                addresses.add(ia.getHostAddress());
            }
        }
        for (String addr : addresses) {
            if (addr.startsWith("192.") || addr.startsWith("127.")) continue;
            return addr;
        }
        for (String addr : addresses) {
            if (addr.startsWith("127.")) continue;
            return addr;
        }
        if (addresses.size() > 0) {
            return (String)addresses.get(0);
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            return "UNKNOWN";
        }
    }
}

