/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.jena.entities.impl.handlers;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import org.xenei.jena.entities.impl.ObjectHandler;

public class LiteralHandler
implements ObjectHandler {
    private RDFDatatype literalDatatype;

    public LiteralHandler(RDFDatatype literalDatatype) {
        this.literalDatatype = literalDatatype;
    }

    public Literal createRDFNode(Object obj) {
        String lexicalForm = this.literalDatatype.unparse(obj);
        return ResourceFactory.createTypedLiteral((String)lexicalForm, (RDFDatatype)this.literalDatatype);
    }

    public Object parseObject(RDFNode node) {
        return this.literalDatatype.parse(node.asLiteral().getLexicalForm());
    }

    public String toString() {
        return "LiteralHandler{" + this.literalDatatype + "}";
    }

    public boolean equals(Object o) {
        if (o instanceof LiteralHandler) {
            return this.literalDatatype.equals(((LiteralHandler)o).literalDatatype);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

