/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.jena.entities.impl;

import com.hp.hpl.jena.rdf.model.Property;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.xenei.jena.entities.PredicateInfo;
import org.xenei.jena.entities.SubjectInfo;
import org.xenei.jena.entities.impl.ObjectHandler;
import org.xenei.jena.entities.impl.PredicateInfoImpl;
import org.xenei.jena.entities.impl.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectInfoImpl
implements SubjectInfo {
    private Class<?> implementedClass;
    private Map<String, Map<ObjectHandler, PredicateInfo>> predicateInfo = new HashMap<String, Map<ObjectHandler, PredicateInfo>>();

    public SubjectInfoImpl(Class<?> implementedClass) {
        this.implementedClass = implementedClass;
    }

    @Override
    public Class<?> getImplementedClass() {
        return this.implementedClass;
    }

    public void add(PredicateInfoImpl pi) {
        Map<ObjectHandler, PredicateInfo> map = this.predicateInfo.get(pi.getMethodName());
        if (map == null) {
            map = new HashMap<ObjectHandler, PredicateInfo>();
            this.predicateInfo.put(pi.getMethodName(), map);
        }
        map.put(pi.getObjectHandler(), pi);
    }

    @Override
    public PredicateInfo getPredicateInfo(String function, Class<?> clazz) {
        Map<ObjectHandler, PredicateInfo> map = this.predicateInfo.get(function);
        if (map != null) {
            for (PredicateInfo pi : map.values()) {
                Class<?> valueClass = pi.getValueClass();
                switch (pi.getActionType()) {
                    case SETTER: {
                        if (!TypeChecker.canBeSetFrom(valueClass, clazz)) break;
                        return pi;
                    }
                    case GETTER: {
                        if (!TypeChecker.canBeSetFrom(clazz, valueClass)) break;
                        return pi;
                    }
                    case REMOVER: 
                    case EXISTENTIAL: {
                        if (!(valueClass != null ? TypeChecker.canBeSetFrom(valueClass, clazz) : clazz == null || clazz.equals(Void.TYPE))) break;
                        return pi;
                    }
                }
            }
        }
        return null;
    }

    public void removePredicateInfo(String function, Class<?> clazz) {
        Map<ObjectHandler, PredicateInfo> map = this.predicateInfo.get(function);
        if (map != null) {
            map.remove(clazz);
            if (map.isEmpty()) {
                this.predicateInfo.remove(function);
            }
        }
    }

    @Override
    public PredicateInfo getPredicateInfo(Method m) {
        if (m.isVarArgs() || m.getParameterTypes().length > 1) {
            return null;
        }
        if (m.getParameterTypes().length == 0) {
            return this.getPredicateInfo(m.getName(), m.getReturnType());
        }
        return this.getPredicateInfo(m.getName(), m.getParameterTypes()[0]);
    }

    public void removePredicateInfo(Method m) {
        if (m.isVarArgs() || m.getParameterTypes().length > 1) {
            return;
        }
        if (m.getParameterTypes().length == 0) {
            this.removePredicateInfo(m.getName(), m.getReturnType());
        } else {
            this.removePredicateInfo(m.getName(), m.getParameterTypes()[0]);
        }
    }

    private PredicateInfo getPredicateInfo(String function) {
        Map<ObjectHandler, PredicateInfo> map = this.predicateInfo.get(function);
        if (map == null) {
            throw new IllegalArgumentException(String.format("Function %s not found", function));
        }
        if (map.values().isEmpty()) {
            throw new IllegalArgumentException(String.format("Function %s not found", function));
        }
        return map.values().iterator().next();
    }

    @Override
    public String getPredicateUriStr(String function) {
        return this.getPredicateInfo(function).getUriString();
    }

    @Override
    public String getPredicateUriStr(Method m) {
        return this.getPredicateInfo(m).getUriString();
    }

    @Override
    public Property getPredicateProperty(Method m) {
        return this.getPredicateInfo(m).getProperty();
    }

    @Override
    public Property getPredicateProperty(String methodName) {
        return this.getPredicateInfo(methodName).getProperty();
    }
}

