/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.jena.entities.impl;

import com.hp.hpl.jena.rdf.model.Resource;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.proxy.Invoker;
import org.apache.commons.proxy.exception.InvokerException;
import org.xenei.jena.entities.EntityManager;
import org.xenei.jena.entities.PredicateInfo;
import org.xenei.jena.entities.ResourceWrapper;
import org.xenei.jena.entities.SubjectInfo;
import org.xenei.jena.entities.impl.PredicateInfoImpl;
import org.xenei.jena.entities.impl.TypeChecker;

public class ResourceEntityProxy
implements Invoker {
    private Resource resource;
    private SubjectInfo subjectInfo;
    private EntityManager entityManager;
    private static Method GET_RESOURCE;

    public ResourceEntityProxy(EntityManager entityManager, Resource resource, SubjectInfo subjectInfo) {
        this.resource = resource;
        this.entityManager = entityManager;
        this.subjectInfo = subjectInfo;
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        PredicateInfo pi;
        if (!Modifier.isAbstract(m.getModifiers())) {
            if (m.getName().equals("toString") && !m.isVarArgs() && m.getParameterTypes().length == 0) {
                return String.format("%s[%s]", this.subjectInfo.getClass(), this.resource);
            }
            if (m.getName().equals("hashCode")) {
                return this.resource.hashCode();
            }
            if (m.getName().equals("equals")) {
                if (args[0] instanceof ResourceWrapper) {
                    return this.resource.equals(((ResourceWrapper)args[0]).getResource());
                }
                if (args[0] instanceof Resource) {
                    return this.resource.equals(args[0]);
                }
                return false;
            }
            return m.invoke(proxy, args);
        }
        if (GET_RESOURCE.equals(m)) {
            return this.resource;
        }
        SubjectInfo workingInfo = this.subjectInfo;
        if (m.getDeclaringClass() != this.subjectInfo.getImplementedClass()) {
            workingInfo = this.entityManager.getSubjectInfo(m.getDeclaringClass());
        }
        if ((pi = workingInfo.getPredicateInfo(m)) == null) {
            if (TypeChecker.canBeSetFrom(workingInfo.getImplementedClass(), this.subjectInfo.getImplementedClass()) && TypeChecker.canBeSetFrom(workingInfo.getImplementedClass(), Resource.class)) {
                Class[] argTypes = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    argTypes[i] = args[i].getClass();
                }
                try {
                    Method resourceMethod = Resource.class.getMethod(m.getName(), argTypes);
                    return resourceMethod.invoke((Object)this.resource, args);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw new InvokerException(String.format("Null method (%s) called", m.getName()));
        }
        if (pi instanceof PredicateInfoImpl) {
            return ((PredicateInfoImpl)pi).exec(m, this.resource, args);
        }
        throw new RuntimeException(String.format("Internal predicateinfo class (%s) not (%s)", pi.getClass(), PredicateInfoImpl.class));
    }

    static {
        try {
            GET_RESOURCE = ResourceWrapper.class.getDeclaredMethod("getResource", new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

