/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.jena.entities.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xenei.jena.entities.EntityManager;
import org.xenei.jena.entities.MissingAnnotation;
import org.xenei.jena.entities.PredicateInfo;
import org.xenei.jena.entities.annotations.Subject;
import org.xenei.jena.entities.annotations.URI;
import org.xenei.jena.entities.impl.ActionType;
import org.xenei.jena.entities.impl.EffectivePredicate;
import org.xenei.jena.entities.impl.ObjectHandler;
import org.xenei.jena.entities.impl.datatype.CharDatatype;
import org.xenei.jena.entities.impl.datatype.CharacterDatatype;
import org.xenei.jena.entities.impl.datatype.LongDatatype;
import org.xenei.jena.entities.impl.handlers.EntityHandler;
import org.xenei.jena.entities.impl.handlers.LiteralHandler;
import org.xenei.jena.entities.impl.handlers.ResourceHandler;
import org.xenei.jena.entities.impl.handlers.UriHandler;
import org.xenei.jena.entities.impl.handlers.VoidHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateInfoImpl
implements PredicateInfo {
    private ObjectHandler objectHandler;
    private Class<?> concreteType;
    private Class<?> valueClass;
    private String methodName;
    private Property property;
    private ActionType actionType;
    private EffectivePredicate predicate;

    public static List<String> dataTypeDump(String format, String nullClassString) {
        ArrayList<String> retval = new ArrayList<String>();
        String fmt = StringUtils.defaultIfEmpty((String)format, (String)"%s | %s");
        TypeMapper mapper = TypeMapper.getInstance();
        Iterator iter = mapper.listTypes();
        while (iter.hasNext()) {
            RDFDatatype dt = (RDFDatatype)iter.next();
            if (dt.getJavaClass() == null && nullClassString == null) continue;
            retval.add(String.format(fmt, dt.getURI(), PredicateInfoImpl.dataTypeDump_ClassType(dt.getJavaClass(), nullClassString)));
        }
        Collections.sort(retval);
        return retval;
    }

    private static String dataTypeDump_ClassType(Class<?> clazz, String nullClassString) {
        if (clazz == null) {
            return nullClassString;
        }
        if (clazz.isArray()) {
            return PredicateInfoImpl.dataTypeDump_ClassType(clazz.getComponentType(), nullClassString) + "[]";
        }
        return clazz.getName();
    }

    public PredicateInfoImpl(EntityManager entityManager, EffectivePredicate predicate, String methodName, Class<?> valueClass) throws MissingAnnotation {
        this.methodName = methodName;
        this.actionType = ActionType.parse(methodName);
        this.valueClass = valueClass;
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate may not be null");
        }
        this.predicate = predicate;
        this.concreteType = URI.class.equals(predicate.type()) ? URI.class : (valueClass != null && Iterator.class.isAssignableFrom(valueClass) ? predicate.type() : valueClass);
        if (this.concreteType != null && valueClass != null) {
            if (this.concreteType.isPrimitive() && !valueClass.isPrimitive()) {
                this.concreteType = valueClass;
            } else if (!this.concreteType.isPrimitive() && valueClass.isPrimitive()) {
                this.concreteType = valueClass;
            }
        }
        this.objectHandler = PredicateInfoImpl.getHandler(entityManager, this.concreteType, predicate);
    }

    public Object exec(Method method, Resource resource, Object[] args) {
        Property p = this.createResourceProperty(resource);
        Object retval = null;
        switch (this.actionType) {
            case GETTER: {
                retval = this.execRead(resource, p);
                break;
            }
            case SETTER: {
                if (method.getName().startsWith("set")) {
                    retval = this.execSet(resource, p, args);
                    break;
                }
                retval = this.execAdd(resource, p, args);
                break;
            }
            case REMOVER: {
                retval = this.execRemove(resource, p, args);
                break;
            }
            case EXISTENTIAL: {
                retval = this.execHas(resource, p, args);
            }
        }
        return retval;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public ActionType getActionType() {
        return this.actionType;
    }

    @Override
    public String getNamespace() {
        return this.predicate.namespace();
    }

    @Override
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public String toString() {
        return String.format("%s(%s)", this.methodName, this.valueClass);
    }

    @Override
    public String getUriString() {
        return this.predicate.namespace() + this.predicate.name();
    }

    @Override
    public Property getProperty() {
        if (this.property == null) {
            this.property = ResourceFactory.createProperty((String)this.getUriString());
        }
        return this.property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execHas(Resource resource, Property p, Object[] args) {
        try {
            resource.getModel().enterCriticalSection(true);
            Boolean bl = resource.hasProperty(p, this.objectHandler.createRDFNode(args[0]));
            return bl;
        }
        finally {
            resource.getModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execRemove(Resource resource, Property p, Object[] args) {
        try {
            resource.getModel().enterCriticalSection(false);
            if (this.valueClass == null) {
                resource.removeAll(p);
            } else {
                resource.getModel().remove(resource, p, this.objectHandler.createRDFNode(args[0]));
            }
            Object var4_4 = null;
            return var4_4;
        }
        finally {
            resource.getModel().leaveCriticalSection();
        }
    }

    private Object execAdd(Resource resource, Property p, Object[] args) {
        resource.addProperty(p, this.objectHandler.createRDFNode(args[0]));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execSet(Resource resource, Property p, Object[] args) {
        Object object;
        try {
            resource.getModel().enterCriticalSection(false);
            resource.removeAll(p);
            object = this.execAdd(resource, p, args);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            List l = resource.listProperties(p).toList();
            if (l.size() > 1) {
                Logger log = LoggerFactory.getLogger(PredicateInfoImpl.class);
                try {
                    throw new Exception(String.format("Error processing %s.set%s", resource, p));
                }
                catch (Exception e) {
                    log.error("Error:", (Throwable)e);
                    for (Statement s : l) {
                        log.error("Statement: {} ", (Object)s.asTriple());
                    }
                }
            }
            resource.getModel().leaveCriticalSection();
            throw throwable;
        }
        List l = resource.listProperties(p).toList();
        if (l.size() > 1) {
            Logger log = LoggerFactory.getLogger(PredicateInfoImpl.class);
            try {
                throw new Exception(String.format("Error processing %s.set%s", resource, p));
            }
            catch (Exception e) {
                log.error("Error:", (Throwable)e);
                for (Statement s : l) {
                    log.error("Statement: {} ", (Object)s.asTriple());
                }
            }
        }
        resource.getModel().leaveCriticalSection();
        return object;
    }

    private Object execRead(Resource resource, Property p) {
        if (Iterator.class.isAssignableFrom(this.valueClass)) {
            return this.execReadMultiple(resource, p);
        }
        return this.execReadSingle(resource, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execReadSingle(Resource resource, Property p) {
        Object retval;
        StmtIterator iter;
        block4: {
            Object object;
            try {
                resource.getModel().enterCriticalSection(true);
                iter = resource.listProperties(p);
                retval = null;
                if (!iter.hasNext()) break block4;
                Statement s = (Statement)iter.next();
                object = this.objectHandler.parseObject(s.getObject());
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                resource.getModel().leaveCriticalSection();
                throw throwable;
            }
            resource.getModel().leaveCriticalSection();
            return object;
        }
        iter.close();
        if (retval == null && this.concreteType.isPrimitive()) {
            throw new NullPointerException(String.format("Null valueClass (%s) was assigned to a variable of primitive type: %s", this.methodName, this.concreteType));
        }
        Object var5_6 = retval;
        Object var8_9 = null;
        resource.getModel().leaveCriticalSection();
        return var5_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedIterator<?> execReadMultiple(Resource resource, Property p) {
        ExtendedIterator extendedIterator;
        try {
            resource.getModel().enterCriticalSection(true);
            NodeIterator iter = resource.getModel().listObjectsOfProperty(resource, p);
            extendedIterator = iter.mapWith((Map1)new Map1<RDFNode, Object>(){

                public Object map1(RDFNode rdfNode) {
                    return PredicateInfoImpl.this.objectHandler.parseObject(rdfNode);
                }
            });
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            resource.getModel().leaveCriticalSection();
            throw throwable;
        }
        resource.getModel().leaveCriticalSection();
        return extendedIterator;
    }

    private Property createResourceProperty(Resource resource) {
        return resource.getModel() == null ? ResourceFactory.createProperty((String)this.getUriString()) : resource.getModel().createProperty(this.getUriString());
    }

    public ObjectHandler getObjectHandler() {
        return this.objectHandler;
    }

    public static ObjectHandler getHandler(EntityManager entityManager, Class<?> returnType, EffectivePredicate pred) {
        TypeMapper typeMapper = TypeMapper.getInstance();
        RDFDatatype dt = null;
        dt = pred != null && !pred.literalType().equals("") ? typeMapper.getSafeTypeByName(pred.literalType()) : typeMapper.getTypeByClass(returnType);
        if (dt != null) {
            return new LiteralHandler(dt);
        }
        if (returnType != null) {
            if (returnType.getAnnotation(Subject.class) != null) {
                return new EntityHandler(entityManager, returnType);
            }
            if (RDFNode.class.isAssignableFrom(returnType)) {
                return new ResourceHandler();
            }
            if (returnType.equals(URI.class)) {
                return new UriHandler();
            }
        }
        return new VoidHandler();
    }

    static {
        Object rtype = new CharacterDatatype();
        TypeMapper.getInstance().registerDatatype((RDFDatatype)rtype);
        rtype = new CharDatatype();
        TypeMapper.getInstance().registerDatatype((RDFDatatype)rtype);
        rtype = new LongDatatype();
        TypeMapper.getInstance().registerDatatype((RDFDatatype)rtype);
    }
}

