/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.jena.entities.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.proxy.Invoker;
import org.apache.commons.proxy.ProxyFactory;
import org.apache.commons.proxy.exception.InvokerException;
import org.apache.commons.proxy.factory.cglib.CglibProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xenei.jena.entities.EntityManager;
import org.xenei.jena.entities.MissingAnnotation;
import org.xenei.jena.entities.ResourceWrapper;
import org.xenei.jena.entities.SubjectInfo;
import org.xenei.jena.entities.annotations.Predicate;
import org.xenei.jena.entities.annotations.Subject;
import org.xenei.jena.entities.annotations.URI;
import org.xenei.jena.entities.impl.ActionType;
import org.xenei.jena.entities.impl.EffectivePredicate;
import org.xenei.jena.entities.impl.PredicateInfoImpl;
import org.xenei.jena.entities.impl.ResourceEntityProxy;
import org.xenei.jena.entities.impl.SubjectInfoImpl;
import org.xenei.jena.entities.impl.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerImpl
implements EntityManager {
    private static Logger LOG = LoggerFactory.getLogger(EntityManagerImpl.class);
    private Map<Class<?>, SubjectInfoImpl> classInfo = new HashMap();
    private ProxyFactory proxyFactory = new CglibProxyFactory();

    public EntityManagerImpl() {
        try {
            this.parse(ResourceWrapper.class);
        }
        catch (MissingAnnotation e) {
            throw new RuntimeException(e);
        }
    }

    private Resource getResource(Object target) {
        if (target instanceof ResourceWrapper) {
            return ((ResourceWrapper)target).getResource();
        }
        if (target instanceof Resource) {
            return (Resource)target;
        }
        throw new IllegalArgumentException(String.format("%s implements neither Resource nor ResourceWrapper", target.getClass()));
    }

    @Override
    public SubjectInfo getSubjectInfo(Class<?> clazz) {
        try {
            return this.parse(clazz);
        }
        catch (MissingAnnotation e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public <T> T read(Object source, Class<T> primaryClass, Class<?> ... secondaryClasses) {
        SubjectInfoImpl subjectInfo;
        ArrayList classes = new ArrayList();
        try {
            subjectInfo = this.parse(primaryClass);
        }
        catch (MissingAnnotation e) {
            throw new RuntimeException(e);
        }
        classes.add(primaryClass);
        for (Class<?> cla : secondaryClasses) {
            if (classes.contains(cla)) continue;
            try {
                this.parse(cla);
                classes.add(cla);
            }
            catch (MissingAnnotation e) {
                throw new RuntimeException(e);
            }
        }
        if (!classes.contains(ResourceWrapper.class)) {
            classes.add(ResourceWrapper.class);
        }
        ResourceEntityProxy invoker = new ResourceEntityProxy(this, this.getResource(source), subjectInfo);
        Class[] classArray = new Class[classes.size()];
        return (T)this.proxyFactory.createInvokerProxy((Invoker)invoker, classes.toArray(classArray));
    }

    @Override
    public boolean isInstance(Object target, Class<?> clazz) {
        Subject subject = clazz.getAnnotation(Subject.class);
        if (subject == null) {
            throw new IllegalArgumentException(String.format("%s is not annotated as a Subject", clazz.getName()));
        }
        Resource r = null;
        try {
            r = this.getResource(target);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        for (String type : subject.types()) {
            Resource object = ResourceFactory.createResource((String)type);
            if (r.hasProperty(RDF.type, (RDFNode)object)) continue;
            return false;
        }
        return true;
    }

    public Resource addInstanceProperties(Resource r, Class<?> clazz) {
        Subject e = clazz.getAnnotation(Subject.class);
        Model model = r.getModel();
        if (e != null) {
            for (String type : e.types()) {
                Resource object;
                Resource resource = object = model != null ? model.createResource(type) : ResourceFactory.createResource((String)type);
                if (r.hasProperty(RDF.type, (RDFNode)object)) continue;
                r.addProperty(RDF.type, (RDFNode)object);
            }
        }
        return r;
    }

    private String getNamespace(Class<?> clazz) {
        Subject e = clazz.getAnnotation(Subject.class);
        return e != null ? e.namespace() : "";
    }

    private boolean isAdd(Method m) {
        try {
            if (ActionType.parse(m.getName()) == ActionType.SETTER) {
                Class<?>[] parms = m.getParameterTypes();
                return parms != null && parms.length == 1;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private Map<String, Integer> countAdders(Method[] methods) {
        HashMap<String, Integer> addCount = new HashMap<String, Integer>();
        for (Method m : methods) {
            if (!this.isAdd(m)) continue;
            Integer i = (Integer)addCount.get(m.getName());
            i = i == null ? Integer.valueOf(1) : Integer.valueOf(i + 1);
            addCount.put(m.getName(), i);
        }
        return addCount;
    }

    private Annotation[] getAnnotationsIfProcessable(SubjectInfo subjectInfo, Method m) {
        Annotation[] annotations = m.getAnnotations();
        boolean process = false;
        for (Annotation a : annotations) {
            if (!(a instanceof Predicate)) continue;
            process = subjectInfo.getPredicateInfo(m) == null;
        }
        return process ? annotations : null;
    }

    private SubjectInfoImpl parse(Class<?> clazz) throws MissingAnnotation {
        SubjectInfoImpl subjectInfo = this.classInfo.get(clazz);
        if (subjectInfo == null) {
            LOG.info("Parsing {}", clazz);
            subjectInfo = new SubjectInfoImpl(clazz);
            Map<String, Integer> addCount = this.countAdders(clazz.getMethods());
            for (Method m : clazz.getMethods()) {
                if (!Modifier.isAbstract(m.getModifiers()) || m.isVarArgs()) continue;
                try {
                    ActionType actionType = ActionType.parse(m.getName());
                    switch (actionType) {
                        case SETTER: {
                            Integer i = addCount.get(m.getName());
                            if (i == null) break;
                            this.parseSetter(subjectInfo, m, i > 1);
                            break;
                        }
                        case EXISTENTIAL: {
                            Annotation[] annotations = this.getAnnotationsIfProcessable(subjectInfo, m);
                            if (annotations == null) break;
                            this.parseExistential(subjectInfo, m);
                            break;
                        }
                        case GETTER: {
                            Annotation[] annotations = this.getAnnotationsIfProcessable(subjectInfo, m);
                            if (annotations == null || m.getParameterTypes().length != 0) break;
                            this.addGetterMethods(m.getName(), subjectInfo, m.getAnnotation(Predicate.class).type(), null, false);
                            break;
                        }
                        case REMOVER: {
                            Annotation[] annotations = this.getAnnotationsIfProcessable(subjectInfo, m);
                            if (annotations == null) break;
                            this.parseRemover(subjectInfo, m);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            this.classInfo.put(clazz, subjectInfo);
            this.verifyNoNullMethods(clazz, subjectInfo);
        }
        return subjectInfo;
    }

    private void verifyNoNullMethods(Class<?> clazz, SubjectInfo subjectInfo) {
        for (Method m : clazz.getMethods()) {
            if (!Modifier.isAbstract(m.getModifiers())) continue;
            SubjectInfo workingInfo = subjectInfo;
            if (m.getDeclaringClass() != subjectInfo.getImplementedClass()) {
                workingInfo = this.getSubjectInfo(m.getDeclaringClass());
            }
            if (!TypeChecker.canBeSetFrom(workingInfo.getImplementedClass(), subjectInfo.getImplementedClass()) || TypeChecker.canBeSetFrom(workingInfo.getImplementedClass(), Resource.class) || workingInfo.getPredicateInfo(m) != null) continue;
            throw new InvokerException(String.format("%s.%s (declared as %s.%2$s) is not implemented and does not have @Predicate annotation", clazz.getName(), m.getName(), m.getDeclaringClass()));
        }
    }

    private EffectivePredicate getEffectivePredicate(Method m) throws MissingAnnotation {
        return this.getEffectivePredicate(m, null, null, null);
    }

    private EffectivePredicate getEffectivePredicate(Method m, Annotation[] paramAnnotations, Class<?> returnType) throws MissingAnnotation {
        return this.getEffectivePredicate(m, paramAnnotations, returnType, null);
    }

    private EffectivePredicate getEffectivePredicate(Method m, Annotation[] paramAnnotations, Class<?> returnType, EffectivePredicate dflt) throws MissingAnnotation {
        Node n;
        String localNamespace;
        boolean typeSet = false;
        EffectivePredicate retval = new EffectivePredicate().merge(m.getAnnotation(Predicate.class)).merge(dflt);
        if (paramAnnotations != null) {
            for (Annotation a : paramAnnotations) {
                if (!(a instanceof URI)) continue;
                retval.type = URI.class;
                typeSet = true;
            }
        }
        if (!typeSet && returnType != null) {
            retval.type = returnType;
        }
        if (retval.namespace().length() == 0) {
            retval.namespace = this.getNamespace(m.getDeclaringClass());
        }
        if (retval.name().length() == 0) {
            ActionType actionType = ActionType.parse(m.getName());
            retval.name = actionType.extractName(m.getName());
        }
        if (Util.notNameChar((char)(localNamespace = (n = Node.createURI((String)retval.name)).getNameSpace()).charAt(localNamespace.length() - 1))) {
            retval.namespace = localNamespace;
            retval.name = n.getLocalName();
        }
        if (retval.namespace().length() == 0) {
            throw new MissingAnnotation(String.format("Namespace is not defined in property, entity or uriString for %s", m.getName()));
        }
        if (!Util.notNameChar((char)retval.namespace().charAt(retval.namespace().length() - 1))) {
            throw new MissingAnnotation(String.format("Namespace (%s) ends with invalid character", retval.namespace()));
        }
        String s = retval.name.substring(0, 1);
        retval.name = retval.upcase() ? retval.name.replaceFirst(s, s.toUpperCase()) : retval.name.replaceFirst(s, s.toLowerCase());
        int split = Util.splitNamespace((String)(retval.namespace() + retval.name()));
        if (split != retval.namespace().length()) {
            throw new MissingAnnotation(String.format("uriString (%s) has invalid characters in the localname part (%s)", retval.namespace() + retval.name(), retval.namespace() + retval.name().substring(split)));
        }
        return retval;
    }

    private void parseSetter(SubjectInfoImpl subjectInfo, Method m, boolean multiAdd) throws MissingAnnotation {
        Class<?>[] parms = m.getParameterTypes();
        if (parms.length == 1) {
            Class<?> valueType = parms[0];
            String subName = ActionType.SETTER.extractName(m.getName());
            EffectivePredicate predicate = this.getEffectivePredicate(m, m.getParameterAnnotations()[0], parms[0]);
            PredicateInfoImpl pi = new PredicateInfoImpl(this, predicate, m.getName(), valueType);
            subjectInfo.add(pi);
            Method isMethod = null;
            if (m.getName().startsWith("set")) {
                this.addGetterMethods("get" + subName, subjectInfo, valueType, predicate, false);
                isMethod = this.addGetterMethods("is" + subName, subjectInfo, valueType, predicate, false);
                this.addRemoverMethod(null, "remove" + subName, subjectInfo, predicate);
            } else {
                this.addGetterMethods("get" + subName, subjectInfo, valueType, predicate, multiAdd);
                isMethod = this.addHasMethods("has" + subName, subjectInfo, valueType, predicate);
                this.addRemoverMethod(parms[0], "remove" + subName, subjectInfo, predicate);
            }
            if (isMethod != null && !Boolean.class.equals(isMethod.getReturnType())) {
                subjectInfo.removePredicateInfo(isMethod);
            }
        }
    }

    private void parseExistential(SubjectInfoImpl subjectInfo, Method m) throws MissingAnnotation {
        Method m2 = null;
        if (m.getName().startsWith("has")) {
            if (m.getParameterTypes().length == 1) {
                m2 = this.addHasMethods(m.getName(), subjectInfo, m.getParameterTypes()[0], this.getEffectivePredicate(m));
            }
        } else if (m.getName().startsWith("is") && m.getParameterTypes().length == 0) {
            m2 = this.addGetterMethods(m.getName(), subjectInfo, Boolean.class, this.getEffectivePredicate(m), false);
        }
        if (m2 != null && !Boolean.class.equals(m2.getReturnType())) {
            subjectInfo.removePredicateInfo(m2);
        }
    }

    private void parseRemover(SubjectInfoImpl subjectInfo, Method m) throws MissingAnnotation {
        if (m.getParameterTypes().length == 1) {
            this.addRemoverMethod(m.getParameterTypes()[0], m.getName(), subjectInfo, this.getEffectivePredicate(m, m.getParameterAnnotations()[0], m.getParameterTypes()[0]));
        } else {
            this.addRemoverMethod(null, m.getName(), subjectInfo, this.getEffectivePredicate(m));
        }
    }

    private Annotation[] getParameterAnnotation(Method m) {
        return m.getParameterAnnotations().length > 0 ? m.getParameterAnnotations()[0] : null;
    }

    private Method addGetterMethods(String methodName, SubjectInfoImpl subjectInfo, Class<?> setterValueType, EffectivePredicate parentPredicate, boolean multiAdd) throws MissingAnnotation {
        Method m = null;
        try {
            m = subjectInfo.getImplementedClass().getMethod(methodName, null);
            if (Modifier.isAbstract(m.getModifiers()) && !m.isVarArgs()) {
                boolean okToProcess;
                EffectivePredicate predicate = this.getEffectivePredicate(m, null, null, parentPredicate);
                if (m.getReturnType().equals(ExtendedIterator.class)) {
                    Predicate declaredPredicate = m.getAnnotation(Predicate.class);
                    if (declaredPredicate == null) {
                        if (multiAdd) {
                            throw new MissingAnnotation(String.format("%s.%s must have a Predicate annotation to define type", subjectInfo.getImplementedClass(), methodName));
                        }
                        if (predicate.type.equals(URI.class)) {
                            predicate.type = RDFNode.class;
                        }
                    } else {
                        predicate.type = declaredPredicate.type();
                    }
                }
                if (!(okToProcess = TypeChecker.canBeSetFrom(predicate.type(), setterValueType))) {
                    boolean bl = okToProcess = predicate.type().equals(URI.class) && setterValueType.equals(RDFNode.class);
                }
                if (!okToProcess) {
                    boolean bl = okToProcess = predicate.type().equals(URI.class) && setterValueType.equals(String.class);
                    if (okToProcess && m.getReturnType().equals(RDFNode.class)) {
                        predicate.type = RDFNode.class;
                    }
                }
                if (okToProcess) {
                    subjectInfo.add(new PredicateInfoImpl(this, predicate, methodName, m.getReturnType()));
                } else {
                    m = null;
                }
            } else {
                m = null;
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return m;
    }

    private Method addHasMethods(String methodName, SubjectInfoImpl subjectInfo, Class<?> valueType, EffectivePredicate parentPredicate) {
        Method m = null;
        try {
            m = subjectInfo.getImplementedClass().getMethod(methodName, valueType);
            if (Modifier.isAbstract(m.getModifiers()) && !m.isVarArgs()) {
                subjectInfo.add(new PredicateInfoImpl(this, this.getEffectivePredicate(m, this.getParameterAnnotation(m), valueType, parentPredicate), methodName, valueType));
            } else {
                m = null;
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (MissingAnnotation e) {
            LOG.error(e.toString());
        }
        return m;
    }

    private Method addRemoverMethod(Class<?> argType, String name, SubjectInfoImpl subjectInfo, EffectivePredicate parentPredicate) throws MissingAnnotation {
        Method m = null;
        try {
            m = argType == null ? subjectInfo.getImplementedClass().getMethod(name, new Class[0]) : subjectInfo.getImplementedClass().getMethod(name, argType);
            if (Modifier.isAbstract(m.getModifiers()) && !m.isVarArgs()) {
                EffectivePredicate predicate = this.getEffectivePredicate(m, this.getParameterAnnotation(m), argType, parentPredicate);
                if (argType == null) {
                    predicate.type = null;
                }
                subjectInfo.add(new PredicateInfoImpl(this, predicate, m.getName(), argType));
            } else {
                m = null;
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return m;
    }

    @Override
    public void parseClasses(String packageName) throws MissingAnnotation {
        this.parseClasses(new String[]{packageName});
    }

    @Override
    public void parseClasses(String[] packageNames) throws MissingAnnotation {
        boolean hasErrors = false;
        for (String pkg : packageNames) {
            for (Class<?> c : this.getClasses(pkg)) {
                if (c.getAnnotation(Subject.class) == null) continue;
                try {
                    this.parse(c);
                }
                catch (MissingAnnotation e) {
                    LOG.warn("Error processing {}: {}", c, (Object)e.getMessage());
                    hasErrors = true;
                }
            }
        }
        if (hasErrors) {
            throw new MissingAnnotation(String.format("Unable to parse all %s See log for more details", new Object[]{packageNames}));
        }
    }

    private Collection<Class<?>> getClasses(String packageName) {
        Enumeration<URL> resources;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        try {
            resources = classLoader.getResources(path);
        }
        catch (IOException e1) {
            LOG.error(e1.toString());
            return Collections.emptyList();
        }
        HashSet classes = new HashSet();
        if (resources.hasMoreElements()) {
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try {
                    for (String clazz : this.findClasses(resource.getFile(), packageName)) {
                        try {
                            classes.add(Class.forName(clazz));
                        }
                        catch (ClassNotFoundException e) {
                            LOG.warn(e.toString());
                        }
                        catch (ExceptionInInitializerError e) {
                            System.out.println("WHAT?");
                        }
                    }
                }
                catch (IOException e) {
                    LOG.warn(e.toString());
                }
            }
        } else {
            try {
                classes.add(Class.forName(packageName));
            }
            catch (ClassNotFoundException e) {
                LOG.warn("{} was neither a package name nor a class name", (Object)packageName);
            }
        }
        return classes;
    }

    private Set<String> findClasses(String directory, String packageName) throws IOException {
        File[] files;
        File dir;
        HashSet<String> classes = new HashSet<String>();
        if (directory.startsWith("file:") && directory.contains("!")) {
            String[] split = directory.split("!");
            URL jar = new URL(split[0]);
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                if (!entry.getName().endsWith(".class")) continue;
                String className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.');
                classes.add(className);
            }
        }
        if (!(dir = new File(directory)).exists()) {
            return classes;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(this.findClasses(file.getAbsolutePath(), packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
        }
        return classes;
    }

    @Override
    public Object update(Object source, Object target) {
        Class<?> targetClass = target.getClass();
        Class<?> sourceClass = source.getClass();
        for (Method targetMethod : targetClass.getMethods()) {
            Class<?>[] targetMethodParams;
            if (!ActionType.SETTER.isA(targetMethod.getName()) || (targetMethodParams = targetMethod.getParameterTypes()).length != 1) continue;
            String partialName = ActionType.SETTER.extractName(targetMethod.getName());
            Method configMethod = null;
            String configMethodName = "get" + partialName;
            try {
                configMethod = sourceClass.getMethod(configMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    configMethodName = "is" + partialName;
                    configMethod = sourceClass.getMethod(configMethodName, new Class[0]);
                }
                catch (NoSuchMethodException expected) {
                    // empty catch block
                }
            }
            try {
                boolean setNull;
                if (configMethod == null) continue;
                boolean bl = setNull = !targetMethodParams[0].isPrimitive();
                if (!TypeChecker.canBeSetFrom(targetMethodParams[0], configMethod.getReturnType())) continue;
                Object val = configMethod.invoke(source, new Object[0]);
                if (!setNull && val == null) continue;
                targetMethod.invoke(target, val);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return target;
    }
}

