/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.jena.entities.impl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ActionType {
    GETTER,
    SETTER,
    REMOVER,
    EXISTENTIAL;


    public static ActionType parse(String functionName) {
        if (functionName.startsWith("get") || functionName.startsWith("is")) {
            return GETTER;
        }
        if (functionName.startsWith("set") || functionName.startsWith("add")) {
            return SETTER;
        }
        if (functionName.startsWith("remove")) {
            return REMOVER;
        }
        if (functionName.startsWith("has")) {
            return EXISTENTIAL;
        }
        throw new IllegalArgumentException(String.format("%s is not an action type function", functionName));
    }

    public boolean isA(String functionName) {
        if (functionName == null) {
            return false;
        }
        switch (this) {
            case EXISTENTIAL: {
                return functionName.startsWith("has");
            }
            case GETTER: {
                return functionName.startsWith("get") || functionName.startsWith("is");
            }
            case REMOVER: {
                return functionName.startsWith("remove");
            }
            case SETTER: {
                return functionName.startsWith("set") || functionName.startsWith("add");
            }
        }
        return false;
    }

    public String extractName(String name) {
        switch (this) {
            case GETTER: {
                if (name.startsWith("get")) {
                    return name.substring(3);
                }
                return name.substring(2);
            }
            case EXISTENTIAL: 
            case SETTER: {
                return name.substring(3);
            }
            case REMOVER: {
                return name.substring(6);
            }
        }
        throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " does not seem to be a valid ActionType");
    }
}

