/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.groovy.sshd;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.fs.SftpFileSystem;
import org.apache.sshd.fs.SftpFileSystemProvider;

class SFTPContext {
    private final SshClient sshClient = (SshClient)ClientBuilder.builder().build();
    final SftpFileSystemProvider provider;
    final SftpFileSystem fileSystem;

    SFTPContext(URI uri, Map<String, ?> env) throws IOException {
        Object object = env.get("workers");
        if (object instanceof Integer) {
            this.sshClient.setNioWorkers(((Integer)object).intValue());
        } else if (object instanceof String) {
            this.sshClient.setNioWorkers(Integer.parseInt((String)object));
        } else {
            this.sshClient.setNioWorkers(1);
        }
        this.sshClient.start();
        this.provider = new SftpFileSystemProvider(this.sshClient);
        this.fileSystem = this.provider.newFileSystem(uri, env);
    }

    void close() throws IOException {
        this.sshClient.stop();
        this.fileSystem.close();
    }
}

