/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.groovy.sshd;

import groovy.lang.Closure;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.xbib.groovy.sshd.SFTPContext;
import org.xbib.groovy.sshd.WithContext;

public class SFTP {
    private static final int READ_BUFFER_SIZE = 131072;
    private static final int WRITE_BUFFER_SIZE = 131072;
    private static final Set<PosixFilePermission> DEFAULT_DIR_PERMISSIONS = PosixFilePermissions.fromString("rwxr-xr-x");
    private static final Set<PosixFilePermission> DEFAULT_FILE_PERMISSIONS = PosixFilePermissions.fromString("rw-r--r--");
    private final String url;
    private final Map<String, ?> env;

    private SFTP(String url, Map<String, ?> env) {
        this.url = url;
        this.env = env;
    }

    public static SFTP newInstance() {
        return SFTP.newInstance("sftp://localhost:22");
    }

    public static SFTP newInstance(Map<String, ?> env) {
        return SFTP.newInstance("sftp://localhost:22", env);
    }

    public static SFTP newInstance(String url) {
        return SFTP.newInstance(url, Collections.emptyMap());
    }

    public static SFTP newInstance(String url, Map<String, ?> env) {
        return new SFTP(url, env);
    }

    public Boolean exists(String path) throws Exception {
        return this.performWithContext(ctx -> Files.exists(ctx.fileSystem.getPath(path, new String[0]), new LinkOption[0]));
    }

    public Boolean isExecutable(String path) throws Exception {
        return this.performWithContext(ctx -> Files.isExecutable(ctx.fileSystem.getPath(path, new String[0])));
    }

    public Boolean isDirectory(String path) throws Exception {
        return this.performWithContext(ctx -> Files.isDirectory(ctx.fileSystem.getPath(path, new String[0]), new LinkOption[0]));
    }

    public Boolean isRegularFile(String path) throws Exception {
        return this.performWithContext(ctx -> Files.isRegularFile(ctx.fileSystem.getPath(path, new String[0]), new LinkOption[0]));
    }

    public Boolean isHidden(String path) throws Exception {
        return this.performWithContext(ctx -> Files.isHidden(ctx.fileSystem.getPath(path, new String[0])));
    }

    public Boolean isSameFile(String path1, String path2) throws Exception {
        return this.performWithContext(ctx -> Files.isSameFile(ctx.fileSystem.getPath(path1, new String[0]), ctx.fileSystem.getPath(path2, new String[0])));
    }

    public Boolean isSymbolicLink(String path) throws Exception {
        return this.performWithContext(ctx -> Files.isSymbolicLink(ctx.fileSystem.getPath(path, new String[0])));
    }

    public Boolean isReadable(String path) throws Exception {
        return this.performWithContext(ctx -> Files.isReadable(ctx.fileSystem.getPath(path, new String[0])));
    }

    public Boolean isWritable(String path) throws Exception {
        return this.performWithContext(ctx -> Files.isWritable(ctx.fileSystem.getPath(path, new String[0])));
    }

    public void createFile(String path, FileAttribute<?> ... attributes) throws Exception {
        this.performWithContext(ctx -> Files.createFile(ctx.fileSystem.getPath(path, new String[0]), attributes));
    }

    public void createDirectory(String path, FileAttribute<?> ... attributes) throws Exception {
        this.performWithContext(ctx -> Files.createDirectory(ctx.fileSystem.getPath(path, new String[0]), attributes));
    }

    public void createDirectories(String path, FileAttribute<?> ... attributes) throws Exception {
        this.performWithContext(ctx -> Files.createDirectories(ctx.fileSystem.getPath(path, new String[0]), attributes));
    }

    public void setAttribute(String path, String attribute, Object value) throws Exception {
        this.performWithContext(ctx -> Files.setAttribute(ctx.fileSystem.getPath(path, new String[0]), attribute, value, new LinkOption[0]));
    }

    public Object getAttribute(String path, String attribute) throws Exception {
        return this.performWithContext(ctx -> Files.getAttribute(ctx.fileSystem.getPath(path, new String[0]), attribute, new LinkOption[0]));
    }

    public void setPermissions(String path, Set<PosixFilePermission> permissions) throws Exception {
        this.performWithContext(ctx -> Files.setPosixFilePermissions(ctx.fileSystem.getPath(path, new String[0]), permissions));
    }

    public Set<PosixFilePermission> getPermissions(String path) throws Exception {
        return this.performWithContext(ctx -> Files.getPosixFilePermissions(ctx.fileSystem.getPath(path, new String[0]), new LinkOption[0]));
    }

    public void setLastModifiedTime(String path, FileTime fileTime) throws Exception {
        this.performWithContext(ctx -> Files.setLastModifiedTime(ctx.fileSystem.getPath(path, new String[0]), fileTime));
    }

    public FileTime getLastModified(String path) throws Exception {
        return this.performWithContext(ctx -> Files.getLastModifiedTime(ctx.fileSystem.getPath(path, new String[0]), new LinkOption[0]));
    }

    public void setOwner(String path, UserPrincipal userPrincipal) throws Exception {
        this.performWithContext(ctx -> Files.setOwner(ctx.fileSystem.getPath(path, new String[0]), userPrincipal));
    }

    public UserPrincipal getOwner(String path) throws Exception {
        return this.performWithContext(ctx -> Files.getOwner(ctx.fileSystem.getPath(path, new String[0]), new LinkOption[0]));
    }

    public void each(String path, Closure<?> closure) throws Exception {
        this.performWithContext(ctx -> {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(ctx.fileSystem.getPath(path, new String[0]));){
                stream.forEach(arg_0 -> ((Closure)closure).call(arg_0));
            }
            return null;
        });
    }

    public void eachFilter(String path, DirectoryStream.Filter<Path> filter, Closure<?> closure) throws Exception {
        this.performWithContext(ctx -> {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(ctx.fileSystem.getPath(path, new String[0]), filter);){
                stream.forEach(arg_0 -> ((Closure)closure).call(arg_0));
            }
            return null;
        });
    }

    public void upload(Path source, Path target, CopyOption ... copyOptions) throws Exception {
        this.upload(source, target, DEFAULT_DIR_PERMISSIONS, DEFAULT_FILE_PERMISSIONS, copyOptions);
    }

    public void upload(Path source, Path target, Set<PosixFilePermission> dirPermissions, Set<PosixFilePermission> filePermissions, CopyOption ... copyOptions) throws Exception {
        this.performWithContext(ctx -> {
            this.upload(ctx, Files.newByteChannel(source, new OpenOption[0]), target, 131072, dirPermissions, filePermissions, copyOptions);
            return null;
        });
    }

    public void upload(Path source, String target, CopyOption ... copyOptions) throws Exception {
        this.upload(source, target, DEFAULT_DIR_PERMISSIONS, DEFAULT_FILE_PERMISSIONS, copyOptions);
    }

    public void upload(Path source, String target, Set<PosixFilePermission> dirPermissions, Set<PosixFilePermission> filePermissions, CopyOption ... copyOptions) throws Exception {
        this.performWithContext(ctx -> {
            this.upload(ctx, Files.newByteChannel(source, new OpenOption[0]), ctx.fileSystem.getPath(target, new String[0]), 131072, dirPermissions, filePermissions, copyOptions);
            return null;
        });
    }

    public void upload(InputStream source, Path target, CopyOption ... copyOptions) throws Exception {
        this.upload(source, target, DEFAULT_DIR_PERMISSIONS, DEFAULT_FILE_PERMISSIONS, copyOptions);
    }

    public void upload(InputStream source, Path target, Set<PosixFilePermission> dirPermissions, Set<PosixFilePermission> filePermissions, CopyOption ... copyOptions) throws Exception {
        this.performWithContext(ctx -> {
            this.upload(ctx, Channels.newChannel(source), target, 131072, dirPermissions, filePermissions, copyOptions);
            return null;
        });
    }

    public void upload(InputStream source, String target, CopyOption ... copyOptions) throws Exception {
        this.upload(source, target, DEFAULT_DIR_PERMISSIONS, DEFAULT_FILE_PERMISSIONS, copyOptions);
    }

    public void upload(InputStream source, String target, Set<PosixFilePermission> dirPermissions, Set<PosixFilePermission> filePermissions, CopyOption ... copyOptions) throws Exception {
        this.performWithContext(ctx -> {
            this.upload(ctx, Channels.newChannel(source), ctx.fileSystem.getPath(target, new String[0]), 131072, dirPermissions, filePermissions, copyOptions);
            return null;
        });
    }

    public void download(Path source, Path target, CopyOption ... copyOptions) throws Exception {
        this.performWithContext(ctx -> {
            this.download(ctx, source, target, 131072, copyOptions);
            return null;
        });
    }

    public void download(String source, Path target, CopyOption ... copyOptions) throws Exception {
        this.performWithContext(ctx -> {
            this.download(ctx, ctx.fileSystem.getPath(source, new String[0]), target, 131072, copyOptions);
            return null;
        });
    }

    public void download(Path source, OutputStream target) throws Exception {
        this.performWithContext(ctx -> {
            this.download(ctx, source, target, 131072);
            return null;
        });
    }

    public void download(String source, OutputStream target) throws Exception {
        this.performWithContext(ctx -> {
            this.download(ctx, ctx.fileSystem.getPath(source, new String[0]), target, 131072);
            return null;
        });
    }

    public void copy(String source, String target, CopyOption ... copyOptions) throws Exception {
        this.performWithContext(ctx -> Files.copy(ctx.fileSystem.getPath(source, new String[0]), ctx.fileSystem.getPath(target, new String[0]), copyOptions));
    }

    public void rename(String source, String target, CopyOption ... copyOptions) throws Exception {
        this.performWithContext(ctx -> Files.move(ctx.fileSystem.getPath(source, new String[0]), ctx.fileSystem.getPath(target, new String[0]), copyOptions));
    }

    public void remove(String source) throws Exception {
        this.performWithContext(ctx -> Files.deleteIfExists(ctx.fileSystem.getPath(source, new String[0])));
    }

    private void upload(SFTPContext ctx, ReadableByteChannel source, Path target, int bufferSize, Set<PosixFilePermission> dirPerms, Set<PosixFilePermission> filePerms, CopyOption ... copyOptions) throws Exception {
        this.prepareForWrite(target, dirPerms, filePerms);
        this.transfer(source, ctx.provider.newByteChannel(target, this.prepareWriteOptions(copyOptions), new FileAttribute[0]), bufferSize);
    }

    private void download(SFTPContext ctx, Path source, OutputStream outputStream, int bufferSize) throws Exception {
        this.download(ctx, source, Channels.newChannel(outputStream), bufferSize);
    }

    private void download(SFTPContext ctx, Path source, WritableByteChannel writableByteChannel, int bufferSize) throws Exception {
        this.transfer(ctx.provider.newByteChannel(source, this.prepareReadOptions(new CopyOption[0]), new FileAttribute[0]), writableByteChannel, bufferSize);
    }

    private void download(SFTPContext ctx, Path source, Path target, int bufferSize, CopyOption ... copyOptions) throws Exception {
        this.prepareForRead(target);
        this.transfer(ctx.provider.newByteChannel(source, this.prepareReadOptions(copyOptions), new FileAttribute[0]), Files.newByteChannel(target, this.prepareWriteOptions(copyOptions), new FileAttribute[0]), bufferSize);
    }

    private void prepareForRead(Path path) throws IOException {
        if (path == null) {
            return;
        }
        Path parent = path.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
    }

    private void prepareForWrite(Path path, Set<PosixFilePermission> dirPerms, Set<PosixFilePermission> filePerms) throws IOException {
        PosixFileAttributeView posixFileAttributeView;
        if (path == null) {
            return;
        }
        Path parent = path.getParent();
        if (parent != null) {
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            posixFileAttributeView = Files.getFileAttributeView(parent, PosixFileAttributeView.class, new LinkOption[0]);
            posixFileAttributeView.setPermissions(dirPerms);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
        posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        posixFileAttributeView.setPermissions(filePerms);
    }

    private Set<? extends OpenOption> prepareReadOptions(CopyOption ... copyOptions) {
        return EnumSet.of(StandardOpenOption.READ);
    }

    private Set<? extends OpenOption> prepareWriteOptions(CopyOption ... copyOptions) {
        EnumSet<StandardOpenOption> options = null;
        for (CopyOption copyOption : copyOptions) {
            if (copyOption != StandardCopyOption.REPLACE_EXISTING) continue;
            options = EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        if (options == null) {
            options = EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        return options;
    }

    private void transfer(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel, int bufferSize) throws IOException {
        int read;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        while ((read = readableByteChannel.read(buffer)) > 0) {
            buffer.flip();
            while (read > 0) {
                read -= writableByteChannel.write(buffer);
            }
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T performWithContext(WithContext<T> action) throws Exception {
        try (SFTPContext ctx = null;){
            if (this.url != null) {
                ctx = new SFTPContext(URI.create(this.url), this.env);
                T t = action.perform(ctx);
                return t;
            }
            T t = null;
            return t;
        }
    }
}

