/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.dirbrowser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wymiwyg.commons.util.dirbrowser.PathNameFilter;
import org.wymiwyg.commons.util.dirbrowser.PathNode;

public class MultiPathNode
implements PathNode {
    private static final Log log = LogFactory.getLog(MultiPathNode.class);
    private final PathNode[] nodes;

    public MultiPathNode(PathNode ... nodes) {
        int i = 0;
        for (PathNode n : nodes) {
            if (n == null) {
                throw new IllegalArgumentException("Pathnode at position " + i + " is null");
            }
            ++i;
        }
        this.nodes = nodes;
    }

    public PathNode getSubPath(String requestPath) {
        ArrayList<PathNode> subNodeList = new ArrayList<PathNode>();
        for (int i = 0; i < this.nodes.length; ++i) {
            PathNode subNode = this.nodes[i].getSubPath(requestPath);
            if (subNode == null) continue;
            subNodeList.add(subNode);
        }
        PathNode[] subNodes = new PathNode[subNodeList.size()];
        subNodes = subNodeList.toArray(subNodes);
        return new MultiPathNode(subNodes);
    }

    public boolean isDirectory() {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].isDirectory()) continue;
            return true;
        }
        return false;
    }

    public String[] list(PathNameFilter filter) {
        HashSet<String> resultList = new HashSet<String>();
        for (int i = 0; i < this.nodes.length; ++i) {
            String[] subList = this.nodes[i].list(filter);
            if (subList == null) continue;
            resultList.addAll(Arrays.asList(subList));
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public String[] list() {
        HashSet<String> resultList = new HashSet<String>();
        for (int i = 0; i < this.nodes.length; ++i) {
            String[] subList = this.nodes[i].list();
            if (subList == null) continue;
            resultList.addAll(Arrays.asList(subList));
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public InputStream getInputStream() throws IOException {
        InputStream result = null;
        for (int i = 0; i < this.nodes.length; ++i) {
            try {
                result = this.nodes[i].getInputStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MultiPathNode of ");
        for (int i = 0; i < this.nodes.length; ++i) {
            buffer.append(this.nodes[i]);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength() {
        InputStream result = null;
        for (int i = 0; i < this.nodes.length; ++i) {
            try {
                result = this.nodes[i].getInputStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) continue;
            try {
                long l = this.nodes[i].getLength();
                return l;
            }
            finally {
                try {
                    result.close();
                }
                catch (IOException e1) {
                    log.error((Object)"cloding inputstream", (Throwable)e1);
                }
            }
        }
        return -1L;
    }

    public String getPath() {
        String currentLongest = this.nodes[0].getPath();
        for (int i = 1; i < this.nodes.length; ++i) {
            currentLongest = this.getLongestCommonSuffix(currentLongest, this.nodes[i].getPath());
        }
        return currentLongest;
    }

    private String getLongestCommonSuffix(String a, String b) {
        String section;
        ArrayList<String> commonSections = new ArrayList<String>();
        String[] aSects = a.split("/");
        String[] bSects = b.split("/");
        for (int i = 1; i <= a.length() && i <= aSects.length && i <= bSects.length && (section = aSects[aSects.length - i]).equals(bSects[bSects.length - i]); ++i) {
            commonSections.add(0, section);
        }
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (String string : commonSections) {
            if (!first) {
                buffer.append('/');
            } else {
                first = false;
            }
            buffer.append(string);
        }
        return buffer.toString();
    }

    public Date getLastModified() {
        Date lastModified = null;
        for (int i = 0; i < this.nodes.length; ++i) {
            PathNode node = this.nodes[i];
            Date currentLastModified = node.getLastModified();
            if (currentLastModified == null || lastModified != null && !currentLastModified.after(lastModified)) continue;
            lastModified = currentLastModified;
        }
        return lastModified;
    }

    public boolean exists() {
        for (PathNode pathNode : this.nodes) {
            if (!pathNode.exists()) continue;
            return true;
        }
        return false;
    }
}

