/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.arguments;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wymiwyg.commons.util.arguments.AnnotatedInterfaceArguments;
import org.wymiwyg.commons.util.arguments.ArgumentProcessor;
import org.wymiwyg.commons.util.arguments.ArgumentsWithHelp;
import org.wymiwyg.commons.util.arguments.InvalidArgumentsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentHandler {
    List argumentList = new ArrayList();

    public ArgumentHandler(String[] arguments) {
        this.argumentList.addAll(Arrays.asList(arguments));
    }

    public void processArguments(ArgumentProcessor processor) throws InvalidArgumentsException {
        processor.process(this.argumentList);
    }

    public <I> I getInstance(Class<I> interfaceClass) throws InvalidArgumentsException {
        I instance = AnnotatedInterfaceArguments.getInstance(interfaceClass, this).getValueObject();
        return instance;
    }

    public static <A> A readArguments(Class<A> interfaceClass, String[] args) {
        Object result = null;
        try {
            ArgumentHandler argumentHandler = new ArgumentHandler(args);
            result = argumentHandler.getInstance(interfaceClass);
            argumentHandler.processArguments(new ArgumentProcessor(){

                @Override
                public void process(List<String> remaining) throws InvalidArgumentsException {
                    if (remaining.size() > 0) {
                        throw new InvalidArgumentsException("The following arguments could not be understood: " + remaining);
                    }
                }
            });
        }
        catch (InvalidArgumentsException e) {
            System.out.println(e.getMessage());
            ArgumentHandler.showUsage(interfaceClass);
            result = null;
        }
        if (result instanceof ArgumentsWithHelp && ((ArgumentsWithHelp)result).getHelp()) {
            ArgumentHandler.showUsage(interfaceClass);
            result = null;
        }
        return result;
    }

    private static <I> void showUsage(Class<I> interfaceClass) {
        System.out.print("This command has the following arguments: ");
        System.out.println(AnnotatedInterfaceArguments.getArgumentsSyntax(interfaceClass));
        PrintWriter out = new PrintWriter(System.out, true);
        AnnotatedInterfaceArguments.printArgumentDescriptions(interfaceClass, out);
        out.flush();
    }
}

