/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.timelogger;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.wymiwyg.commons.timelogger.ReportWriter;
import org.wymiwyg.commons.timelogger.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryReportWriter
implements ReportWriter {
    @Override
    public void write(Iterable<Section> sections, Writer writer) throws IOException {
        HashMap<List<Object>, Summary> paths = new HashMap<List<Object>, Summary>();
        ArrayList<Object> currentPath = new ArrayList<Object>();
        this.handleSections(paths, currentPath, sections);
        TreeSet<List<Object>> sortedPaths = new TreeSet<List<Object>>(new PathComparator());
        sortedPaths.addAll(paths.keySet());
        for (List list : sortedPaths) {
            this.printPath(list, writer);
            Summary value = (Summary)paths.get(list);
            writer.write(": " + value.totalTimeInNanos / 1000000L + "/" + value.count);
            writer.write(10);
        }
        writer.flush();
    }

    private void printPath(List<Object> key, Writer writer) throws IOException {
        boolean first = true;
        for (Object identifier : key) {
            if (!first) {
                writer.write(", ");
            } else {
                first = false;
            }
            writer.write(identifier.toString());
        }
    }

    private void handleSections(Map<List<Object>, Summary> paths, List<Object> currentPath, Iterable<Section> sections) {
        for (Section section : sections) {
            this.handleSection(paths, currentPath, section);
        }
    }

    private void handleSection(Map<List<Object>, Summary> paths, List<Object> currentPath, Section section) {
        Summary summary;
        ArrayList<Object> subPath = new ArrayList<Object>(currentPath);
        subPath.add(section.getIdentifier());
        if (paths.containsKey(subPath)) {
            summary = paths.get(subPath);
        } else {
            summary = new Summary();
            paths.put(subPath, summary);
        }
        ++summary.count;
        summary.totalTimeInNanos += section.getTimeElapsedInNanos();
        this.handleSections(paths, subPath, section.subSections());
    }

    class Summary {
        long totalTimeInNanos = 0L;
        int count = 0;

        Summary() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathComparator
    implements Comparator<List<Object>> {
        @Override
        public int compare(List<Object> o1, List<Object> o2) {
            if (o1.size() == 0) {
                if (o2.size() == 0) {
                    return 0;
                }
                return -1;
            }
            if (o2.size() == 0) {
                return 1;
            }
            int stringComparison = o1.get(0).toString().compareTo(o2.get(0).toString());
            if (stringComparison == 0) {
                return this.compare(this.tail(o1), this.tail(o2));
            }
            return stringComparison;
        }

        private <T> List<T> tail(List<T> list) {
            ArrayList<T> result = new ArrayList<T>();
            boolean first = true;
            for (T t : list) {
                if (first) {
                    first = false;
                    continue;
                }
                result.add(t);
            }
            return result;
        }
    }
}

