/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.jms.receiver;

import java.util.ArrayList;
import java.util.List;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.jms.exception.JMSConnectorException;
import org.wso2.transport.jms.receiver.JMSMessageConsumer;

public class JMSExceptionListener
implements ExceptionListener {
    private static final Logger logger = LoggerFactory.getLogger(JMSExceptionListener.class);
    private List<JMSMessageConsumer> messageConsumers = new ArrayList<JMSMessageConsumer>();

    JMSExceptionListener(JMSMessageConsumer messageConsumer) {
        this.messageConsumers.add(messageConsumer);
    }

    public void addConsumer(JMSMessageConsumer messageConsumer) {
        this.messageConsumers.add(messageConsumer);
    }

    public void onException(JMSException exception) {
        logger.error("Error in the JMS connection. " + exception.getMessage());
        for (JMSMessageConsumer messageConsumer : this.messageConsumers) {
            try {
                messageConsumer.closeAll();
            }
            catch (JMSConnectorException e) {
                logger.error("Error closing connection after exception", (Throwable)e);
            }
            try {
                messageConsumer.startConsuming();
            }
            catch (JMSConnectorException e) {
                throw new RuntimeException("Cannot establish the connection after retrying", e);
            }
        }
    }
}

