/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.statistics.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.wso2.siddhi.core.util.statistics.MemoryUsageTracker;
import org.wso2.siddhi.core.util.statistics.memory.ObjectSizeCalculator;

public class SiddhiMemoryUsageMetric
implements MemoryUsageTracker {
    private ConcurrentMap<Object, ObjectMetric> registeredObjects = new ConcurrentHashMap<Object, ObjectMetric>();
    private MetricRegistry metricRegistry;

    public SiddhiMemoryUsageMetric(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void registerObject(Object object, String name) {
        if (this.registeredObjects.get(object) == null) {
            ObjectMetric objectMetric = new ObjectMetric(object, name);
            this.metricRegistry.register(name, (Metric)objectMetric.getGauge());
            this.registeredObjects.put(object, new ObjectMetric(object, name));
        }
    }

    @Override
    public void enableMemoryUsageMetrics() {
        for (Map.Entry entry : this.registeredObjects.entrySet()) {
            if (this.metricRegistry.getNames().contains(((ObjectMetric)entry.getValue()).getName())) continue;
            this.metricRegistry.register(((ObjectMetric)entry.getValue()).getName(), (Metric)((ObjectMetric)entry.getValue()).getGauge());
        }
    }

    @Override
    public void disableMemoryUsageMetrics() {
        for (Map.Entry entry : this.registeredObjects.entrySet()) {
            this.metricRegistry.remove(((ObjectMetric)entry.getValue()).getName());
        }
    }

    @Override
    public String getName(Object object) {
        if (this.registeredObjects.get(object) != null) {
            return ((ObjectMetric)this.registeredObjects.get(object)).getName();
        }
        return null;
    }

    class ObjectMetric {
        private final Object object;
        private String name;
        private Gauge gauge;

        public ObjectMetric(final Object object, String name) {
            this.object = object;
            this.name = name;
            this.gauge = new Gauge<Long>(){

                public Long getValue() {
                    try {
                        return ObjectSizeCalculator.getObjectSize(object);
                    }
                    catch (UnsupportedOperationException e) {
                        return 0L;
                    }
                }
            };
        }

        public String getName() {
            return this.name;
        }

        public Gauge getGauge() {
            return this.gauge;
        }
    }
}

