/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.aggregation.AggregationRuntime;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.state.StateEventPool;
import org.wso2.siddhi.core.event.state.populater.StateEventPopulatorFactory;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.event.stream.populater.StreamEventPopulaterFactory;
import org.wso2.siddhi.core.exception.QueryableRecordTableException;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.exception.StoreQueryCreationException;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.DeleteStoreQueryRuntime;
import org.wso2.siddhi.core.query.FindStoreQueryRuntime;
import org.wso2.siddhi.core.query.InsertStoreQueryRuntime;
import org.wso2.siddhi.core.query.SelectStoreQueryRuntime;
import org.wso2.siddhi.core.query.StoreQueryRuntime;
import org.wso2.siddhi.core.query.UpdateOrInsertStoreQueryRuntime;
import org.wso2.siddhi.core.query.UpdateStoreQueryRuntime;
import org.wso2.siddhi.core.query.output.callback.OutputCallback;
import org.wso2.siddhi.core.query.output.ratelimit.PassThroughOutputRateLimiter;
import org.wso2.siddhi.core.query.processor.stream.window.QueryableProcessor;
import org.wso2.siddhi.core.query.selector.QuerySelector;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.CompiledSelection;
import org.wso2.siddhi.core.util.collection.operator.IncrementalAggregateCompileCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.lock.LockWrapper;
import org.wso2.siddhi.core.util.parser.OutputParser;
import org.wso2.siddhi.core.util.parser.SelectorParser;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.core.util.snapshot.SnapshotService;
import org.wso2.siddhi.core.window.Window;
import org.wso2.siddhi.query.api.aggregation.Within;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.execution.query.StoreQuery;
import org.wso2.siddhi.query.api.execution.query.input.store.AggregationInputStore;
import org.wso2.siddhi.query.api.execution.query.input.store.ConditionInputStore;
import org.wso2.siddhi.query.api.execution.query.input.store.InputStore;
import org.wso2.siddhi.query.api.execution.query.output.stream.DeleteStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.InsertIntoStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.OutputStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.ReturnStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateOrInsertStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateStream;
import org.wso2.siddhi.query.api.execution.query.selection.Selector;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.constant.BoolConstant;

public class StoreQueryParser {
    private static final Logger log = Logger.getLogger(StoreQueryParser.class);

    public static StoreQueryRuntime parse(StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap) {
        LockWrapper lockWrapper = new LockWrapper("StoreQueryLock");
        lockWrapper.setLock(new ReentrantLock());
        MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
        int metaPosition = -1;
        SnapshotService.getSkipSnapshotableThreadLocal().set(true);
        switch (storeQuery.getType()) {
            case FIND: {
                Within within = null;
                Expression per = null;
                String queryName = "store_select_query_" + storeQuery.getInputStore().getStoreId();
                InputStore inputStore = storeQuery.getInputStore();
                try {
                    BoolConstant onCondition = Expression.value((boolean)true);
                    metaStreamEvent.setInputReferenceId(inputStore.getStoreReferenceId());
                    if (inputStore instanceof AggregationInputStore) {
                        AggregationInputStore aggregationInputStore = (AggregationInputStore)inputStore;
                        if (aggregationMap.get(inputStore.getStoreId()) == null) {
                            throw new StoreQueryCreationException("Aggregation \"" + inputStore.getStoreId() + "\" has not been defined");
                        }
                        if (aggregationInputStore.getPer() != null && aggregationInputStore.getWithin() != null) {
                            within = aggregationInputStore.getWithin();
                            per = aggregationInputStore.getPer();
                        } else if (aggregationInputStore.getPer() != null || aggregationInputStore.getWithin() != null) {
                            throw new StoreQueryCreationException(inputStore.getStoreId() + " should either have both 'within' and 'per' defined or none.");
                        }
                        if (((AggregationInputStore)inputStore).getOnCondition() != null) {
                            onCondition = ((AggregationInputStore)inputStore).getOnCondition();
                        }
                    } else if (inputStore instanceof ConditionInputStore && ((ConditionInputStore)inputStore).getOnCondition() != null) {
                        onCondition = ((ConditionInputStore)inputStore).getOnCondition();
                    }
                    ArrayList<VariableExpressionExecutor> variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
                    Table table = tableMap.get(inputStore.getStoreId());
                    if (table != null) {
                        StoreQueryRuntime storeQueryRuntime = StoreQueryParser.constructStoreQueryRuntime(table, storeQuery, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, (Expression)onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper);
                        return storeQueryRuntime;
                    }
                    AggregationRuntime aggregation = aggregationMap.get(inputStore.getStoreId());
                    if (aggregation != null) {
                        StoreQueryRuntime storeQueryRuntime = StoreQueryParser.constructStoreQueryRuntime(aggregation, storeQuery, siddhiAppContext, tableMap, windowMap, queryName, within, per, (Expression)onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper);
                        return storeQueryRuntime;
                    }
                    Window window = windowMap.get(inputStore.getStoreId());
                    if (window != null) {
                        StoreQueryRuntime storeQueryRuntime = StoreQueryParser.constructStoreQueryRuntime(window, storeQuery, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, (Expression)onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper);
                        return storeQueryRuntime;
                    }
                    throw new StoreQueryCreationException(inputStore.getStoreId() + " is neither a table, aggregation or window");
                }
                finally {
                    SnapshotService.getSkipSnapshotableThreadLocal().set(null);
                }
            }
            case INSERT: {
                InsertIntoStream inserIntoStreamt = (InsertIntoStream)storeQuery.getOutputStream();
                String queryName = "store_insert_query_" + inserIntoStreamt.getId();
                BoolConstant onCondition = Expression.value((boolean)true);
                return StoreQueryParser.getStoreQueryRuntime(storeQuery, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, lockWrapper, metaStreamEvent, (OutputStream)inserIntoStreamt, (Expression)onCondition);
            }
            case DELETE: {
                DeleteStream deleteStream = (DeleteStream)storeQuery.getOutputStream();
                String queryName = "store_delete_query_" + deleteStream.getId();
                Expression onCondition = deleteStream.getOnDeleteExpression();
                return StoreQueryParser.getStoreQueryRuntime(storeQuery, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, lockWrapper, metaStreamEvent, (OutputStream)deleteStream, onCondition);
            }
            case UPDATE: {
                UpdateStream outputStream = (UpdateStream)storeQuery.getOutputStream();
                String queryName = "store_update_query_" + outputStream.getId();
                Expression onCondition = outputStream.getOnUpdateExpression();
                return StoreQueryParser.getStoreQueryRuntime(storeQuery, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, lockWrapper, metaStreamEvent, (OutputStream)outputStream, onCondition);
            }
            case UPDATE_OR_INSERT: {
                UpdateOrInsertStream storeQueryOutputStream = (UpdateOrInsertStream)storeQuery.getOutputStream();
                String queryName = "store_update_or_insert_query_" + storeQueryOutputStream.getId();
                Expression onCondition = storeQueryOutputStream.getOnUpdateExpression();
                return StoreQueryParser.getStoreQueryRuntime(storeQuery, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, lockWrapper, metaStreamEvent, (OutputStream)storeQueryOutputStream, onCondition);
            }
        }
        return null;
    }

    private static StoreQueryRuntime getStoreQueryRuntime(StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, Map<String, Window> windowMap, String queryName, int metaPosition, LockWrapper lockWrapper, MetaStreamEvent metaStreamEvent, OutputStream outputStream, Expression onCondition) {
        try {
            ArrayList<VariableExpressionExecutor> variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
            Table table = tableMap.get(outputStream.getId());
            if (table != null) {
                StoreQueryRuntime storeQueryRuntime = StoreQueryParser.constructStoreQueryRuntime(table, storeQuery, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper);
                return storeQueryRuntime;
            }
            throw new StoreQueryCreationException(outputStream.getId() + " is not a table.");
        }
        finally {
            SnapshotService.getSkipSnapshotableThreadLocal().set(null);
        }
    }

    private static StoreQueryRuntime constructStoreQueryRuntime(Window window, StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, Map<String, Window> windowMap, String queryName, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, LockWrapper lockWrapper) {
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.WINDOW);
        StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition());
        MatchingMetaInfoHolder metaStreamInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition());
        CompiledCondition compiledCondition = window.compileCondition(onCondition, StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition()), siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
        FindStoreQueryRuntime findStoreQueryRuntime = new FindStoreQueryRuntime(window, compiledCondition, queryName, metaStreamEvent);
        StoreQueryParser.populateFindStoreQueryRuntime(findStoreQueryRuntime, metaStreamInfoHolder, storeQuery.getSelector(), variableExpressionExecutors, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, lockWrapper);
        return findStoreQueryRuntime;
    }

    private static StoreQueryRuntime constructStoreQueryRuntime(AggregationRuntime aggregation, StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, Map<String, Window> windowMap, String queryName, Within within, Expression per, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, LockWrapper lockWrapper) {
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.AGGREGATE);
        StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)aggregation.getAggregationDefinition());
        MatchingMetaInfoHolder metaStreamInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)aggregation.getAggregationDefinition());
        CompiledCondition compiledCondition = aggregation.compileExpression(onCondition, within, per, metaStreamInfoHolder, variableExpressionExecutors, tableMap, queryName, siddhiAppContext);
        metaStreamInfoHolder = ((IncrementalAggregateCompileCondition)compiledCondition).getAlteredMatchingMetaInfoHolder();
        FindStoreQueryRuntime findStoreQueryRuntime = new FindStoreQueryRuntime(aggregation, compiledCondition, queryName, metaStreamEvent);
        int metaPosition = 1;
        StoreQueryParser.populateFindStoreQueryRuntime(findStoreQueryRuntime, metaStreamInfoHolder, storeQuery.getSelector(), variableExpressionExecutors, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, lockWrapper);
        ComplexEventPopulater complexEventPopulater = StreamEventPopulaterFactory.constructEventPopulator(metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvent(0), 0, ((IncrementalAggregateCompileCondition)compiledCondition).getAdditionalAttributes());
        ((IncrementalAggregateCompileCondition)compiledCondition).setComplexEventPopulater(complexEventPopulater);
        return findStoreQueryRuntime;
    }

    private static StoreQueryRuntime constructStoreQueryRuntime(Table table, StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, Map<String, Window> windowMap, String queryName, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, LockWrapper lockWrapper) {
        if (table instanceof QueryableProcessor && storeQuery.getType() == StoreQuery.StoreQueryType.FIND) {
            try {
                return StoreQueryParser.constructOptimizedStoreQueryRuntime(table, storeQuery, siddhiAppContext, tableMap, queryName, metaPosition, onCondition, metaStreamEvent, variableExpressionExecutors);
            }
            catch (QueryableRecordTableException | SiddhiAppCreationException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Store Query optimization failed for table: " + table.getTableDefinition().getId() + ". Creating Store Query runtime in normal mode. Reason for failure: " + e.getMessage()));
                }
                return StoreQueryParser.constructRegularStoreQueryRuntime(table, storeQuery, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper);
            }
        }
        return StoreQueryParser.constructRegularStoreQueryRuntime(table, storeQuery, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper);
    }

    private static StoreQueryRuntime constructOptimizedStoreQueryRuntime(Table table, StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, String queryName, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors) {
        StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
        MatchingMetaInfoHolder matchingMetaInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
        CompiledCondition compiledCondition = table.compileCondition(onCondition, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
        List<Attribute> expectedOutputAttributes = StoreQueryParser.buildExpectedOutputAttributes(storeQuery, siddhiAppContext, tableMap, queryName, metaPosition, matchingMetaInfoHolder);
        MatchingMetaInfoHolder matchingMetaInfoHolderForSelection = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, StoreQueryParser.generateTableDefinitionFromStoreQuery(storeQuery, expectedOutputAttributes), (AbstractDefinition)table.getTableDefinition());
        CompiledSelection compiledSelection = ((QueryableProcessor)((Object)table)).compileSelection(storeQuery.getSelector(), expectedOutputAttributes, matchingMetaInfoHolderForSelection, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
        SelectStoreQueryRuntime storeQueryRuntime = new SelectStoreQueryRuntime((QueryableProcessor)((Object)table), compiledCondition, compiledSelection, expectedOutputAttributes, queryName);
        QueryParserHelper.reduceMetaComplexEvent(matchingMetaInfoHolder.getMetaStateEvent());
        QueryParserHelper.updateVariablePosition(matchingMetaInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
        return storeQueryRuntime;
    }

    private static StoreQueryRuntime constructRegularStoreQueryRuntime(Table table, StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, Map<String, Window> windowMap, String queryName, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, LockWrapper lockWrapper) {
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.TABLE);
        switch (storeQuery.getType()) {
            case FIND: {
                StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
                MatchingMetaInfoHolder matchingMetaInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
                CompiledCondition compiledCondition = table.compileCondition(onCondition, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
                FindStoreQueryRuntime findStoreQueryRuntime = new FindStoreQueryRuntime(table, compiledCondition, queryName, metaStreamEvent);
                StoreQueryParser.populateFindStoreQueryRuntime(findStoreQueryRuntime, matchingMetaInfoHolder, storeQuery.getSelector(), variableExpressionExecutors, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, lockWrapper);
                return findStoreQueryRuntime;
            }
            case INSERT: {
                StoreQueryParser.initMetaStreamEvent(metaStreamEvent, StoreQueryParser.getInputDefinition(storeQuery, table));
                MatchingMetaInfoHolder matchingMetaInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
                QuerySelector querySelector = StoreQueryParser.getQuerySelector(matchingMetaInfoHolder, variableExpressionExecutors, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, storeQuery, lockWrapper);
                InsertStoreQueryRuntime insertStoreQueryRuntime = new InsertStoreQueryRuntime(queryName, metaStreamEvent);
                insertStoreQueryRuntime.setStateEventPool(new StateEventPool(matchingMetaInfoHolder.getMetaStateEvent(), 5));
                insertStoreQueryRuntime.setSelector(querySelector);
                insertStoreQueryRuntime.setOutputAttributes(matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
                return insertStoreQueryRuntime;
            }
            case DELETE: {
                AbstractDefinition inputDefinition = StoreQueryParser.getInputDefinition(storeQuery, table);
                StoreQueryParser.initMetaStreamEvent(metaStreamEvent, inputDefinition);
                MatchingMetaInfoHolder matchingMetaInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, inputDefinition, (AbstractDefinition)table.getTableDefinition());
                QuerySelector querySelector = StoreQueryParser.getQuerySelector(matchingMetaInfoHolder, variableExpressionExecutors, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, storeQuery, lockWrapper);
                DeleteStoreQueryRuntime deleteStoreQueryRuntime = new DeleteStoreQueryRuntime(queryName, metaStreamEvent);
                deleteStoreQueryRuntime.setStateEventPool(new StateEventPool(matchingMetaInfoHolder.getMetaStateEvent(), 5));
                deleteStoreQueryRuntime.setSelector(querySelector);
                deleteStoreQueryRuntime.setOutputAttributes(matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
                return deleteStoreQueryRuntime;
            }
            case UPDATE: {
                AbstractDefinition inputDefinition = StoreQueryParser.getInputDefinition(storeQuery, table);
                StoreQueryParser.initMetaStreamEvent(metaStreamEvent, inputDefinition);
                MatchingMetaInfoHolder matchingMetaInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, inputDefinition, (AbstractDefinition)table.getTableDefinition());
                QuerySelector querySelector = StoreQueryParser.getQuerySelector(matchingMetaInfoHolder, variableExpressionExecutors, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, storeQuery, lockWrapper);
                UpdateStoreQueryRuntime updateStoreQueryRuntime = new UpdateStoreQueryRuntime(queryName, metaStreamEvent);
                updateStoreQueryRuntime.setStateEventPool(new StateEventPool(matchingMetaInfoHolder.getMetaStateEvent(), 5));
                updateStoreQueryRuntime.setSelector(querySelector);
                updateStoreQueryRuntime.setOutputAttributes(matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
                return updateStoreQueryRuntime;
            }
            case UPDATE_OR_INSERT: {
                AbstractDefinition inputDefinition = StoreQueryParser.getInputDefinition(storeQuery, table);
                StoreQueryParser.initMetaStreamEvent(metaStreamEvent, inputDefinition);
                MatchingMetaInfoHolder matchingMetaInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, inputDefinition, (AbstractDefinition)table.getTableDefinition());
                QuerySelector querySelector = StoreQueryParser.getQuerySelector(matchingMetaInfoHolder, variableExpressionExecutors, siddhiAppContext, tableMap, windowMap, queryName, metaPosition, storeQuery, lockWrapper);
                UpdateOrInsertStoreQueryRuntime updateOrInsertIntoStoreQueryRuntime = new UpdateOrInsertStoreQueryRuntime(queryName, metaStreamEvent);
                updateOrInsertIntoStoreQueryRuntime.setStateEventPool(new StateEventPool(matchingMetaInfoHolder.getMetaStateEvent(), 5));
                updateOrInsertIntoStoreQueryRuntime.setSelector(querySelector);
                updateOrInsertIntoStoreQueryRuntime.setOutputAttributes(matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
                return updateOrInsertIntoStoreQueryRuntime;
            }
        }
        return null;
    }

    private static List<Attribute> buildExpectedOutputAttributes(StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, String queryName, int metaPosition, MatchingMetaInfoHolder metaStreamInfoHolder) {
        MetaStateEvent selectMetaStateEvent = new MetaStateEvent(metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvents());
        SelectorParser.parse(storeQuery.getSelector(), (OutputStream)new ReturnStream(OutputStream.OutputEventType.CURRENT_EVENTS), siddhiAppContext, selectMetaStateEvent, tableMap, new ArrayList<VariableExpressionExecutor>(), queryName, metaPosition);
        return selectMetaStateEvent.getOutputStreamDefinition().getAttributeList();
    }

    private static void populateFindStoreQueryRuntime(FindStoreQueryRuntime findStoreQueryRuntime, MatchingMetaInfoHolder metaStreamInfoHolder, Selector selector, List<VariableExpressionExecutor> variableExpressionExecutors, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, Map<String, Window> windowMap, String queryName, int metaPosition, LockWrapper lockWrapper) {
        ReturnStream returnStream = new ReturnStream(OutputStream.OutputEventType.CURRENT_EVENTS);
        QuerySelector querySelector = SelectorParser.parse(selector, (OutputStream)returnStream, siddhiAppContext, metaStreamInfoHolder.getMetaStateEvent(), tableMap, variableExpressionExecutors, queryName, metaPosition);
        PassThroughOutputRateLimiter rateLimiter = new PassThroughOutputRateLimiter(queryName);
        rateLimiter.init(siddhiAppContext, lockWrapper, queryName);
        OutputCallback outputCallback = OutputParser.constructOutputCallback((OutputStream)returnStream, metaStreamInfoHolder.getMetaStateEvent().getOutputStreamDefinition(), tableMap, windowMap, siddhiAppContext, true, queryName);
        rateLimiter.setOutputCallback(outputCallback);
        querySelector.setNextProcessor(rateLimiter);
        QueryParserHelper.reduceMetaComplexEvent(metaStreamInfoHolder.getMetaStateEvent());
        QueryParserHelper.updateVariablePosition(metaStreamInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
        querySelector.setEventPopulator(StateEventPopulatorFactory.constructEventPopulator(metaStreamInfoHolder.getMetaStateEvent()));
        findStoreQueryRuntime.setStateEventPool(new StateEventPool(metaStreamInfoHolder.getMetaStateEvent(), 5));
        findStoreQueryRuntime.setSelector(querySelector);
        findStoreQueryRuntime.setOutputAttributes(metaStreamInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
    }

    private static QuerySelector getQuerySelector(MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, Map<String, Window> windowMap, String queryName, int metaPosition, StoreQuery storeQuery, LockWrapper lockWrapper) {
        QuerySelector querySelector = SelectorParser.parse(storeQuery.getSelector(), storeQuery.getOutputStream(), siddhiAppContext, matchingMetaInfoHolder.getMetaStateEvent(), tableMap, variableExpressionExecutors, queryName, metaPosition);
        PassThroughOutputRateLimiter rateLimiter = new PassThroughOutputRateLimiter(queryName);
        rateLimiter.init(siddhiAppContext, lockWrapper, queryName);
        OutputCallback outputCallback = OutputParser.constructOutputCallback(storeQuery.getOutputStream(), matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition(), tableMap, windowMap, siddhiAppContext, true, queryName);
        rateLimiter.setOutputCallback(outputCallback);
        querySelector.setNextProcessor(rateLimiter);
        QueryParserHelper.reduceMetaComplexEvent(matchingMetaInfoHolder.getMetaStateEvent());
        QueryParserHelper.updateVariablePosition(matchingMetaInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
        querySelector.setEventPopulator(StateEventPopulatorFactory.constructEventPopulator(matchingMetaInfoHolder.getMetaStateEvent()));
        return querySelector;
    }

    private static MatchingMetaInfoHolder generateMatchingMetaInfoHolder(MetaStreamEvent metaStreamEvent, AbstractDefinition definition) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(1);
        metaStateEvent.addEvent(metaStreamEvent);
        return new MatchingMetaInfoHolder(metaStateEvent, -1, 0, definition, definition, 0);
    }

    private static AbstractDefinition generateTableDefinitionFromStoreQuery(StoreQuery storeQuery, List<Attribute> expectedOutputAttributes) {
        TableDefinition tableDefinition = TableDefinition.id((String)storeQuery.getInputStore().getStoreId());
        for (Attribute attribute : expectedOutputAttributes) {
            tableDefinition.attribute(attribute.getName(), attribute.getType());
        }
        return tableDefinition;
    }

    private static MatchingMetaInfoHolder generateMatchingMetaInfoHolder(MetaStreamEvent metaStreamEvent, AbstractDefinition streamDefinition, AbstractDefinition storeDefinition) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(1);
        metaStateEvent.addEvent(metaStreamEvent);
        return new MatchingMetaInfoHolder(metaStateEvent, -1, 0, streamDefinition, storeDefinition, 0);
    }

    private static void initMetaStreamEvent(MetaStreamEvent metaStreamEvent, AbstractDefinition inputDefinition) {
        metaStreamEvent.addInputDefinition(inputDefinition);
        metaStreamEvent.initializeAfterWindowData();
        inputDefinition.getAttributeList().forEach(metaStreamEvent::addData);
    }

    private static AbstractDefinition getInputDefinition(StoreQuery storeQuery, Table table) {
        if (storeQuery.getSelector().getSelectionList().isEmpty()) {
            return table.getTableDefinition();
        }
        StreamDefinition streamDefinition = new StreamDefinition();
        streamDefinition.setId(table.getTableDefinition().getId() + "InputStream");
        return streamDefinition;
    }
}

