/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.ConversionStreamEventChunk;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveProcessor;
import org.wso2.siddhi.core.util.Schedulable;
import org.wso2.siddhi.core.util.ThreadBarrier;
import org.wso2.siddhi.core.util.lock.LockWrapper;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.util.statistics.metrics.Level;
import org.wso2.siddhi.core.util.timestamp.TimestampGeneratorImpl;

public class Scheduler
implements Snapshotable {
    private static final Logger log = Logger.getLogger(Scheduler.class);
    private final BlockingQueue<Long> toNotifyQueue = new LinkedBlockingQueue<Long>();
    private final ThreadBarrier threadBarrier;
    private final Schedulable singleThreadEntryValve;
    private SiddhiAppContext siddhiAppContext;
    private String elementId;
    protected String queryName;
    private LockWrapper lockWrapper;
    private ScheduledExecutorService scheduledExecutorService;
    private EventCaller eventCaller;
    private final Semaphore mutex;
    private StreamEventPool streamEventPool;
    private ComplexEventChunk<StreamEvent> streamEventChunk;
    private LatencyTracker latencyTracker;
    private volatile boolean running = false;
    private ScheduledFuture scheduledFuture;

    public Scheduler(Schedulable singleThreadEntryValve, SiddhiAppContext siddhiAppContext) {
        this.threadBarrier = siddhiAppContext.getThreadBarrier();
        this.siddhiAppContext = siddhiAppContext;
        this.singleThreadEntryValve = singleThreadEntryValve;
        this.scheduledExecutorService = siddhiAppContext.getScheduledExecutorService();
        this.eventCaller = new EventCaller();
        this.mutex = new Semaphore(1);
        siddhiAppContext.getTimestampGenerator().addTimeChangeListener(new TimestampGeneratorImpl.TimeChangeListener(){

            @Override
            public void onTimeChange(long currentTimestamp) {
                Long lastTime = (Long)Scheduler.this.toNotifyQueue.peek();
                if (lastTime != null && lastTime <= currentTimestamp) {
                    Scheduler.this.sendTimerEvents();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(long time) {
        if (!this.siddhiAppContext.isPlayback() && !this.running && this.toNotifyQueue.size() == 1) {
            try {
                this.mutex.acquire();
                if (!this.running) {
                    this.running = true;
                    long timeDiff = time - this.siddhiAppContext.getTimestampGenerator().currentTime();
                    this.scheduledFuture = timeDiff > 0L ? this.scheduledExecutorService.schedule(this.eventCaller, timeDiff, TimeUnit.MILLISECONDS) : this.scheduledExecutorService.schedule(this.eventCaller, 0L, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error((Object)"Error when scheduling System Time Based Scheduler", (Throwable)e);
            }
            finally {
                this.mutex.release();
            }
        }
    }

    public Scheduler clone(String key, EntryValveProcessor entryValveProcessor) {
        Scheduler scheduler = new Scheduler(entryValveProcessor, this.siddhiAppContext);
        scheduler.elementId = this.elementId + "-" + key;
        return scheduler;
    }

    public void notifyAt(long time) {
        try {
            this.toNotifyQueue.put(time);
            this.schedule(time);
        }
        catch (InterruptedException e) {
            log.error((Object)("Error when adding time:" + time + " to toNotifyQueue at Scheduler"), (Throwable)e);
        }
    }

    public void setStreamEventPool(StreamEventPool streamEventPool) {
        this.streamEventPool = streamEventPool;
        this.streamEventChunk = new ConversionStreamEventChunk((StreamEventConverter)null, streamEventPool);
    }

    public void init(LockWrapper lockWrapper, String queryName) {
        this.lockWrapper = lockWrapper;
        this.queryName = queryName;
        if (this.elementId == null) {
            this.elementId = "Scheduler-" + this.siddhiAppContext.getElementIdGenerator().createNewId();
        }
        this.siddhiAppContext.getSnapshotService().addSnapshotable(queryName, this);
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("ToNotifyQueue", this.toNotifyQueue);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        BlockingQueue restoreToNotifyQueue = (BlockingQueue)state.get("ToNotifyQueue");
        for (Long time : restoreToNotifyQueue) {
            this.notifyAt(time);
        }
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public void clean() {
        this.siddhiAppContext.getSnapshotService().removeSnapshotable(this.queryName, this);
    }

    public void setLatencyTracker(LatencyTracker latencyTracker) {
        this.latencyTracker = latencyTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendTimerEvents() {
        Long toNotifyTime = (Long)this.toNotifyQueue.peek();
        long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
        while (toNotifyTime != null && toNotifyTime - currentTime <= 0L) {
            block10: {
                this.toNotifyQueue.poll();
                StreamEvent timerEvent = this.streamEventPool.borrowEvent();
                timerEvent.setType(ComplexEvent.Type.TIMER);
                timerEvent.setTimestamp(toNotifyTime);
                this.streamEventChunk.add(timerEvent);
                if (this.lockWrapper != null) {
                    this.lockWrapper.lock();
                }
                this.threadBarrier.pass();
                try {
                    if (Level.DETAIL.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0 && this.latencyTracker != null) {
                        try {
                            this.latencyTracker.markIn();
                            this.singleThreadEntryValve.process(this.streamEventChunk);
                            break block10;
                        }
                        finally {
                            this.latencyTracker.markOut();
                        }
                    }
                    this.singleThreadEntryValve.process(this.streamEventChunk);
                }
                finally {
                    if (this.lockWrapper != null) {
                        this.lockWrapper.unlock();
                    }
                }
            }
            this.streamEventChunk.clear();
            toNotifyTime = (Long)this.toNotifyQueue.peek();
            currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
        }
    }

    public void switchToLiveMode() {
        Long toNotifyTime = (Long)this.toNotifyQueue.peek();
        if (toNotifyTime != null) {
            this.schedule(toNotifyTime);
        }
    }

    public void switchToPlayBackMode() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.running = false;
    }

    private class EventCaller
    implements Runnable {
        private EventCaller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                try {
                    if (!Scheduler.this.siddhiAppContext.isPlayback()) {
                        Scheduler.this.sendTimerEvents();
                        Long toNotifyTime = (Long)Scheduler.this.toNotifyQueue.peek();
                        long currentTime = Scheduler.this.siddhiAppContext.getTimestampGenerator().currentTime();
                        if (toNotifyTime != null) {
                            Scheduler.this.scheduledFuture = Scheduler.this.scheduledExecutorService.schedule(Scheduler.this.eventCaller, toNotifyTime - currentTime, TimeUnit.MILLISECONDS);
                            break block10;
                        }
                        try {
                            Scheduler.this.mutex.acquire();
                            Scheduler.this.running = false;
                            if (Scheduler.this.toNotifyQueue.peek() != null) {
                                Scheduler.this.running = true;
                                Scheduler.this.scheduledFuture = Scheduler.this.scheduledExecutorService.schedule(Scheduler.this.eventCaller, 0L, TimeUnit.MILLISECONDS);
                            }
                            break block10;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            log.error((Object)"Error when scheduling System Time Based Scheduler", (Throwable)e);
                            break block10;
                        }
                        finally {
                            Scheduler.this.mutex.release();
                        }
                    }
                    Scheduler.this.running = false;
                }
                catch (Throwable t) {
                    log.error((Object)t);
                }
            }
        }
    }
}

