/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.trigger;

import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.trigger.Trigger;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.core.util.statistics.ThroughputTracker;
import org.wso2.siddhi.core.util.statistics.metrics.Level;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;

public class StartTrigger
implements Trigger {
    private TriggerDefinition triggerDefinition;
    private SiddhiAppContext siddhiAppContext;
    private StreamJunction streamJunction;
    private ThroughputTracker throughputTracker;

    @Override
    public void init(TriggerDefinition triggerDefinition, SiddhiAppContext siddhiAppContext, StreamJunction streamJunction) {
        this.triggerDefinition = triggerDefinition;
        this.siddhiAppContext = siddhiAppContext;
        this.streamJunction = streamJunction;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.throughputTracker = QueryParserHelper.createThroughputTracker(siddhiAppContext, triggerDefinition.getId(), "Trigger", null);
        }
    }

    @Override
    public TriggerDefinition getTriggerDefinition() {
        return this.triggerDefinition;
    }

    @Override
    public String getId() {
        return this.triggerDefinition.getId();
    }

    @Override
    public void start() {
        long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
        if (this.throughputTracker != null && Level.DETAIL.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
            this.throughputTracker.eventIn();
        }
        this.streamJunction.sendEvent(new Event(currentTime, new Object[]{currentTime}));
    }

    @Override
    public void stop() {
    }
}

