/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.trigger;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.trigger.Trigger;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.core.util.statistics.ThroughputTracker;
import org.wso2.siddhi.core.util.statistics.metrics.Level;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;

public class PeriodicTrigger
implements Trigger {
    private TriggerDefinition triggerDefinition;
    private SiddhiAppContext siddhiAppContext;
    private StreamJunction streamJunction;
    private ScheduledFuture scheduledFuture;
    private ThroughputTracker throughputTracker;

    @Override
    public void init(TriggerDefinition triggerDefinition, SiddhiAppContext siddhiAppContext, StreamJunction streamJunction) {
        this.triggerDefinition = triggerDefinition;
        this.siddhiAppContext = siddhiAppContext;
        this.streamJunction = streamJunction;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.throughputTracker = QueryParserHelper.createThroughputTracker(siddhiAppContext, triggerDefinition.getId(), "Trigger", null);
        }
    }

    @Override
    public TriggerDefinition getTriggerDefinition() {
        return this.triggerDefinition;
    }

    @Override
    public String getId() {
        return this.triggerDefinition.getId();
    }

    @Override
    public void start() {
        this.scheduledFuture = this.siddhiAppContext.getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long currentTime = PeriodicTrigger.this.siddhiAppContext.getTimestampGenerator().currentTime();
                if (PeriodicTrigger.this.throughputTracker != null && Level.DETAIL.compareTo(PeriodicTrigger.this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    PeriodicTrigger.this.throughputTracker.eventIn();
                }
                PeriodicTrigger.this.streamJunction.sendEvent(new Event(currentTime, new Object[]{currentTime}));
            }
        }, this.triggerDefinition.getAtEvery(), this.triggerDefinition.getAtEvery(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }
}

