/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.output.sink;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.ConnectionUnavailableException;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.stream.output.sink.SinkHandler;
import org.wso2.siddhi.core.stream.output.sink.SinkHandlerCallback;
import org.wso2.siddhi.core.stream.output.sink.SinkListener;
import org.wso2.siddhi.core.stream.output.sink.SinkMapper;
import org.wso2.siddhi.core.stream.output.sink.distributed.DistributedTransport;
import org.wso2.siddhi.core.util.ExceptionUtil;
import org.wso2.siddhi.core.util.StringUtil;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.util.statistics.ThroughputTracker;
import org.wso2.siddhi.core.util.statistics.metrics.Level;
import org.wso2.siddhi.core.util.transport.BackoffRetryCounter;
import org.wso2.siddhi.core.util.transport.DynamicOptions;
import org.wso2.siddhi.core.util.transport.OptionHolder;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public abstract class Sink
implements SinkListener,
Snapshotable {
    private static final Logger LOG = Logger.getLogger(Sink.class);
    private StreamDefinition streamDefinition;
    private String type;
    private SinkMapper mapper;
    private SinkHandler handler;
    private DistributedTransport.ConnectionCallback connectionCallback = null;
    private String elementId;
    private SiddhiAppContext siddhiAppContext;
    private OnErrorAction onErrorAction;
    protected AtomicBoolean isTryingToConnect = new AtomicBoolean(false);
    private BackoffRetryCounter backoffRetryCounter = new BackoffRetryCounter();
    private BackoffRetryCounter backoffPublishRetryCounter = new BackoffRetryCounter();
    private AtomicBoolean isConnected = new AtomicBoolean(false);
    private ThreadLocal<DynamicOptions> trpDynamicOptions;
    private ScheduledExecutorService scheduledExecutorService;
    private ThroughputTracker throughputTracker;
    private LatencyTracker mapperLatencyTracker;

    public final void init(StreamDefinition streamDefinition, String type, OptionHolder transportOptionHolder, ConfigReader sinkConfigReader, SinkMapper sinkMapper, String mapType, OptionHolder mapOptionHolder, SinkHandler sinkHandler, List<Element> payloadElementList, ConfigReader mapperConfigReader, SiddhiAppContext siddhiAppContext) {
        this.streamDefinition = streamDefinition;
        this.type = type;
        this.elementId = siddhiAppContext.getElementIdGenerator().createNewId();
        this.siddhiAppContext = siddhiAppContext;
        this.onErrorAction = OnErrorAction.valueOf(transportOptionHolder.getOrCreateOption("on.error", "LOG").getValue().toUpperCase());
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.throughputTracker = QueryParserHelper.createThroughputTracker(siddhiAppContext, streamDefinition.getId(), "Sinks", type);
            this.mapperLatencyTracker = QueryParserHelper.createLatencyTracker(siddhiAppContext, streamDefinition.getId(), "SinkMappers", type + "." + mapType);
        }
        this.init(streamDefinition, transportOptionHolder, sinkConfigReader, siddhiAppContext);
        if (sinkMapper != null) {
            sinkMapper.init(streamDefinition, mapType, mapOptionHolder, payloadElementList, this, mapperConfigReader, this.mapperLatencyTracker, siddhiAppContext);
            this.mapper = sinkMapper;
        }
        if (sinkHandler != null) {
            sinkHandler.initSinkHandler(siddhiAppContext.getElementIdGenerator().createNewId(), streamDefinition, new SinkHandlerCallback(sinkMapper));
            this.handler = sinkHandler;
        }
        this.scheduledExecutorService = siddhiAppContext.getScheduledExecutorService();
    }

    public abstract Class[] getSupportedInputEventClasses();

    public final void initOnlyTransport(StreamDefinition streamDefinition, OptionHolder transportOptionHolder, ConfigReader sinkConfigReader, String type, DistributedTransport.ConnectionCallback connectionCallback, SiddhiAppContext siddhiAppContext) {
        this.type = type;
        this.streamDefinition = streamDefinition;
        this.connectionCallback = connectionCallback;
        this.elementId = siddhiAppContext.getElementIdGenerator().createNewId();
        this.siddhiAppContext = siddhiAppContext;
        this.init(streamDefinition, transportOptionHolder, sinkConfigReader, siddhiAppContext);
        this.scheduledExecutorService = siddhiAppContext.getScheduledExecutorService();
    }

    public abstract String[] getSupportedDynamicOptions();

    protected abstract void init(StreamDefinition var1, OptionHolder var2, ConfigReader var3, SiddhiAppContext var4);

    @Override
    public final void publish(Object payload) {
        if (this.mapperLatencyTracker != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
            this.mapperLatencyTracker.markOut();
        }
        if (this.isConnected()) {
            try {
                DynamicOptions dynamicOptions = this.trpDynamicOptions.get();
                this.publish(payload, dynamicOptions);
                if (this.throughputTracker != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.throughputTracker.eventIn();
                }
            }
            catch (ConnectionUnavailableException e) {
                this.setConnected(false);
                if (this.connectionCallback != null) {
                    this.connectionCallback.connectionFailed();
                }
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Sink '" + this.type + "' at '" + this.streamDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.publish(payload);
            }
        } else if (this.isTryingToConnect.get()) {
            this.onError(payload, new SiddhiAppRuntimeException("Connection unavailable at Sink '" + this.type + "' at '" + this.streamDefinition.getId() + "'. Connection retrying is in progress from a different thread."));
        } else {
            this.connectWithRetry();
            this.publish(payload);
        }
    }

    public abstract void publish(Object var1, DynamicOptions var2) throws ConnectionUnavailableException;

    public abstract void connect() throws ConnectionUnavailableException;

    public abstract void disconnect();

    public abstract void destroy();

    public final String getType() {
        return this.type;
    }

    public final SinkMapper getMapper() {
        return this.mapper;
    }

    public SinkHandler getHandler() {
        return this.handler;
    }

    public void connectWithRetry() {
        if (!this.isConnected.get()) {
            this.isTryingToConnect.set(true);
            try {
                this.connect();
                this.setConnected(true);
                this.isTryingToConnect.set(false);
                if (this.connectionCallback != null) {
                    this.connectionCallback.connectionEstablished();
                }
                this.backoffRetryCounter.reset();
            }
            catch (ConnectionUnavailableException e) {
                LOG.error((Object)StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error while connecting at Sink '" + this.type + "' at '" + this.streamDefinition.getId() + "', will retry in '" + this.backoffRetryCounter.getTimeInterval() + "'."), (Throwable)e);
                this.scheduledExecutorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Sink.this.connectWithRetry();
                    }
                }, this.backoffRetryCounter.getTimeIntervalMillis(), TimeUnit.MILLISECONDS);
                this.backoffRetryCounter.increment();
            }
            catch (RuntimeException e) {
                LOG.error((Object)(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext)) + " Error while connecting at Sink '" + StringUtil.removeCRLFCharacters(this.type) + "' at '" + StringUtil.removeCRLFCharacters(this.streamDefinition.getId()) + "'."), (Throwable)e);
                throw e;
            }
        }
    }

    public void shutdown() {
        this.disconnect();
        this.destroy();
        this.setConnected(false);
        this.isTryingToConnect.set(false);
        if (this.connectionCallback != null) {
            this.connectionCallback.connectionFailed();
        }
    }

    @Override
    public final String getElementId() {
        return this.elementId;
    }

    @Override
    public void clean() {
    }

    void setTrpDynamicOptions(ThreadLocal<DynamicOptions> trpDynamicOptions) {
        this.trpDynamicOptions = trpDynamicOptions;
    }

    public StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    public boolean isConnected() {
        return this.isConnected.get();
    }

    public void setConnected(boolean connected) {
        this.isConnected.set(connected);
    }

    void onError(Object payload, Exception e) {
        switch (this.onErrorAction) {
            case STREAM: {
                throw new SiddhiAppRuntimeException("Dropping event at Sink '" + this.type + "' at '" + this.streamDefinition.getId() + "' as its still trying to reconnect!, event dropped '" + payload + "'", e);
            }
            case WAIT: {
                this.retryWait(this.backoffPublishRetryCounter.getTimeIntervalMillis());
                this.backoffPublishRetryCounter.increment();
                this.publish(payload);
                break;
            }
            default: {
                LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Dropping event at Sink '" + this.type + "' at '" + this.streamDefinition.getId() + "' as its still trying to reconnect!, events dropped '" + payload + "'"));
            }
        }
    }

    private void retryWait(long waitTime) {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static enum OnErrorAction {
        LOG,
        WAIT,
        STREAM;

    }
}

