/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.input.source;

import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.input.source.AttributeMapping;
import org.wso2.siddhi.core.stream.input.source.InputEventHandlerCallback;
import org.wso2.siddhi.core.util.ExceptionUtil;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.util.statistics.metrics.Level;
import org.wso2.siddhi.core.util.timestamp.TimestampGenerator;

public class InputEventHandler {
    private static final Logger LOG = Logger.getLogger(InputEventHandler.class);
    private final ThreadLocal<String[]> trpProperties;
    private final TimestampGenerator timestampGenerator;
    private ThreadLocal<String[]> trpSyncProperties;
    private String sourceType;
    private LatencyTracker latencyTracker;
    private SiddhiAppContext siddhiAppContext;
    private InputHandler inputHandler;
    private List<AttributeMapping> transportMapping;
    private InputEventHandlerCallback inputEventHandlerCallback;

    InputEventHandler(InputHandler inputHandler, List<AttributeMapping> transportMapping, ThreadLocal<String[]> trpProperties, ThreadLocal<String[]> trpSyncProperties, String sourceType, LatencyTracker latencyTracker, SiddhiAppContext siddhiAppContext, InputEventHandlerCallback inputEventHandlerCallback) {
        this.inputHandler = inputHandler;
        this.transportMapping = transportMapping;
        this.trpProperties = trpProperties;
        this.trpSyncProperties = trpSyncProperties;
        this.sourceType = sourceType;
        this.latencyTracker = latencyTracker;
        this.siddhiAppContext = siddhiAppContext;
        this.inputEventHandlerCallback = inputEventHandlerCallback;
        this.timestampGenerator = siddhiAppContext.getTimestampGenerator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(Event event) throws InterruptedException {
        try {
            if (this.latencyTracker != null && Level.DETAIL.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                this.latencyTracker.markOut();
            }
            String[] transportProperties = this.trpProperties.get();
            this.trpProperties.remove();
            String[] transportSyncProperties = this.trpSyncProperties.get();
            this.trpSyncProperties.remove();
            if (event.getTimestamp() == -1L) {
                long currentTimestamp = this.timestampGenerator.currentTime();
                event.setTimestamp(currentTimestamp);
            }
            for (int i = 0; i < this.transportMapping.size(); ++i) {
                AttributeMapping attributeMapping = this.transportMapping.get(i);
                event.getData()[attributeMapping.getPosition()] = transportProperties[i];
            }
            this.inputEventHandlerCallback.sendEvent(event, transportSyncProperties);
        }
        catch (RuntimeException e) {
            LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error in applying transport property mapping for '" + this.sourceType + "' source at '" + this.inputHandler.getStreamId() + "' stream."), (Throwable)e);
        }
        finally {
            this.trpProperties.remove();
            this.trpSyncProperties.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvents(Event[] events) throws InterruptedException {
        try {
            if (this.latencyTracker != null && Level.DETAIL.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                this.latencyTracker.markOut();
            }
            String[] transportProperties = this.trpProperties.get();
            this.trpProperties.remove();
            String[] transportSyncProperties = this.trpSyncProperties.get();
            this.trpSyncProperties.remove();
            long currentTimestamp = this.timestampGenerator.currentTime();
            for (Event event : events) {
                if (event.getTimestamp() == -1L) {
                    event.setTimestamp(currentTimestamp);
                }
                for (int i = 0; i < this.transportMapping.size(); ++i) {
                    AttributeMapping attributeMapping = this.transportMapping.get(i);
                    event.getData()[attributeMapping.getPosition()] = transportProperties[i];
                }
            }
            this.inputEventHandlerCallback.sendEvents(events, transportSyncProperties);
        }
        catch (RuntimeException e) {
            LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error in applying transport property mapping for '" + this.sourceType + "' source at '" + this.inputHandler.getStreamId() + "' stream."), (Throwable)e);
        }
        finally {
            this.trpProperties.remove();
            this.trpSyncProperties.remove();
        }
    }
}

