/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.time;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import org.wso2.siddhi.core.util.Schedulable;

public class FirstPerTimeOutputRateLimiter
extends OutputRateLimiter
implements Schedulable {
    private static final Logger log = Logger.getLogger(FirstPerTimeOutputRateLimiter.class);
    private final Long value;
    private String id;
    private ScheduledExecutorService scheduledExecutorService;
    private String queryName;
    private Long outputTime;

    public FirstPerTimeOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, String queryName) {
        this.queryName = queryName;
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        FirstPerTimeOutputRateLimiter instance = new FirstPerTimeOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, this.queryName);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<Object> outputEventChunk = new ComplexEventChunk<Object>(complexEventChunk.isBatch());
        complexEventChunk.reset();
        FirstPerTimeOutputRateLimiter firstPerTimeOutputRateLimiter = this;
        synchronized (firstPerTimeOutputRateLimiter) {
            long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
            if (this.outputTime == null || this.outputTime + this.value <= currentTime) {
                this.outputTime = currentTime;
                Object event = complexEventChunk.next();
                complexEventChunk.remove();
                outputEventChunk.add(event);
            }
        }
        if (outputEventChunk.getFirst() != null) {
            this.sendToCallBacks(outputEventChunk);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("OutputTime", this.outputTime);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.outputTime = (Long)state.get("OutputTime");
    }
}

