/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.time;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.GroupedComplexEvent;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import org.wso2.siddhi.core.util.Schedulable;

public class FirstGroupByPerTimeOutputRateLimiter
extends OutputRateLimiter
implements Schedulable {
    private static final Logger log = Logger.getLogger(FirstGroupByPerTimeOutputRateLimiter.class);
    private final Long value;
    private String id;
    private Map<String, Long> groupByOutputTime = new HashMap<String, Long>();
    private ScheduledExecutorService scheduledExecutorService;
    private String queryName;

    public FirstGroupByPerTimeOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, String queryName) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.queryName = queryName;
        this.id = id;
        this.value = value;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        FirstGroupByPerTimeOutputRateLimiter instance = new FirstGroupByPerTimeOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, this.queryName);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<GroupedComplexEvent> outputEventChunk = new ComplexEventChunk<GroupedComplexEvent>(complexEventChunk.isBatch());
        complexEventChunk.reset();
        FirstGroupByPerTimeOutputRateLimiter firstGroupByPerTimeOutputRateLimiter = this;
        synchronized (firstGroupByPerTimeOutputRateLimiter) {
            long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
            while (complexEventChunk.hasNext()) {
                Object event = complexEventChunk.next();
                complexEventChunk.remove();
                GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)event;
                Long outputTime = this.groupByOutputTime.get(groupedComplexEvent.getGroupKey());
                if (outputTime != null && outputTime + this.value > currentTime) continue;
                this.groupByOutputTime.put(groupedComplexEvent.getGroupKey(), currentTime);
                outputEventChunk.add(groupedComplexEvent);
            }
        }
        if (outputEventChunk.getFirst() != null) {
            this.sendToCallBacks(outputEventChunk);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        FirstGroupByPerTimeOutputRateLimiter firstGroupByPerTimeOutputRateLimiter = this;
        synchronized (firstGroupByPerTimeOutputRateLimiter) {
            state.put("GroupByOutputTime", this.groupByOutputTime);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreState(Map<String, Object> state) {
        FirstGroupByPerTimeOutputRateLimiter firstGroupByPerTimeOutputRateLimiter = this;
        synchronized (firstGroupByPerTimeOutputRateLimiter) {
            this.groupByOutputTime = (Map)state.get("GroupByOutputTime");
        }
    }
}

