/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.event;

import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;

public class FirstPerEventOutputRateLimiter
extends OutputRateLimiter {
    private final Integer value;
    private String id;
    private volatile int counter = 0;

    public FirstPerEventOutputRateLimiter(String id, Integer value) {
        this.value = value;
        this.id = id;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        FirstPerEventOutputRateLimiter instance = new FirstPerEventOutputRateLimiter(this.id + key, this.value);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<Object> outputEventChunk = new ComplexEventChunk<Object>(complexEventChunk.isBatch());
        complexEventChunk.reset();
        FirstPerEventOutputRateLimiter firstPerEventOutputRateLimiter = this;
        synchronized (firstPerEventOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object event = complexEventChunk.next();
                complexEventChunk.remove();
                ++this.counter;
                if (this.counter == 1) {
                    outputEventChunk.add(event);
                    continue;
                }
                if (this.counter != this.value) continue;
                this.counter = 0;
            }
        }
        if (outputEventChunk.getFirst() != null) {
            this.sendToCallBacks(outputEventChunk);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("Counter", this.counter);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.counter = (Integer)state.get("Counter");
    }
}

