/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.event;

import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.GroupedComplexEvent;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;

public class FirstGroupByPerEventOutputRateLimiter
extends OutputRateLimiter {
    private final Integer value;
    private String id;
    private Map<String, Integer> groupByOutputTime = new HashMap<String, Integer>();

    public FirstGroupByPerEventOutputRateLimiter(String id, Integer value) {
        this.id = id;
        this.value = value;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        FirstGroupByPerEventOutputRateLimiter instance = new FirstGroupByPerEventOutputRateLimiter(this.id + key, this.value);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<GroupedComplexEvent> outputEventChunk = new ComplexEventChunk<GroupedComplexEvent>(complexEventChunk.isBatch());
        complexEventChunk.reset();
        FirstGroupByPerEventOutputRateLimiter firstGroupByPerEventOutputRateLimiter = this;
        synchronized (firstGroupByPerEventOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object event = complexEventChunk.next();
                complexEventChunk.remove();
                GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)event;
                Integer count = this.groupByOutputTime.get(groupedComplexEvent.getGroupKey());
                if (count == null) {
                    this.groupByOutputTime.put(groupedComplexEvent.getGroupKey(), 1);
                    outputEventChunk.add(groupedComplexEvent);
                    continue;
                }
                if (count.equals(this.value - 1)) {
                    this.groupByOutputTime.remove(groupedComplexEvent.getGroupKey());
                    continue;
                }
                this.groupByOutputTime.put(groupedComplexEvent.getGroupKey(), count + 1);
            }
        }
        if (outputEventChunk.getFirst() != null) {
            this.sendToCallBacks(outputEventChunk);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        FirstGroupByPerEventOutputRateLimiter firstGroupByPerEventOutputRateLimiter = this;
        synchronized (firstGroupByPerEventOutputRateLimiter) {
            state.put("GroupByOutputCount", this.groupByOutputTime);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreState(Map<String, Object> state) {
        FirstGroupByPerEventOutputRateLimiter firstGroupByPerEventOutputRateLimiter = this;
        synchronized (firstGroupByPerEventOutputRateLimiter) {
            this.groupByOutputTime = (Map)state.get("GroupByOutputCount");
        }
    }
}

