/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input.stream.state;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.state.StateEventCloner;
import org.wso2.siddhi.core.event.state.StateEventPool;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.query.input.stream.state.AbsentPreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.PreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.StreamPostStateProcessor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;

public class StreamPreStateProcessor
implements PreStateProcessor,
Snapshotable {
    protected int stateId;
    protected boolean isStartState;
    protected volatile boolean stateChanged = false;
    protected StateInputStream.Type stateType;
    protected long withinTime = -1L;
    protected int[] startStateIds;
    protected PreStateProcessor withinEveryPreStateProcessor;
    protected SiddhiAppContext siddhiAppContext;
    protected String elementId;
    protected StreamPostStateProcessor thisStatePostProcessor;
    protected StreamPostStateProcessor thisLastProcessor;
    protected Processor nextProcessor;
    protected ComplexEventChunk<StateEvent> currentStateEventChunk = new ComplexEventChunk(false);
    protected LinkedList<StateEvent> pendingStateEventList = new LinkedList();
    protected LinkedList<StateEvent> newAndEveryStateEventList = new LinkedList();
    protected ReentrantLock lock = new ReentrantLock();
    protected StateEventPool stateEventPool;
    protected StreamEventCloner streamEventCloner;
    protected StateEventCloner stateEventCloner;
    protected StreamEventPool streamEventPool;
    protected String queryName;
    private boolean initialized;

    public StreamPreStateProcessor(StateInputStream.Type stateType) {
        this.stateType = stateType;
    }

    public void init(SiddhiAppContext siddhiAppContext, String queryName) {
        this.siddhiAppContext = siddhiAppContext;
        this.queryName = queryName;
        if (this.elementId == null) {
            this.elementId = "StreamPreStateProcessor-" + siddhiAppContext.getElementIdGenerator().createNewId();
        }
        siddhiAppContext.getSnapshotService().addSnapshotable(queryName, this);
    }

    @Override
    public StreamPostStateProcessor getThisStatePostProcessor() {
        return this.thisStatePostProcessor;
    }

    public void setThisStatePostProcessor(StreamPostStateProcessor thisStatePostProcessor) {
        this.thisStatePostProcessor = thisStatePostProcessor;
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        throw new IllegalStateException("process method of StreamPreStateProcessor should not be called. processAndReturn method is used for handling event chunks.");
    }

    protected boolean isExpired(StateEvent pendingStateEvent, long currentTimestamp) {
        if (!this.isStartState && this.withinTime != -1L) {
            for (int startStateId : this.startStateIds) {
                StreamEvent streamEvent = pendingStateEvent.getStreamEvent(startStateId);
                if (streamEvent == null || Math.abs(pendingStateEvent.getStreamEvent(startStateId).getTimestamp() - currentTimestamp) <= this.withinTime) continue;
                return true;
            }
        }
        return false;
    }

    protected void process(StateEvent stateEvent) {
        this.currentStateEventChunk.add(stateEvent);
        this.currentStateEventChunk.reset();
        this.stateChanged = false;
        this.nextProcessor.process(this.currentStateEventChunk);
        this.currentStateEventChunk.reset();
    }

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        this.nextProcessor = processor;
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.setToLast(processor);
        }
    }

    @Override
    public void init() {
        if (this.isStartState && (!this.initialized || this.thisStatePostProcessor.nextEveryStatePreProcessor != null || this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextStatePreProcessor instanceof AbsentPreStateProcessor)) {
            StateEvent stateEvent = this.stateEventPool.borrowEvent();
            this.addState(stateEvent);
            this.initialized = true;
        }
    }

    public StreamPostStateProcessor getThisLastProcessor() {
        return this.thisLastProcessor;
    }

    public void setThisLastProcessor(StreamPostStateProcessor thisLastProcessor) {
        this.thisLastProcessor = thisLastProcessor;
    }

    @Override
    public PreStateProcessor cloneProcessor(String key) {
        StreamPreStateProcessor streamPreStateProcessor = new StreamPreStateProcessor(this.stateType);
        this.cloneProperties(streamPreStateProcessor, key);
        streamPreStateProcessor.init(this.siddhiAppContext, this.queryName);
        return streamPreStateProcessor;
    }

    protected void cloneProperties(StreamPreStateProcessor streamPreStateProcessor, String key) {
        streamPreStateProcessor.stateId = this.stateId;
        streamPreStateProcessor.isStartState = this.isStartState;
        streamPreStateProcessor.elementId = this.elementId + "-" + key;
        streamPreStateProcessor.stateEventPool = this.stateEventPool;
        streamPreStateProcessor.streamEventCloner = this.streamEventCloner;
        streamPreStateProcessor.stateEventCloner = this.stateEventCloner;
        streamPreStateProcessor.streamEventPool = this.streamEventPool;
        streamPreStateProcessor.withinTime = this.withinTime;
        streamPreStateProcessor.startStateIds = this.startStateIds;
    }

    @Override
    public void addState(StateEvent stateEvent) {
        this.lock.lock();
        try {
            if (this.stateType == StateInputStream.Type.SEQUENCE) {
                if (this.newAndEveryStateEventList.isEmpty()) {
                    this.newAndEveryStateEventList.add(stateEvent);
                }
            } else {
                this.newAndEveryStateEventList.add(stateEvent);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addEveryState(StateEvent stateEvent) {
        this.lock.lock();
        try {
            StateEvent clonedEvent = this.stateEventCloner.copyStateEvent(stateEvent);
            this.newAndEveryStateEventList.add(clonedEvent);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setWithinEveryPreStateProcessor(PreStateProcessor withinEveryPreStateProcessor) {
        this.withinEveryPreStateProcessor = withinEveryPreStateProcessor;
    }

    public void stateChanged() {
        this.stateChanged = true;
    }

    @Override
    public void setStartState(boolean isStartState) {
        this.isStartState = isStartState;
    }

    @Override
    public boolean isStartState() {
        return this.isStartState;
    }

    public void setStateEventPool(StateEventPool stateEventPool) {
        this.stateEventPool = stateEventPool;
    }

    public void setStreamEventPool(StreamEventPool streamEventPool) {
        this.streamEventPool = streamEventPool;
    }

    public void setStreamEventCloner(StreamEventCloner streamEventCloner) {
        this.streamEventCloner = streamEventCloner;
    }

    public void setStateEventCloner(StateEventCloner stateEventCloner) {
        this.stateEventCloner = stateEventCloner;
    }

    @Override
    public void resetState() {
        this.lock.lock();
        try {
            this.pendingStateEventList.clear();
            if (this.isStartState && this.newAndEveryStateEventList.isEmpty()) {
                if (this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextEveryStatePreProcessor == null && !((StreamPreStateProcessor)this.thisStatePostProcessor.nextStatePreProcessor).pendingStateEventList.isEmpty()) {
                    return;
                }
                this.init();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void updateState() {
        this.lock.lock();
        try {
            this.pendingStateEventList.addAll(this.newAndEveryStateEventList);
            this.newAndEveryStateEventList.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StateEvent> returnEventChunk = new ComplexEventChunk<StateEvent>(false);
        complexEventChunk.reset();
        StreamEvent streamEvent = (StreamEvent)complexEventChunk.next();
        this.lock.lock();
        try {
            Iterator iterator = this.pendingStateEventList.iterator();
            while (iterator.hasNext()) {
                StateEvent stateEvent = (StateEvent)iterator.next();
                if (this.isExpired(stateEvent, streamEvent.getTimestamp())) {
                    iterator.remove();
                    if (this.withinEveryPreStateProcessor == null) continue;
                    this.withinEveryPreStateProcessor.addEveryState(stateEvent);
                    this.withinEveryPreStateProcessor.updateState();
                    continue;
                }
                stateEvent.setEvent(this.stateId, this.streamEventCloner.copyStreamEvent(streamEvent));
                this.process(stateEvent);
                if (this.thisLastProcessor.isEventReturned()) {
                    this.thisLastProcessor.clearProcessedEvent();
                    returnEventChunk.add(stateEvent);
                }
                if (this.stateChanged) {
                    iterator.remove();
                    continue;
                }
                switch (this.stateType) {
                    case PATTERN: {
                        stateEvent.setEvent(this.stateId, null);
                        break;
                    }
                    case SEQUENCE: {
                        stateEvent.setEvent(this.stateId, null);
                        if (this.removeOnNoStateChange(this.stateType)) {
                            iterator.remove();
                        }
                        if (this.thisStatePostProcessor.callbackPreStateProcessor == null) break;
                        this.thisStatePostProcessor.callbackPreStateProcessor.startStateReset();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return returnEventChunk;
    }

    protected boolean removeOnNoStateChange(StateInputStream.Type stateType) {
        return stateType == StateInputStream.Type.SEQUENCE;
    }

    @Override
    public int getStateId() {
        return this.stateId;
    }

    @Override
    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("FirstEvent", this.currentStateEventChunk.getFirst());
        state.put("PendingStateEventList", this.pendingStateEventList);
        state.put("NewAndEveryStateEventList", this.newAndEveryStateEventList);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.currentStateEventChunk.clear();
        this.currentStateEventChunk.add((StateEvent)state.get("FirstEvent"));
        this.pendingStateEventList = (LinkedList)state.get("PendingStateEventList");
        this.newAndEveryStateEventList = (LinkedList)state.get("NewAndEveryStateEventList");
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public void clean() {
        if (this.nextProcessor != null) {
            this.nextProcessor.clean();
        }
        this.siddhiAppContext.getSnapshotService().removeSnapshotable(this.queryName, this);
    }

    @Override
    public void setWithinTime(long withinTime) {
        this.withinTime = withinTime;
    }

    @Override
    public void setStartStateIds(int[] stateIds) {
        this.startStateIds = stateIds;
    }
}

