/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.aggregation;

import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.aggregation.AggregationRuntime;
import org.wso2.siddhi.core.aggregation.IncrementalExecutor;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.query.StoreQueryRuntime;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.IncrementalTimeConverterUtil;
import org.wso2.siddhi.core.util.parser.StoreQueryParser;
import org.wso2.siddhi.core.window.Window;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;
import org.wso2.siddhi.query.api.execution.query.StoreQuery;
import org.wso2.siddhi.query.api.execution.query.input.store.InputStore;
import org.wso2.siddhi.query.api.execution.query.selection.OrderByAttribute;
import org.wso2.siddhi.query.api.execution.query.selection.Selector;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.condition.Compare;
import org.wso2.siddhi.query.api.expression.constant.Constant;

public class RecreateInMemoryData {
    private final List<TimePeriod.Duration> incrementalDurations;
    private final Map<TimePeriod.Duration, Table> aggregationTables;
    private final Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap;
    private final Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMapForPartitions;
    private final SiddhiAppContext siddhiAppContext;
    private final StreamEventPool streamEventPool;
    private final Map<String, Table> tableMap;
    private final Map<String, Window> windowMap;
    private final Map<String, AggregationRuntime> aggregationMap;
    private final String shardId;

    public RecreateInMemoryData(List<TimePeriod.Duration> incrementalDurations, Map<TimePeriod.Duration, Table> aggregationTables, Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap, SiddhiAppContext siddhiAppContext, MetaStreamEvent metaStreamEvent, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap, String shardId, Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMapForPartitions) {
        this.incrementalDurations = incrementalDurations;
        this.aggregationTables = aggregationTables;
        this.incrementalExecutorMap = incrementalExecutorMap;
        this.siddhiAppContext = siddhiAppContext;
        this.streamEventPool = new StreamEventPool(metaStreamEvent, 10);
        this.tableMap = tableMap;
        this.windowMap = windowMap;
        this.aggregationMap = aggregationMap;
        this.shardId = shardId;
        this.incrementalExecutorMapForPartitions = incrementalExecutorMapForPartitions;
    }

    public void recreateInMemoryData(boolean isFirstEventArrived, boolean refreshReadingExecutors) {
        IncrementalExecutor rootExecutor = this.incrementalExecutorMap.get(this.incrementalDurations.get(0));
        if (rootExecutor.isProcessingExecutor() && rootExecutor.getNextEmitTime() != -1L && !refreshReadingExecutors) {
            return;
        }
        if (isFirstEventArrived) {
            for (Map.Entry<TimePeriod.Duration, IncrementalExecutor> durationIncrementalExecutorEntry : this.incrementalExecutorMap.entrySet()) {
                IncrementalExecutor incrementalExecutor = durationIncrementalExecutorEntry.getValue();
                incrementalExecutor.setProcessingExecutor(true);
                incrementalExecutor.setValuesForInMemoryRecreateFromTable(-1L);
            }
        }
        Long endOFLatestEventTimestamp = null;
        Table tableForMaxDuration = this.aggregationTables.get(this.incrementalDurations.get(this.incrementalDurations.size() - 1));
        StoreQuery storeQuery = this.shardId == null || refreshReadingExecutors ? StoreQuery.query().from((InputStore)InputStore.store((String)tableForMaxDuration.getTableDefinition().getId())).select(Selector.selector().orderBy(Expression.variable((String)"AGG_TIMESTAMP"), OrderByAttribute.Order.DESC).limit((Constant)Expression.value((int)1))) : StoreQuery.query().from(InputStore.store((String)tableForMaxDuration.getTableDefinition().getId()).on(Expression.compare((Expression)Expression.variable((String)"SHARD_ID"), (Compare.Operator)Compare.Operator.EQUAL, (Expression)Expression.value((String)this.shardId)))).select(Selector.selector().orderBy(Expression.variable((String)"AGG_TIMESTAMP"), OrderByAttribute.Order.DESC).limit((Constant)Expression.value((int)1)));
        storeQuery.setType(StoreQuery.StoreQueryType.FIND);
        StoreQueryRuntime storeQueryRuntime = StoreQueryParser.parse(storeQuery, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
        Event[] events = storeQueryRuntime.execute();
        if (events != null) {
            Long lastData = (Long)events[events.length - 1].getData(0);
            endOFLatestEventTimestamp = IncrementalTimeConverterUtil.getNextEmitTime(lastData, this.incrementalDurations.get(this.incrementalDurations.size() - 1), null);
        }
        for (int i = this.incrementalDurations.size() - 1; i > 0; --i) {
            TimePeriod.Duration recreateForDuration = this.incrementalDurations.get(i);
            IncrementalExecutor incrementalExecutor = refreshReadingExecutors ? this.incrementalExecutorMapForPartitions.get(recreateForDuration) : this.incrementalExecutorMap.get(recreateForDuration);
            incrementalExecutor.clearExecutor();
            Table recreateFromTable = this.aggregationTables.get(this.incrementalDurations.get(i - 1));
            storeQuery = this.shardId == null || refreshReadingExecutors ? (endOFLatestEventTimestamp == null ? StoreQuery.query().from((InputStore)InputStore.store((String)recreateFromTable.getTableDefinition().getId())).select(Selector.selector().orderBy(Expression.variable((String)"AGG_TIMESTAMP"))) : StoreQuery.query().from(InputStore.store((String)recreateFromTable.getTableDefinition().getId()).on(Expression.compare((Expression)Expression.variable((String)"AGG_TIMESTAMP"), (Compare.Operator)Compare.Operator.GREATER_THAN_EQUAL, (Expression)Expression.value((long)endOFLatestEventTimestamp)))).select(Selector.selector().orderBy(Expression.variable((String)"AGG_TIMESTAMP")))) : (endOFLatestEventTimestamp == null ? StoreQuery.query().from(InputStore.store((String)recreateFromTable.getTableDefinition().getId()).on(Expression.compare((Expression)Expression.variable((String)"SHARD_ID"), (Compare.Operator)Compare.Operator.EQUAL, (Expression)Expression.value((String)this.shardId)))).select(Selector.selector().orderBy(Expression.variable((String)"AGG_TIMESTAMP"))) : StoreQuery.query().from(InputStore.store((String)recreateFromTable.getTableDefinition().getId()).on(Expression.and((Expression)Expression.compare((Expression)Expression.variable((String)"SHARD_ID"), (Compare.Operator)Compare.Operator.EQUAL, (Expression)Expression.value((String)this.shardId)), (Expression)Expression.compare((Expression)Expression.variable((String)"AGG_TIMESTAMP"), (Compare.Operator)Compare.Operator.GREATER_THAN_EQUAL, (Expression)Expression.value((long)endOFLatestEventTimestamp))))).select(Selector.selector().orderBy(Expression.variable((String)"AGG_TIMESTAMP"))));
            storeQuery.setType(StoreQuery.StoreQueryType.FIND);
            storeQueryRuntime = StoreQueryParser.parse(storeQuery, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
            events = storeQueryRuntime.execute();
            if (events == null) continue;
            long referenceToNextLatestEvent = (Long)events[events.length - 1].getData(0);
            endOFLatestEventTimestamp = IncrementalTimeConverterUtil.getNextEmitTime(referenceToNextLatestEvent, this.incrementalDurations.get(i - 1), null);
            ComplexEventChunk<StreamEvent> complexEventChunk = new ComplexEventChunk<StreamEvent>(false);
            for (Event event : events) {
                StreamEvent streamEvent = this.streamEventPool.borrowEvent();
                streamEvent.setOutputData(event.getData());
                complexEventChunk.add(streamEvent);
            }
            incrementalExecutor.execute(complexEventChunk);
            if (i != 1) continue;
            TimePeriod.Duration rootDuration = this.incrementalDurations.get(0);
            IncrementalExecutor rootIncrementalExecutor = refreshReadingExecutors ? this.incrementalExecutorMapForPartitions.get(rootDuration) : this.incrementalExecutorMap.get(rootDuration);
            long emitTimeOfLatestEventInTable = IncrementalTimeConverterUtil.getNextEmitTime(referenceToNextLatestEvent, rootDuration, null);
            rootIncrementalExecutor.setValuesForInMemoryRecreateFromTable(emitTimeOfLatestEventInTable);
        }
    }
}

